/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.vst.remote;

import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.VSTEffect;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UIScrollBarPanelLayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIScale;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class VSTEffectEditor {
    private VSTEffect effect;
    private TGContext context;
    private UIWindow dialog;

    public VSTEffectEditor(TGContext context, VSTEffect effect) {
        this.context = context;
        this.effect = effect;
    }

    public void open(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(parent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText("VST Effect");
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText("VST Effect Parameters");
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIScrollBarPanel scrollBarPanel = uiFactory.createScrollBarPanel((UIContainer)group, true, false, false);
        scrollBarPanel.setLayout((UILayout)new UIScrollBarPanelLayout(false, true, true, true, false, true));
        scrollBarPanel.getVScroll().setIncrement(10);
        scrollBarPanel.getVScroll().addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                scrollBarPanel.layout();
            }
        });
        groupLayout.set((UIControl)scrollBarPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), Float.valueOf(400.0f), null);
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = uiFactory.createPanel((UIContainer)scrollBarPanel, false);
        panel.setLayout((UILayout)panelLayout);
        int params = this.effect.getNumParams();
        params = params > 50 ? 50 : params;
        for (int i = 0; i < params; ++i) {
            final int index = i;
            float value = this.effect.getParameter(i);
            String name = this.effect.getParameterName(i);
            String label = this.effect.getParameterLabel(i);
            UILabel labelParameterName = uiFactory.createLabel((UIContainer)panel);
            labelParameterName.setText(name != null ? name : "");
            panelLayout.set((UIControl)labelParameterName, Integer.valueOf(1 + i), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            UILabel labelParameterLabel = uiFactory.createLabel((UIContainer)panel);
            labelParameterLabel.setText(label != null ? label : "");
            panelLayout.set((UIControl)labelParameterLabel, Integer.valueOf(1 + i), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            final UIScale scaleParameterValue = uiFactory.createHorizontalScale((UIContainer)panel);
            scaleParameterValue.setMaximum(100);
            scaleParameterValue.setMinimum(0);
            scaleParameterValue.setIncrement(1);
            scaleParameterValue.setValue(Math.round(100.0f * value));
            panelLayout.set((UIControl)scaleParameterValue, Integer.valueOf(1 + i), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
            final UILabel labelParameterValue = uiFactory.createLabel((UIContainer)panel);
            labelParameterValue.setText(Float.toString(value));
            panelLayout.set((UIControl)labelParameterValue, Integer.valueOf(1 + i), Integer.valueOf(4), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            scaleParameterValue.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    float selection = (float)scaleParameterValue.getValue() / 100.0f;
                    labelParameterValue.setText(Float.toString(selection));
                    VSTEffectEditor.this.effect.setParameter(index, selection);
                }
            });
        }
        if (this.effect.isEditorAvailable()) {
            UIButton nativeEditor = uiFactory.createButton((UIContainer)this.dialog);
            nativeEditor.setText("Native Editor");
            nativeEditor.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    new Thread(new Runnable(){

                        public void run() throws TGException {
                            VSTEffectEditor.this.toggleNativeEditor();
                        }
                    }).start();
                }
            });
            dialogLayout.set((UIControl)nativeEditor, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        }
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public void openInUiThread(final UIWindow parent) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() {
                VSTEffectEditor.this.open(parent);
            }
        });
    }

    public void close() {
        if (this.isOpen()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public boolean isOpen() {
        return this.dialog != null && !this.dialog.isDisposed();
    }

    public void toggleNativeEditor() {
        if (this.effect.isNativeEditorOpen()) {
            this.effect.closeNativeEditor();
        } else {
            this.effect.openNativeEditor();
        }
    }
}

