/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.player.base.MidiRepeatController;
import org.herac.tuxguitar.song.models.TGMeasureHeader;

public class MidiTickUtil {
    public static long getStart(long tick) {
        long startPoint;
        long start = startPoint = MidiTickUtil.getStartPoint();
        long length = 0L;
        TGDocumentManager manager = TuxGuitar.getInstance().getDocumentManager();
        MidiRepeatController controller = new MidiRepeatController(manager.getSong(), MidiTickUtil.getSHeader(), MidiTickUtil.getEHeader());
        while (!controller.finished()) {
            TGMeasureHeader header = manager.getSong().getMeasureHeader(controller.getIndex());
            controller.process();
            if (!controller.shouldPlay() || tick < (start += (length = header.getLength())) || tick >= start + length) continue;
            return header.getStart() + (tick - start);
        }
        return tick < startPoint ? startPoint : start;
    }

    public static long getTick(long start) {
        long startPoint;
        long tick = startPoint = MidiTickUtil.getStartPoint();
        long length = 0L;
        TGDocumentManager manager = TuxGuitar.getInstance().getDocumentManager();
        MidiRepeatController controller = new MidiRepeatController(manager.getSong(), MidiTickUtil.getSHeader(), MidiTickUtil.getEHeader());
        while (!controller.finished()) {
            TGMeasureHeader header = manager.getSong().getMeasureHeader(controller.getIndex());
            controller.process();
            if (!controller.shouldPlay()) continue;
            tick += length;
            length = header.getLength();
            if (start < header.getStart() || start >= header.getStart() + length) continue;
            return tick;
        }
        return start < startPoint ? startPoint : tick;
    }

    private static long getStartPoint() {
        TuxGuitar.getInstance().getPlayer().updateLoop(false);
        return TuxGuitar.getInstance().getPlayer().getLoopSPosition();
    }

    public static int getSHeader() {
        return TuxGuitar.getInstance().getPlayer().getLoopSHeader();
    }

    public static int getEHeader() {
        return TuxGuitar.getInstance().getPlayer().getLoopEHeader();
    }
}

