/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.editor;

import org.herac.tuxguitar.app.editor.TGExternalBeatViewerEvent;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.util.TGAbstractContext;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGExternalBeatViewerManager {
    private TGContext context;

    public TGExternalBeatViewerManager(TGContext context) {
        this.context = context;
    }

    public void showExternalBeat(TGBeat beat) {
        this.showExternalBeat(beat, null);
    }

    public void showExternalBeat(final TGBeat beat, final TGAbstractContext context) {
        this.asyncRunLocked(new Runnable(){

            public void run() {
                TGExternalBeatViewerManager.this.doShowExternalBeat(beat, context);
            }
        });
    }

    public void hideExternalBeat() {
        this.hideExternalBeat(null);
    }

    public void hideExternalBeat(final TGAbstractContext context) {
        this.asyncRunLocked(new Runnable(){

            public void run() {
                TGExternalBeatViewerManager.this.doHideExternalBeat(context);
            }
        });
    }

    public void addBeatViewerListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-external-beat-viewer", listener);
    }

    public void removeBeatViewerListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-external-beat-viewer", listener);
    }

    private void doShowExternalBeat(TGBeat beat, TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGExternalBeatViewerEvent("show", beat, context));
    }

    private void doHideExternalBeat(TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGExternalBeatViewerEvent("hide", context));
    }

    public void asyncRunLocked(Runnable runnable) {
        TGEditorManager.getInstance((TGContext)this.context).asyncRunLocked(runnable);
    }

    public static TGExternalBeatViewerManager getInstance(TGContext context) {
        return (TGExternalBeatViewerManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGExternalBeatViewerManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGExternalBeatViewerManager>(){

            public TGExternalBeatViewerManager createInstance(TGContext context) {
                return new TGExternalBeatViewerManager(context);
            }
        });
    }
}

