/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.widget;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.ui.event.UICloseListener;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.qt.event.QTTabFolderCloseListenerManager;
import org.herac.tuxguitar.ui.qt.event.QTTabFolderSelectionListenerManager;
import org.herac.tuxguitar.ui.qt.widget.QTContainer;
import org.herac.tuxguitar.ui.qt.widget.QTTabItem;
import org.herac.tuxguitar.ui.qt.widget.QTWidget;
import org.herac.tuxguitar.ui.widget.UITabFolder;
import org.herac.tuxguitar.ui.widget.UITabItem;
import org.qtjambi.qt.widgets.QTabWidget;
import org.qtjambi.qt.widgets.QWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTTabFolder
extends QTWidget<QTabWidget>
implements UITabFolder {
    private List<QTTabItem> tabs = new ArrayList<QTTabItem>();
    private QTTabFolderCloseListenerManager closeListener = new QTTabFolderCloseListenerManager(this);
    private QTTabFolderSelectionListenerManager selectionListener = new QTTabFolderSelectionListenerManager(this);

    public QTTabFolder(QTContainer parent, boolean showClose) {
        super(new QTabWidget(parent.getContainerControl()), parent);
        ((QTabWidget)this.getControl()).setTabsClosable(showClose);
    }

    @Override
    public void dispose() {
        ArrayList<QTTabItem> items = new ArrayList<QTTabItem>(this.tabs);
        for (QTTabItem item : items) {
            if (item.isDisposed()) continue;
            item.dispose();
        }
        super.dispose();
    }

    public void addTab(QTTabItem tabItem) {
        ((QTabWidget)this.getControl()).addTab((QWidget)tabItem.getControl(), new String());
        this.tabs.add(tabItem);
    }

    public void removeTab(QTTabItem tabItem) {
        int index = this.getTabIndex(tabItem);
        if (index >= 0) {
            this.tabs.remove(index);
            ((QTabWidget)this.getControl()).removeTab(index);
        }
    }

    public int getTabIndex(UITabItem tab) {
        return this.tabs.indexOf(tab);
    }

    public UITabItem createTab() {
        return new QTTabItem(this);
    }

    public List<UITabItem> getTabs() {
        return new ArrayList<UITabItem>(this.tabs);
    }

    public UITabItem getTab(int index) {
        return index >= 0 && index < this.tabs.size() ? this.tabs.get(index) : null;
    }

    public UITabItem getSelectedTab() {
        return this.getTab(this.getSelectedIndex());
    }

    public void setSelectedTab(UITabItem tab) {
        int index = this.getTabIndex(tab);
        if (index >= 0) {
            this.setSelectedIndex(index);
        }
    }

    public int getSelectedIndex() {
        return ((QTabWidget)this.getControl()).currentIndex();
    }

    public void setSelectedIndex(int index) {
        ((QTabWidget)this.getControl()).setCurrentIndex(index);
    }

    public void addSelectionListener(UISelectionListener listener) {
        if (this.selectionListener.isEmpty()) {
            ((QTabWidget)this.getControl()).currentChanged.connect((Object)this.selectionListener, "handle(Integer)");
        }
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
        if (this.selectionListener.isEmpty()) {
            ((QTabWidget)this.getControl()).currentChanged.disconnect();
        }
    }

    public void addTabCloseListener(UICloseListener listener) {
        if (this.closeListener.isEmpty()) {
            ((QTabWidget)this.getControl()).tabCloseRequested.connect((Object)this.closeListener, "handle(Integer)");
        }
        this.closeListener.addListener(listener);
    }

    public void removeTabCloseListener(UICloseListener listener) {
        if (this.closeListener.isEmpty()) {
            ((QTabWidget)this.getControl()).tabCloseRequested.disconnect();
        }
        this.closeListener.addListener(listener);
    }
}

