/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.resource;

import org.herac.tuxguitar.ui.qt.QTComponent;
import org.herac.tuxguitar.ui.qt.resource.QTColor;
import org.herac.tuxguitar.ui.qt.resource.QTFont;
import org.herac.tuxguitar.ui.qt.resource.QTImage;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIFontAlignment;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.qtjambi.qt.core.QRect;
import org.qtjambi.qt.core.Qt;
import org.qtjambi.qt.gui.QBrush;
import org.qtjambi.qt.gui.QColor;
import org.qtjambi.qt.gui.QFont;
import org.qtjambi.qt.gui.QImage;
import org.qtjambi.qt.gui.QPainter;
import org.qtjambi.qt.gui.QPainterPath;
import org.qtjambi.qt.gui.QPen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTPainter
extends QTComponent<QPainter>
implements UIPainter {
    private int style;
    private boolean pathEmpty;
    private QPainterPath path;
    private UIFontAlignment fontAlignment;

    public QTPainter(QPainter handle) {
        super(handle);
        ((QPainter)this.getControl()).setBackground(new QBrush(new QColor(0, 0, 0, 0)));
    }

    public void initPath(int style) {
        this.style = style;
        this.path = new QPainterPath();
        this.pathEmpty = true;
        this.setAntialias(true);
    }

    public void initPath() {
        this.initPath(1);
    }

    public void closePath() {
        if (!this.pathEmpty) {
            if ((this.style & 1) != 0) {
                ((QPainter)this.getControl()).drawPath(this.path);
            }
            if ((this.style & 2) != 0) {
                ((QPainter)this.getControl()).fillPath(this.path, ((QPainter)this.getControl()).background());
            }
        }
        this.style = 0;
        this.path.dispose();
        this.pathEmpty = true;
        this.setAntialias(false);
    }

    @Override
    public void dispose() {
        ((QPainter)this.getControl()).end();
        super.dispose();
    }

    public void drawString(String string, float x, float y) {
        this.setAdvanced(false);
        ((QPainter)this.getControl()).drawText(this.toInt(x), this.toInt(y), string);
    }

    public void drawImage(UIImage image, float srcX, float srcY, float srcWidth, float srcHeight, float destX, float destY, float destWidth, float destHeight) {
        this.setAdvanced(false);
        ((QPainter)this.getControl()).drawImage(this.toRect(destX, destY, destWidth, destHeight), this.getImage(image), this.toRect(srcX, srcY, srcWidth, srcHeight));
    }

    public void drawImage(UIImage image, float x, float y) {
        this.setAdvanced(false);
        ((QPainter)this.getControl()).drawImage(this.toInt(x), this.toInt(y), this.getImage(image));
    }

    public void cubicTo(float arg0, float arg1, float arg2, float arg3, float arg4, float arg5) {
        this.path.cubicTo((double)arg0, (double)arg1, (double)arg2, (double)arg3, (double)arg4, (double)arg5);
        this.pathEmpty = false;
    }

    public void lineTo(float arg0, float arg1) {
        this.path.lineTo((double)arg0, (double)arg1);
        this.pathEmpty = false;
    }

    public void moveTo(float arg0, float arg1) {
        this.path.moveTo((double)arg0, (double)arg1);
        this.pathEmpty = false;
    }

    public void addCircle(float x, float y, float width) {
        this.path.arcMoveTo((double)(x - width / 2.0f), (double)(y - width / 2.0f), (double)width, (double)width, 0.0);
        this.path.arcTo((double)(x - width / 2.0f), (double)(y - width / 2.0f), (double)width, (double)width, 0.0, 360.0);
        this.pathEmpty = false;
    }

    public void addRectangle(float x, float y, float width, float height) {
        this.path.addRect((double)x, (double)y, (double)width, (double)height);
        this.pathEmpty = false;
    }

    public void setFont(UIFont font) {
        ((QPainter)this.getControl()).setFont(this.getFont(font));
        this.fontAlignment = this.getFontAlignment(font);
    }

    public void setBackground(UIColor color) {
        ((QPainter)this.getControl()).setBackground(new QBrush((QColor)((QTColor)color).getControl()));
    }

    public void setForeground(UIColor color) {
        QPen qPen = ((QPainter)this.getControl()).pen();
        qPen.setColor((QColor)((QTColor)color).getControl());
        ((QPainter)this.getControl()).setPen(qPen);
    }

    public void setLineWidth(float width) {
        QPen qPen = ((QPainter)this.getControl()).pen();
        qPen.setWidthF((double)width);
        ((QPainter)this.getControl()).setPen(qPen);
    }

    public void setLineStyleSolid() {
        QPen qPen = ((QPainter)this.getControl()).pen();
        qPen.setStyle(Qt.PenStyle.SolidLine);
        ((QPainter)this.getControl()).setPen(qPen);
    }

    public void setLineStyleDot() {
        QPen qPen = ((QPainter)this.getControl()).pen();
        qPen.setStyle(Qt.PenStyle.DotLine);
        ((QPainter)this.getControl()).setPen(qPen);
    }

    public void setLineStyleDash() {
        QPen qPen = ((QPainter)this.getControl()).pen();
        qPen.setStyle(Qt.PenStyle.DashLine);
        ((QPainter)this.getControl()).setPen(qPen);
    }

    public void setLineStyleDashDot() {
        QPen qPen = ((QPainter)this.getControl()).pen();
        qPen.setStyle(Qt.PenStyle.DashDotLine);
        ((QPainter)this.getControl()).setPen(qPen);
    }

    public void setAlpha(int alpha) {
    }

    public void setAntialias(boolean enabled) {
        ((QPainter)this.getControl()).setRenderHint(QPainter.RenderHint.Antialiasing, enabled);
    }

    public void setAdvanced(boolean advanced) {
        this.setAntialias(advanced);
    }

    public float getFontSize() {
        return ((QPainter)this.getControl()).font().pointSize();
    }

    public float getFMTopLine() {
        return this.fontAlignment != null ? this.fontAlignment.getTop() : 0.0f;
    }

    public float getFMMiddleLine() {
        return this.fontAlignment != null ? this.fontAlignment.getMiddle() : 0.0f;
    }

    public float getFMBaseLine() {
        return this.fontAlignment != null ? this.fontAlignment.getBottom() : 0.0f;
    }

    public float getFMHeight() {
        return ((QPainter)this.getControl()).fontMetrics().height();
    }

    public float getFMWidth(String text) {
        return ((QPainter)this.getControl()).fontMetrics().width(text);
    }

    public QRect toRect(float x, float y, float width, float height) {
        return new QRect(this.toInt(x), this.toInt(y), this.toInt(width), this.toInt(height));
    }

    public QImage getImage(UIImage image) {
        if (image instanceof QTImage) {
            return (QImage)((QTImage)image).getControl();
        }
        return null;
    }

    public QColor getColor(UIColor color) {
        if (color instanceof QTColor) {
            return (QColor)((QTColor)color).getControl();
        }
        return null;
    }

    public QFont getFont(UIFont font) {
        if (font instanceof QTFont) {
            return (QFont)((QTFont)font).getControl();
        }
        return null;
    }

    public UIFontAlignment getFontAlignment(UIFont font) {
        if (font instanceof QTFont) {
            return ((QTFont)font).getAlignment();
        }
        return null;
    }

    public int toInt(float value) {
        return Math.round(value);
    }
}

