/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.resource;

import org.herac.tuxguitar.ui.resource.UIKey;
import org.herac.tuxguitar.ui.resource.UIKeyConvination;
import org.qtjambi.qt.QtEnumerator;
import org.qtjambi.qt.core.Qt;
import org.qtjambi.qt.gui.QKeyEvent;

public class QTKey {
    private static final QTKeyMap[] KEY_MAP = new QTKeyMap[]{new QTKeyMap(Qt.Key.Key_F1, UIKey.F1), new QTKeyMap(Qt.Key.Key_F2, UIKey.F2), new QTKeyMap(Qt.Key.Key_F3, UIKey.F3), new QTKeyMap(Qt.Key.Key_F4, UIKey.F4), new QTKeyMap(Qt.Key.Key_F5, UIKey.F5), new QTKeyMap(Qt.Key.Key_F6, UIKey.F6), new QTKeyMap(Qt.Key.Key_F7, UIKey.F7), new QTKeyMap(Qt.Key.Key_F8, UIKey.F8), new QTKeyMap(Qt.Key.Key_F9, UIKey.F9), new QTKeyMap(Qt.Key.Key_F10, UIKey.F10), new QTKeyMap(Qt.Key.Key_F11, UIKey.F11), new QTKeyMap(Qt.Key.Key_F12, UIKey.F12), new QTKeyMap(Qt.Key.Key_Escape, UIKey.ESC), new QTKeyMap(Qt.Key.Key_Pause, UIKey.PAUSE), new QTKeyMap(Qt.Key.Key_Print, UIKey.PRINT_SCREEN), new QTKeyMap(Qt.Key.Key_Insert, UIKey.INSERT), new QTKeyMap(Qt.Key.Key_Delete, UIKey.DELETE), new QTKeyMap(Qt.Key.Key_HomePage, UIKey.HOME), new QTKeyMap(Qt.Key.Key_PageUp, UIKey.PAGE_UP), new QTKeyMap(Qt.Key.Key_PageDown, UIKey.PAGE_DOWN), new QTKeyMap(Qt.Key.Key_End, UIKey.END), new QTKeyMap(Qt.Key.Key_Alt, UIKey.ALT), new QTKeyMap(Qt.Key.Key_AltGr, UIKey.ALT), new QTKeyMap(Qt.Key.Key_Control, UIKey.CONTROL), new QTKeyMap(Qt.Key.Key_Meta, UIKey.COMMAND), new QTKeyMap(Qt.Key.Key_Shift, UIKey.SHIFT), new QTKeyMap(Qt.Key.Key_Tab, UIKey.TAB), new QTKeyMap(Qt.Key.Key_Backspace, UIKey.BACKSPACE), new QTKeyMap(Qt.Key.Key_Space, UIKey.SPACE), new QTKeyMap(Qt.Key.Key_Enter, UIKey.ENTER), new QTKeyMap(Qt.Key.Key_Up, UIKey.UP), new QTKeyMap(Qt.Key.Key_Down, UIKey.DOWN), new QTKeyMap(Qt.Key.Key_Left, UIKey.LEFT), new QTKeyMap(Qt.Key.Key_Right, UIKey.RIGHT), new QTKeyMap(Qt.Key.Key_Plus, new UIKey("+")), new QTKeyMap(Qt.Key.Key_Minus, new UIKey("-")), new QTKeyMap(Qt.Key.Key_Comma, new UIKey(",")), new QTKeyMap(Qt.Key.Key_Period, new UIKey(".")), new QTKeyMap(Qt.Key.Key_Slash, new UIKey("/")), new QTKeyMap(Qt.Key.Key_multiply, new UIKey("*")), new QTKeyMap(Qt.Key.Key_Less, new UIKey("<")), new QTKeyMap(Qt.Key.Key_Greater, new UIKey(">"))};

    public static UIKey getKey(QKeyEvent keyEvent) {
        int keyCode = keyEvent.key();
        for (QTKeyMap keyMap : KEY_MAP) {
            if (keyMap.getCode().value() != keyCode) continue;
            return keyMap.getKey();
        }
        return new UIKey(Character.toString((char)(keyEvent.key() & 0xFFFF)).toLowerCase());
    }

    public static UIKeyConvination getConvination(QKeyEvent keyEvent) {
        UIKey principalKey;
        UIKeyConvination keyConvination = new UIKeyConvination();
        Qt.KeyboardModifiers modifiers = keyEvent.modifiers();
        if (modifiers.isSet((QtEnumerator[])new Qt.KeyboardModifier[]{Qt.KeyboardModifier.AltModifier})) {
            keyConvination.getKeys().add(UIKey.ALT);
        }
        if (modifiers.isSet((QtEnumerator[])new Qt.KeyboardModifier[]{Qt.KeyboardModifier.ShiftModifier})) {
            keyConvination.getKeys().add(UIKey.SHIFT);
        }
        if (modifiers.isSet((QtEnumerator[])new Qt.KeyboardModifier[]{Qt.KeyboardModifier.ControlModifier})) {
            keyConvination.getKeys().add(UIKey.CONTROL);
        }
        if (modifiers.isSet((QtEnumerator[])new Qt.KeyboardModifier[]{Qt.KeyboardModifier.MetaModifier})) {
            keyConvination.getKeys().add(UIKey.COMMAND);
        }
        if (!keyConvination.contains(principalKey = QTKey.getKey(keyEvent))) {
            keyConvination.getKeys().add(principalKey);
        }
        return keyConvination;
    }

    private static class QTKeyMap {
        private Qt.Key code;
        private UIKey key;

        public QTKeyMap(Qt.Key code, UIKey key) {
            this.code = code;
            this.key = key;
        }

        public Qt.Key getCode() {
            return this.code;
        }

        public UIKey getKey() {
            return this.key;
        }
    }
}

