/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.sql;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.qtjambi.qt.core.QDate;
import org.qtjambi.qt.core.QDateTime;
import org.qtjambi.qt.core.QTime;
import org.qtjambi.qt.core.QUrl;
import org.qtjambi.qt.sql.QSqlError;
import org.qtjambi.qt.sql.QSqlField;

class QJdbcSqlUtil {
    private static HashMap<String, Integer> javaToVariant = new HashMap();

    QJdbcSqlUtil() {
    }

    static int javaTypeToVariantType(String javaType) {
        Integer variantType = javaToVariant.get(javaType);
        if (variantType == null) {
            return 127;
        }
        return variantType;
    }

    static int javaTypeIdToVariantType(int variantType) {
        switch (variantType) {
            case 1: 
            case 12: {
                return 10;
            }
            case -6: 
            case 4: 
            case 5: {
                return 2;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -5: 
            case 3: {
                return 4;
            }
            case 91: {
                return 14;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return 6;
            }
            case 92: {
                return 15;
            }
            case 93: {
                return 16;
            }
        }
        return 127;
    }

    static QSqlField.RequiredStatus toRequiredStatus(int isNullable) {
        switch (isNullable) {
            case 0: {
                return QSqlField.RequiredStatus.Required;
            }
            case 1: {
                return QSqlField.RequiredStatus.Optional;
            }
        }
        return QSqlField.RequiredStatus.Unknown;
    }

    static QSqlError getError(SQLException ex, String driverText, QSqlError.ErrorType t) {
        StringBuilder dbText = new StringBuilder();
        int errorCode = 0;
        for (SQLException e = ex; e != null; e = e.getNextException()) {
            if (dbText.length() != 0) {
                dbText.append(", ");
            }
            dbText.append(e.getMessage()).append(" (").append(e.getSQLState()).append(")");
            errorCode = e.getErrorCode();
        }
        return new QSqlError(driverText, dbText.toString(), t, errorCode);
    }

    static Object javaToQt(Object input) {
        if (input instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)input;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            return new QDate(c.get(1), c.get(2) + 1, c.get(5));
        }
        if (input instanceof Time) {
            Time time = (Time)input;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(time);
            return new QTime(c.get(10), c.get(12) + 1, c.get(13));
        }
        if (input instanceof Date) {
            Date date = (Date)input;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            return new QDateTime(new QDate(c.get(1), c.get(2) + 1, c.get(5)), new QTime(c.get(11), c.get(12), c.get(13), c.get(14)));
        }
        if (input instanceof URL) {
            URL url = (URL)input;
            return new QUrl(url.toString());
        }
        return input;
    }

    static Object qtToJava(Object input) {
        if (input instanceof QDateTime) {
            QDateTime dt = (QDateTime)input;
            QDate date = dt.date();
            QTime time = dt.time();
            return new Timestamp(date.year() - 1900, date.month() - 1, date.day(), time.hour(), time.minute(), time.second(), time.msec());
        }
        if (input instanceof QDate) {
            QDate date = (QDate)input;
            return new java.sql.Date(date.year() - 1900, date.month() - 1, date.day());
        }
        if (input instanceof QTime) {
            QTime time = (QTime)input;
            return new Time(time.hour(), time.minute(), time.second());
        }
        if (input instanceof QUrl) {
            QUrl url = (QUrl)input;
            try {
                return new URL(url.toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return input;
            }
        }
        return input;
    }

    static {
        javaToVariant.put(null, 0);
        javaToVariant.put("java.lang.String", 10);
        javaToVariant.put("java.lang.Integer", 2);
        javaToVariant.put("java.lang.Short", 2);
        javaToVariant.put("java.lang.Byte", 2);
        javaToVariant.put("java.lang.Boolean", 1);
        javaToVariant.put("java.lang.Byte[]", 12);
        javaToVariant.put("java.util.Date", 14);
        javaToVariant.put("java.sql.Date", 14);
        javaToVariant.put("java.lang.Float", 6);
        javaToVariant.put("java.lang.Double", 6);
        javaToVariant.put("java.lang.Long", 4);
        javaToVariant.put("java.sql.Time", 15);
        javaToVariant.put("java.sql.TimeStamp", 16);
        javaToVariant.put("java.net.Url", 17);
    }
}

