/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.internal.fileengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.zip.ZipException;
import org.qtjambi.qt.QNativePointer;
import org.qtjambi.qt.Utilities;
import org.qtjambi.qt.core.QAbstractFileEngine;
import org.qtjambi.qt.core.QAbstractFileEngineIterator;
import org.qtjambi.qt.core.QDateTime;
import org.qtjambi.qt.core.QDir;
import org.qtjambi.qt.core.QFileDevice;
import org.qtjambi.qt.core.QFileInfo;
import org.qtjambi.qt.core.QIODevice;
import org.qtjambi.qt.internal.fileengine.JarCache;
import org.qtjambi.qt.internal.fileengine.MyJarFile;
import org.qtjambi.qt.internal.fileengine.QClassPathEntry;
import org.qtjambi.qt.internal.fileengine.QClassPathFileEngineHandler;
import org.qtjambi.qt.internal.fileengine.QClassPathFileEngineIterator;
import org.qtjambi.qt.internal.fileengine.QFSEntryEngine;
import org.qtjambi.qt.internal.fileengine.QJarEntryEngine;
import org.qtjambi.qt.osinfo.OSInfo;
import org.qtjambi.qt.qtjambi.util.RetroTranslatorHelper;

@Deprecated
public class QClassPathEngine
extends QAbstractFileEngine {
    public static final String FileNameDelim = "#";
    public static final String FileNameIndicator = "classpath";
    public static final String FileNamePrefix = "classpath:";
    private static HashSet<String> classpaths;
    private String m_fileName = "";
    private String m_baseName = "";
    private String m_selectedSource = "*";
    private LinkedList<QAbstractFileEngine> m_engines = new LinkedList();
    private static String currentDirectory;
    private String namespaceSchemePrefix = "classpath";

    public QClassPathEngine(String fileName) {
        this.setFileName(fileName);
    }

    public QClassPathEngine(String fileName, String namespaceSchemePrefix) {
        this.namespaceSchemePrefix = namespaceSchemePrefix;
        this.setFileName(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String resolveCurrentDirectory() {
        String tmpCurrentDirectory = currentDirectory;
        if (tmpCurrentDirectory != null) {
            return tmpCurrentDirectory;
        }
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            tmpCurrentDirectory = currentDirectory;
            if (tmpCurrentDirectory != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return tmpCurrentDirectory;
            }
            File fileCurDir = new File(".");
            if (fileCurDir.isDirectory()) {
                String removeDelimAndDot;
                tmpCurrentDirectory = fileCurDir.getAbsolutePath();
                if (tmpCurrentDirectory.endsWith(removeDelimAndDot = File.separator + ".")) {
                    tmpCurrentDirectory = tmpCurrentDirectory.substring(0, tmpCurrentDirectory.length() - removeDelimAndDot.length());
                }
            } else {
                tmpCurrentDirectory = System.getProperty("user.dir");
            }
            currentDirectory = tmpCurrentDirectory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmpCurrentDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentDirectory(String newCurrentDirectory) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            currentDirectory = newCurrentDirectory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUrl(String path) {
        String tmpPath;
        String goodPath = null;
        if (path == null) {
            return goodPath;
        }
        int pathLength = path.length();
        boolean skipTryAsis = false;
        if (pathLength > 0) {
            char firstChar = path.charAt(0);
            if (firstChar == File.separatorChar) {
                skipTryAsis = true;
            } else if (pathLength == 1) {
                String tmpPath2;
                if (firstChar == '.' && (tmpPath2 = QClassPathEngine.resolveCurrentDirectory()) != null) {
                    path = tmpPath2;
                    skipTryAsis = true;
                }
            } else if (pathLength > 1) {
                char secondChar = path.charAt(1);
                if (firstChar == '.' && secondChar == File.separatorChar) {
                    tmpPath = QClassPathEngine.resolveCurrentDirectory();
                    if (tmpPath != null) {
                        path = tmpPath + File.separatorChar + path.substring(2);
                        skipTryAsis = true;
                    }
                } else if (pathLength > 2) {
                    char thirdChar = path.charAt(2);
                    if (firstChar >= 'A' && firstChar <= 'Z' || firstChar >= 'a' && firstChar <= 'z') {
                        if (secondChar == ':' && thirdChar == '\\') {
                            skipTryAsis = true;
                        }
                        if (secondChar == ':' && thirdChar == '/') {
                            skipTryAsis = true;
                        }
                    } else if (pathLength > 3) {
                        char fourthChar = path.charAt(3);
                        if ((firstChar == '/' && secondChar >= 'A' && secondChar <= 'Z' || secondChar >= 'a' && secondChar <= 'z') && thirdChar == ':' && fourthChar == '/') {
                            skipTryAsis = true;
                        }
                    }
                }
            }
            if (!skipTryAsis) {
                boolean prefix = true;
                if (path.startsWith("file:") || path.startsWith("jar:") || path.startsWith("http:") || path.startsWith("https:")) {
                    prefix = false;
                }
                if (prefix && (tmpPath = QClassPathEngine.resolveCurrentDirectory()) != null) {
                    path = tmpPath + File.separatorChar + path;
                    skipTryAsis = true;
                }
            }
        }
        Exception urlParseException = null;
        if (goodPath == null && !skipTryAsis) {
            try {
                URL url = new URL(path);
                if (url.getProtocol().length() > 0) {
                    goodPath = path;
                }
            }
            catch (Exception e) {
                urlParseException = e;
            }
        }
        Exception urlParseException2 = null;
        if (goodPath == null) {
            try {
                tmpPath = "file:" + path;
                String xPath = path.replace('\\', '/');
                String xPrefix = path.length() > 0 && xPath.charAt(0) != '/' ? "file:///" : "file://";
                String newTmpPath = xPrefix;
                newTmpPath = File.separatorChar == '\\' ? newTmpPath + path.replace('\\', '/') : newTmpPath + path;
                String newTmpPathY = Utilities.convertAbsolutePathStringToFileUrlString(path);
                URL url = new URL(newTmpPath);
                if (url.getProtocol().length() > 0) {
                    goodPath = newTmpPath;
                }
            }
            catch (Exception e) {
                urlParseException2 = e;
            }
        }
        URLConnection urlConn = null;
        InputStream inStream = null;
        try {
            URL openUrl = new URL(goodPath);
            URLAlias urlAlias = QClassPathEngine.checkNeedWorkaround(openUrl);
            if (urlAlias.file != null) {
                if (urlAlias.file.isFile()) {
                    inStream = new FileInputStream(urlAlias.file);
                }
            } else {
                urlConn = urlAlias.url.openConnection();
                inStream = urlConn.getInputStream();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return goodPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSearchPath(String path, boolean allowDuplicate) {
        boolean bf = false;
        String urlString = QClassPathEngine.makeUrl(path);
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            if (classpaths == null) {
                QClassPathEngine.findClassPaths();
            }
            if (urlString != null && (allowDuplicate || !classpaths.contains(urlString))) {
                classpaths.add(urlString);
                bf = true;
            }
            JarCache.reset(classpaths);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return bf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSearchPath(String path) {
        boolean bf = false;
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            String urlString;
            if (classpaths != null && (urlString = QClassPathEngine.makeUrl(path)) != null) {
                bf = classpaths.remove(urlString);
                JarCache.reset(classpaths);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bf;
        }
    }

    @Override
    public void setFileName(String fileName) {
        int first;
        if (fileName.equals(this.fileName())) {
            return;
        }
        this.cleanUp();
        if (!fileName.startsWith(FileNamePrefix)) {
            throw new IllegalArgumentException("Invalid format of path: '" + fileName + "'");
        }
        this.m_fileName = fileName.substring(FileNamePrefix.length());
        String[] searchPath = RetroTranslatorHelper.split(this.m_fileName, FileNameDelim, 2);
        this.m_selectedSource = "*";
        if (searchPath.length == 1) {
            this.m_baseName = searchPath[0];
        } else {
            this.m_baseName = searchPath[1];
            this.m_selectedSource = searchPath[0];
        }
        int last = this.m_baseName.length();
        for (first = 0; first < last && this.m_baseName.charAt(first) == '/'; ++first) {
        }
        if (this.m_baseName.endsWith("/")) {
            --last;
        }
        this.m_baseName = last < first ? "" : this.m_baseName.substring(first, last).replace('\\', '/');
        if (classpaths == null) {
            QClassPathEngine.findClassPaths();
        }
        if ("*".equals(this.m_selectedSource)) {
            List<String> pathToPotentialJars = JarCache.pathToJarFiles(this.m_baseName);
            if (pathToPotentialJars != null) {
                for (String pathToJar : pathToPotentialJars) {
                    this.addJarFileFromPath(pathToJar, this.m_baseName, true);
                }
            } else {
                int pos = this.m_baseName.lastIndexOf("/");
                String parentSearch = pos < 0 ? "" : this.m_baseName.substring(0, pos);
                List<String> pathToJars = JarCache.pathToJarFiles(parentSearch);
                if (pathToJars != null) {
                    for (String pathToJar : pathToJars) {
                        this.addJarFileFromPath(pathToJar, this.m_baseName, false);
                    }
                }
                for (String path : JarCache.classPathDirs()) {
                    try {
                        this.addFromPath(new URL(QClassPathEngine.makeUrl(path)), this.m_baseName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            try {
                String urlString = QClassPathEngine.makeUrl(this.m_selectedSource);
                URL url = new URL(urlString);
                File fileOnlyIfDirectory = null;
                if ("file".equals(url.getProtocol())) {
                    String pathString = url.getPath();
                    if (File.separatorChar == '\\') {
                        pathString = pathString.replace('/', '\\');
                    }
                    if (!(fileOnlyIfDirectory = new File(pathString)).isDirectory()) {
                        fileOnlyIfDirectory = null;
                    }
                }
                if (fileOnlyIfDirectory != null) {
                    this.addFromPath(url, this.m_baseName);
                }
                this.addJarFileFromPath(new URL("jar:" + urlString + "!/"), this.m_baseName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean copy(String newName) {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.copy(newName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPermissions(int perms) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                if (!engine.setPermissions(perms)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public boolean caseSensitive() {
        return true;
    }

    @Override
    public boolean close() {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> entryList(QDir.Filters filters, List<String> filterNames) {
        List<String> result = null;
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                if (result == null) {
                    result = engine.entryList(filters, filterNames);
                    continue;
                }
                List<String> list = engine.entryList(filters, filterNames);
                result.removeAll(list);
                result.addAll(list);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QAbstractFileEngine.FileFlags fileFlags(QAbstractFileEngine.FileFlags type) {
        QAbstractFileEngine.FileFlags flags = new QAbstractFileEngine.FileFlags(new QAbstractFileEngine.FileFlag[0]);
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                flags.set(engine.fileFlags(type));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if ("/".equals(this.fileName(QAbstractFileEngine.FileName.PathName))) {
                flags.set(new QAbstractFileEngine.FileFlag[]{QAbstractFileEngine.FileFlag.RootFlag});
            }
            flags.clear(new QAbstractFileEngine.FileFlag[]{QAbstractFileEngine.FileFlag.LocalDiskFlag});
            return flags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String fileName(QAbstractFileEngine.FileName file) {
        QAbstractFileEngine afe = null;
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            String classPathEntry;
            int engineCount = this.m_engines.size();
            if (engineCount > 0) {
                afe = this.m_engines.getFirst();
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (engineCount == 0) {
                return "";
            }
            if (engineCount == 1) {
                if (!(afe instanceof QClassPathEntry)) throw new RuntimeException("Bogus engine in class path file engine");
                classPathEntry = ((QClassPathEntry)((Object)afe)).classPathEntryName();
            } else {
                classPathEntry = "*";
            }
            String result = "";
            if (file == QAbstractFileEngine.FileName.DefaultName) {
                return FileNamePrefix + this.m_fileName;
            }
            if (file == QAbstractFileEngine.FileName.CanonicalName) return this.fileName(QAbstractFileEngine.FileName.CanonicalPathName) + "/" + this.fileName(QAbstractFileEngine.FileName.BaseName);
            if (file == QAbstractFileEngine.FileName.LinkName) {
                return this.fileName(QAbstractFileEngine.FileName.CanonicalPathName) + "/" + this.fileName(QAbstractFileEngine.FileName.BaseName);
            }
            if (file == QAbstractFileEngine.FileName.AbsoluteName) return FileNamePrefix + classPathEntry + FileNameDelim + this.m_baseName;
            if (file == QAbstractFileEngine.FileName.LinkName) {
                return FileNamePrefix + classPathEntry + FileNameDelim + this.m_baseName;
            }
            if (file == QAbstractFileEngine.FileName.BaseName) {
                int pos = this.m_baseName.lastIndexOf("/");
                return pos > 0 ? this.m_baseName.substring(pos + 1) : this.m_baseName;
            }
            if (file == QAbstractFileEngine.FileName.PathName) {
                int pos = this.m_baseName.lastIndexOf("/");
                if (pos <= 0) return "";
                String string = this.m_baseName.substring(0, pos);
                return string;
            }
            if (file == QAbstractFileEngine.FileName.AbsolutePathName) {
                return FileNamePrefix + classPathEntry + FileNameDelim + this.fileName(QAbstractFileEngine.FileName.PathName);
            }
            if (file != QAbstractFileEngine.FileName.CanonicalPathName) throw new IllegalArgumentException("Unknown file name type: " + file);
            return afe.fileName(file);
        }
    }

    @Override
    public QDateTime fileTime(QAbstractFileEngine.FileTime time) {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.fileTime(time);
        }
        return new QDateTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean link(String newName) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                if (!engine.link(newName)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mkdir(String dirName, boolean createParentDirectories) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                if (!engine.mkdir(dirName, createParentDirectories)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public boolean open(QIODevice.OpenMode openMode) {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            boolean result = afe.open(openMode);
            if (result) {
                this.setError(QFileDevice.FileError.NoError, "");
            }
            return result;
        }
        return false;
    }

    @Override
    public long pos() {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.pos();
        }
        return -1L;
    }

    @Override
    public long read(QNativePointer data, long maxlen) {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.read(data, maxlen);
        }
        return -1L;
    }

    @Override
    public long readLine(QNativePointer data, long maxlen) {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.readLine(data, maxlen);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove() {
        boolean ok = true;
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                ok = ok && engine.remove();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ok;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(String newName) {
        boolean ok = true;
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                ok = ok && engine.rename(newName);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ok;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rmdir(String dirName, boolean recursive) {
        boolean ok = true;
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                ok = ok && engine.rmdir(dirName, recursive);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ok;
        }
    }

    @Override
    public boolean seek(long offset) {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.seek(offset);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String owner(QAbstractFileEngine.FileOwner owner) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine afe : this.m_engines) {
                String result = afe.owner(owner);
                if (result == null || result.length() <= 0) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ownerId(QAbstractFileEngine.FileOwner owner) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine afe : this.m_engines) {
                int result = afe.ownerId(owner);
                if (result == -2) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -2;
        }
    }

    @Override
    public boolean isRelativePath() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSequential() {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            for (QAbstractFileEngine engine : this.m_engines) {
                if (!engine.isSequential()) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public boolean setSize(long sz) {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.setSize(sz);
        }
        return false;
    }

    @Override
    public long size() {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return this.m_engines.get(0).size();
        }
        return -1L;
    }

    @Override
    public long write(QNativePointer data, long len) {
        QAbstractFileEngine afe = this.getFirstEngine();
        if (afe != null) {
            return afe.write(data, len);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            if (this.m_engines != null) {
                this.m_engines.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean addFromPath(URL url, String fileName) {
        QFileInfo file;
        String path = url.getPath();
        if (OSInfo.isWindows() && path.length() > 2 && path.charAt(2) == ':' && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ("file".equals(url.getProtocol()) && (file = new QFileInfo(path)).isDir() && file.exists() && new QFileInfo(path + "/" + fileName).exists()) {
            this.addEngine(new QFSEntryEngine(path + "/" + fileName, url.toExternalForm()));
            return true;
        }
        return false;
    }

    private boolean addJarFileFromPath(MyJarFile myJarFile, String fileName, boolean directory) throws IOException {
        QJarEntryEngine engine = new QJarEntryEngine(myJarFile, fileName, directory);
        if (engine.isValid()) {
            this.addEngine(engine);
            return true;
        }
        engine.disown();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addJarFileFromPath(String pathToJarFile, String fileName, boolean directory) {
        boolean bf = false;
        MyJarFile myJarFile = null;
        try {
            File fileToJarFile = new File(pathToJarFile);
            myJarFile = new MyJarFile(fileToJarFile);
            bf = this.addJarFileFromPath(myJarFile, fileName, directory);
            if (bf) {
                myJarFile = null;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (myJarFile != null) {
                myJarFile.put();
                myJarFile = null;
            }
        }
        return bf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkIsDirectory(MyJarFile myJarFile, JarEntry fileInJar) {
        InputStream inStream = null;
        try {
            inStream = myJarFile.getInputStream(fileInJar);
            if (inStream == null) {
                boolean bl = true;
                return bl;
            }
            inStream.read();
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
                inStream = null;
            }
        }
        return false;
    }

    static String stripSuffix(String s, String suffix, String defaultValue) {
        if (s.endsWith(suffix)) {
            int endIndex = s.length() - suffix.length();
            return s.substring(0, endIndex);
        }
        return defaultValue;
    }

    static String stripUrlFileColonPrefix(String urlString, String defaultValue) {
        int len = urlString.length();
        String PREFIX_FILE = "file:";
        if (urlString.startsWith("file:")) {
            int skipCount;
            for (skipCount = "file:".length(); len > skipCount; ++skipCount) {
                char c = urlString.charAt(skipCount);
                if (c == '/') continue;
                if (skipCount <= 0) break;
                --skipCount;
                break;
            }
            if (skipCount > 0) {
                urlString = urlString.substring(skipCount);
            }
            return urlString;
        }
        return defaultValue;
    }

    static URLAlias checkNeedWorkaround(URL url) {
        String SEPARATOR = "!/";
        File file = null;
        if ("jar".equals(url.getProtocol())) {
            String PREFIX_JAR_FILE = "jar:file:";
            String externalForm = url.toExternalForm();
            if (externalForm.startsWith("jar:file:")) {
                int externalFormLength;
                String path = url.getPath();
                int index = externalForm.indexOf("!/");
                if (index == (externalFormLength = externalForm.length()) - 2) {
                    String urlString = QClassPathEngine.stripUrlFileColonPrefix(path, path);
                    urlString = QClassPathEngine.stripSuffix(urlString, "!/", urlString);
                    file = new File(urlString);
                    try {
                        url = new URL(path);
                    }
                    catch (MalformedURLException eat) {
                        url = null;
                    }
                }
            }
        } else if ("file".equals(url.getProtocol())) {
            String path = url.getPath();
            String urlString = QClassPathEngine.stripUrlFileColonPrefix(path, path);
            urlString = QClassPathEngine.stripSuffix(urlString, "!/", urlString);
            file = new File(urlString);
        }
        URLAlias urlAlias = new URLAlias();
        urlAlias.url = url;
        urlAlias.file = file;
        return urlAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJarFileFromPath(URL jarFileURL, String fileName) {
        Object urlConnection = null;
        MyJarFile myJarFile = null;
        try {
            myJarFile = QClassPathEngine.resolveUrlToMyJarFile(jarFileURL);
            if (myJarFile == null) {
                return;
            }
            boolean isDirectory = false;
            JarEntry fileInJar = myJarFile.getJarEntry(fileName);
            if (fileInJar != null && !(isDirectory = fileInJar.isDirectory())) {
                boolean tmpIsDirectory;
                isDirectory = tmpIsDirectory = QClassPathEngine.checkIsDirectory(myJarFile, fileInJar);
            }
            if (!isDirectory) {
                List<String> pathToJarFiles = JarCache.pathToJarFiles(fileName);
                String jarFileName = myJarFile.getName();
                if (pathToJarFiles != null) {
                    for (String thisPathToJar : pathToJarFiles) {
                        if (!thisPathToJar.equals(jarFileName)) continue;
                        isDirectory = true;
                        break;
                    }
                }
                if (!isDirectory) {
                    String fileNameWithSlash = fileName + "/";
                    Enumeration<JarEntry> entries = myJarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.startsWith(fileNameWithSlash)) continue;
                        isDirectory = true;
                        break;
                    }
                }
            }
            if (this.addJarFileFromPath(myJarFile, fileName, isDirectory)) {
                myJarFile = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myJarFile != null) {
                myJarFile.put();
                myJarFile = null;
            }
            if (urlConnection != null) {
                urlConnection = null;
            }
        }
    }

    private static void urlConnectionCloser(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)conn;
            httpURLConnection.disconnect();
            return;
        }
        if (conn instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)conn;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEngine(QAbstractFileEngine engine) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            this.m_engines.add(engine);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findClassPaths() {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            classpaths = new HashSet();
            ArrayList<URL> cpUrls = new ArrayList<URL>();
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = QClassPathFileEngineHandler.class.getClassLoader();
                }
                Enumeration<URL> urls = loader.getResources("META-INF/MANIFEST.MF");
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (!"jar".equals(url.getProtocol())) continue;
                    try {
                        String f = url.getPath();
                        int bang = f.indexOf("!");
                        if (bang >= 0) {
                            f = f.substring(0, bang);
                        }
                        if (f.trim().length() <= 0) continue;
                        classpaths.add(f);
                        cpUrls.add(new URL(f));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String javaClassPath = System.getProperty("java.class.path");
            if (javaClassPath == null) {
                javaClassPath = "";
            }
            String[] paths = RetroTranslatorHelper.split(javaClassPath, File.pathSeparator);
            int k = 0;
            for (String p : paths) {
                boolean match;
                String urlString;
                block25: {
                    block24: {
                        if (p.trim().length() <= 0) continue;
                        ++k;
                        urlString = QClassPathEngine.makeUrl(p);
                        match = false;
                        try {
                            File fileA;
                            URL url = new URL(urlString);
                            if ("file".equals(url.getProtocol()) && (fileA = new File(url.getPath())).isDirectory()) {
                                classpaths.add(Utilities.convertAbsolutePathStringToFileUrlString(fileA));
                            }
                            break block24;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    MyJarFile myJarFile2 = null;
                    MyJarFile myJarFile1 = null;
                    try {
                        myJarFile2 = QClassPathEngine.resolveUrlToMyJarFile(urlString);
                        if (myJarFile2 == null) break block25;
                        for (URL otherURL : cpUrls) {
                            myJarFile1 = QClassPathEngine.resolveUrlToMyJarFile(otherURL);
                            if (myJarFile1 == null) continue;
                            File file1 = new File(myJarFile1.getName());
                            File file2 = new File(myJarFile2.getName());
                            if (!file1.getCanonicalPath().equals(file2.getCanonicalPath())) continue;
                            match = true;
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (myJarFile2 != null) {
                            myJarFile2.put();
                            myJarFile2 = null;
                        }
                        if (myJarFile1 != null) {
                            myJarFile1.put();
                            myJarFile1 = null;
                        }
                    }
                }
                if (match) continue;
                classpaths.add(urlString);
            }
            if (k == 0) {
                classpaths.add("file:" + QDir.currentPath());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            JarCache.reset(classpaths);
            return;
        }
    }

    private static MyJarFile resolveUrlToMyJarFile(URL url) throws IOException, ZipException {
        MyJarFile myJarFile = null;
        URLAlias urlAlias = QClassPathEngine.checkNeedWorkaround(url);
        try {
            if (urlAlias.file != null) {
                if (urlAlias.file.isFile()) {
                    myJarFile = new MyJarFile(urlAlias.file);
                }
            } else {
                myJarFile = new MyJarFile(urlAlias.url);
            }
        }
        catch (ZipException e) {
            throw new ZipException(e.getMessage() + ": " + url);
        }
        return myJarFile;
    }

    private static MyJarFile resolveUrlToMyJarFile(String urlString) throws MalformedURLException, IOException, ZipException {
        URL url = new URL("jar:" + urlString.toString() + "!/");
        return QClassPathEngine.resolveUrlToMyJarFile(url);
    }

    @Override
    public QAbstractFileEngineIterator beginEntryList(QDir.Filters filters, List<String> nameFilters) {
        String path = "";
        path = this.m_baseName.startsWith(this.namespaceSchemePrefix + ":") ? this.m_baseName : this.namespaceSchemePrefix + ":" + this.m_baseName;
        return new QClassPathFileEngineIterator(path, filters, nameFilters);
    }

    @Override
    public QAbstractFileEngineIterator endEntryList() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QAbstractFileEngine getFirstEngine() {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            if (!this.m_engines.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.m_engines.getFirst();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    private static class URLAlias {
        URL url;
        File file;

        private URLAlias() {
        }
    }
}

