/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.internal.fileengine;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.JarEntry;
import java.util.zip.ZipException;
import org.qtjambi.qt.internal.fileengine.MyJarFile;

class JarCache {
    private static ReadWriteLock lock = new ReentrantReadWriteLock();
    private static HashMap<String, List<String>> cache;
    private static List<String> classPathDirs;

    JarCache() {
    }

    private static void add(HashMap<String, List<String>> lookupCache, String dirName, String pathToJarFile) {
        List<String> files = lookupCache.get(dirName);
        if (files == null) {
            files = new ArrayList<String>();
            files.add(pathToJarFile);
            lookupCache.put(dirName, files);
        } else if (!files.contains(pathToJarFile)) {
            files.add(pathToJarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(Set<String> jarFileList) {
        Lock thisLock = lock.writeLock();
        thisLock.lock();
        try {
            HashMap<String, List<String>> tmpCache = new HashMap<String, List<String>>();
            classPathDirs = new ArrayList<String>();
            for (String jarFileName : jarFileList) {
                MyJarFile myJarFile = null;
                try {
                    if (jarFileName.startsWith("file:")) {
                        URL urlDir = new URL(jarFileName);
                        String urlFileString = urlDir.getFile();
                        File fileDir = new File(urlFileString);
                        if (fileDir.isDirectory()) {
                            classPathDirs.add(jarFileName);
                            continue;
                        }
                        if (fileDir.isFile()) {
                            try {
                                myJarFile = new MyJarFile(fileDir);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (myJarFile == null) {
                        File fileDir = new File(jarFileName);
                        if (fileDir.isDirectory()) {
                            classPathDirs.add(jarFileName);
                            continue;
                        }
                        if (fileDir.isFile()) {
                            try {
                                myJarFile = new MyJarFile(fileDir);
                            }
                            catch (IOException urlFileString) {
                                // empty catch block
                            }
                        }
                    }
                    if (myJarFile == null) {
                        URL url = new URL("jar:" + jarFileName + "!/");
                        try {
                            myJarFile = new MyJarFile(url);
                        }
                        catch (ZipException e) {
                            throw new ZipException(e.getMessage() + ": " + url);
                        }
                    }
                    String jarFileNameX = myJarFile.getName();
                    HashSet<String> seenSet = new HashSet<String>();
                    Enumeration<JarEntry> entries = myJarFile.entries();
                    while (entries.hasMoreElements()) {
                        int slashPos;
                        JarEntry entry = entries.nextElement();
                        String dirName = null;
                        boolean isToplevelFile = false;
                        String entryName = entry.getName();
                        while (entryName.startsWith("/")) {
                            entryName = entryName.substring(1);
                        }
                        if (entry.isDirectory()) {
                            dirName = entryName.endsWith("/") ? entryName.substring(0, entryName.length() - 1) : entryName;
                        } else {
                            slashPos = entryName.lastIndexOf("/");
                            if (slashPos > 0) {
                                dirName = entryName.substring(0, slashPos);
                            } else {
                                isToplevelFile = true;
                            }
                        }
                        while (dirName != null && !seenSet.contains(dirName)) {
                            seenSet.add(dirName);
                            JarCache.add(tmpCache, dirName, jarFileNameX);
                            slashPos = dirName.lastIndexOf("/");
                            if (slashPos > 0) {
                                dirName = dirName.substring(0, slashPos);
                                continue;
                            }
                            dirName = null;
                        }
                        if (!isToplevelFile || seenSet.contains("")) continue;
                        seenSet.add("");
                        JarCache.add(tmpCache, "", jarFileNameX);
                    }
                    if (seenSet.contains("")) continue;
                    seenSet.add("");
                    JarCache.add(tmpCache, "", jarFileNameX);
                }
                catch (Exception e) {
                    classPathDirs.add(jarFileName);
                }
                finally {
                    if (myJarFile == null) continue;
                    myJarFile.put();
                    myJarFile = null;
                }
            }
            cache = tmpCache;
        }
        finally {
            thisLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpCache(PrintStream out, Map<String, List<String>> thisCache) {
        Lock thisLock = null;
        if (cache == null) {
            thisLock = lock.writeLock();
            thisLock.lock();
            thisCache = cache;
        }
        try {
            for (String s : thisCache.keySet()) {
                out.println(s);
                for (String pathToJarFile : thisCache.get(s)) {
                    out.println(" - '" + pathToJarFile + "'");
                }
            }
        }
        finally {
            if (thisLock != null) {
                thisLock.unlock();
            }
        }
    }

    public static List<String> pathToJarFiles(String entry) {
        List<String> files = null;
        Lock thisLock = lock.readLock();
        thisLock.lock();
        try {
            if (cache != null) {
                files = cache.get(entry);
            }
        }
        finally {
            thisLock.unlock();
        }
        return files;
    }

    private static void invalidateLocked() {
        if (cache == null) {
            return;
        }
        cache.clear();
        cache = null;
    }

    public static void invalidate() {
        Lock thisLock = lock.writeLock();
        thisLock.lock();
        try {
            JarCache.invalidateLocked();
        }
        finally {
            thisLock.unlock();
        }
    }

    public static List<String> classPathDirs() {
        return classPathDirs;
    }
}

