/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.internal;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.qtjambi.qt.QFlags;
import org.qtjambi.qt.QSignalEmitter;
import org.qtjambi.qt.QtBlockedEnum;
import org.qtjambi.qt.QtBlockedSlot;
import org.qtjambi.qt.QtEnumerator;
import org.qtjambi.qt.QtJambiGeneratedClass;
import org.qtjambi.qt.QtPropertyConstant;
import org.qtjambi.qt.QtPropertyDesignable;
import org.qtjambi.qt.QtPropertyNotify;
import org.qtjambi.qt.QtPropertyReader;
import org.qtjambi.qt.QtPropertyResetter;
import org.qtjambi.qt.QtPropertyScriptable;
import org.qtjambi.qt.QtPropertyStored;
import org.qtjambi.qt.QtPropertyUser;
import org.qtjambi.qt.QtPropertyWriter;
import org.qtjambi.qt.QtScriptable;
import org.qtjambi.qt.Utilities;
import org.qtjambi.qt.core.QObject;
import org.qtjambi.qt.core.Qt;
import org.qtjambi.qt.internal.QMetaType;
import org.qtjambi.qt.internal.QSignalEmitterInternal;
import org.qtjambi.qt.internal.QtJambiInternal;

public class MetaObjectTools {
    private static final int MethodAccessPrivate = 0;
    private static final int MethodAccessProtected = 1;
    private static final int MethodAccessPublic = 2;
    private static final int MethodAccessMask = 3;
    private static final int MethodMethod = 0;
    private static final int MethodSignal = 4;
    private static final int MethodSlot = 8;
    private static final int MethodConstructor = 12;
    private static final int MethodTypeMask = 12;
    private static final int MethodCompatibility = 16;
    private static final int MethodCloned = 32;
    private static final int MethodScriptable = 64;
    private static final int MethodRevisioned = 128;
    private static final int PropertyInvalid = 0;
    private static final int PropertyReadable = 1;
    private static final int PropertyWritable = 2;
    private static final int PropertyResettable = 4;
    private static final int PropertyEnumOrFlag = 8;
    private static final int PropertyStdCppSet = 256;
    private static final int PropertyConstant = 1024;
    private static final int PropertyFinal = 2048;
    private static final int PropertyDesignable = 4096;
    private static final int PropertyResolveDesignable = 8192;
    private static final int PropertyScriptable = 16384;
    private static final int PropertyResolveScriptable = 32768;
    private static final int PropertyStored = 65536;
    private static final int PropertyResolveStored = 131072;
    private static final int PropertyEditable = 262144;
    private static final int PropertyResolveEditable = 524288;
    private static final int PropertyUser = 0x100000;
    private static final int PropertyResolveUser = 0x200000;
    private static final int PropertyNotify = 0x400000;
    private static final int PropertyRevisioned = 0x800000;
    public static final int METAOBJECT_REVISION_HIGHEST_SUPPORTED = 7;
    public static final String K_org_qtjambi_qt_qtjambi_metadata_revision = "org.qtjambi.qt.qtjambi.metadata.revision";
    private static int revision;

    private static Method notBogus(Method method, String propertyName, Class<?> paramType) {
        if (method == null) {
            return null;
        }
        Container reader = Container.readerAnnotation(method);
        if (!(reader == null || reader.name().equals(propertyName) && reader.enabled() && method.getReturnType().isAssignableFrom(paramType))) {
            return null;
        }
        return method;
    }

    private static int queryEnums(Class<?> clazz, Hashtable<String, Class<?>> enums) {
        Class<?>[] declaredClasses;
        int enumConstantCount = 0;
        for (Class<?> declaredClass : declaredClasses = clazz.getDeclaredClasses()) {
            enumConstantCount += MetaObjectTools.putEnumTypeInHash(declaredClass, enums);
        }
        return enumConstantCount;
    }

    private static Class<?> getEnumForQFlags(Class<?> flagsType) {
        Type t = flagsType.getGenericSuperclass();
        if (t instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)t).getActualTypeArguments();
            return (Class)typeArguments[0];
        }
        return null;
    }

    private static int putEnumTypeInHash(Class<?> type, Hashtable<String, Class<?>> enums) {
        Class<?> enumType;
        Class<?> flagsType = QFlags.class.isAssignableFrom(type) ? type : null;
        Class<Object> clazz = enumType = type.isEnum() ? type : null;
        if (enumType == null && flagsType != null) {
            enumType = MetaObjectTools.getEnumForQFlags(flagsType);
        }
        if (enumType == null) {
            return 0;
        }
        Class<?> enclosingClass = enumType.getEnclosingClass();
        if (enclosingClass == null) {
            return -1;
        }
        if (!QObject.class.isAssignableFrom(enclosingClass) && !Qt.class.equals(enclosingClass) || enumType.isAnnotationPresent(QtBlockedEnum.class)) {
            return -1;
        }
        int enumConstantCount = 0;
        if (!enums.contains(enumType.getName())) {
            enums.put(enumType.getName(), enumType);
            enumConstantCount = enumType.getEnumConstants().length;
        }
        if (flagsType != null && !enums.contains(flagsType.getName())) {
            enums.put(flagsType.getName(), flagsType);
        }
        return enumConstantCount;
    }

    private static boolean isEnumAllowedForProperty(Class<?> type) {
        Class<?> enumType;
        Class<?> flagsType = QFlags.class.isAssignableFrom(type) ? type : null;
        Class<Object> clazz = enumType = type.isEnum() ? type : null;
        if (enumType == null && flagsType != null) {
            enumType = MetaObjectTools.getEnumForQFlags(flagsType);
        }
        if (enumType == null) {
            return false;
        }
        Class<?> enclosingClass = enumType.getEnclosingClass();
        if (enclosingClass == null) {
            return false;
        }
        return (QObject.class.isAssignableFrom(enclosingClass) || Qt.class.equals(enclosingClass)) && !enumType.isAnnotationPresent(QtBlockedEnum.class);
    }

    private static Object isDesignable(Method declaredMethod, Class<?> clazz) {
        QtPropertyDesignable designable = declaredMethod.getAnnotation(QtPropertyDesignable.class);
        if (designable != null) {
            String value = designable.value();
            if (value.equals("true")) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return Boolean.FALSE;
            }
            try {
                Method m = clazz.getMethod(value, null);
                if (MetaObjectTools.isBoolean(m.getReturnType())) {
                    return m;
                }
                throw new RuntimeException("Wrong return type of designable method '" + m.getName() + "'");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return Boolean.TRUE;
    }

    private static Object isScriptable(Method declaredMethod, Class<?> clazz) {
        QtPropertyScriptable scriptable = declaredMethod.getAnnotation(QtPropertyScriptable.class);
        if (scriptable != null) {
            String value = scriptable.value();
            if (value.equals("true")) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return Boolean.FALSE;
            }
            try {
                Method m = clazz.getMethod(value, null);
                if (MetaObjectTools.isBoolean(m.getReturnType())) {
                    return m;
                }
                throw new RuntimeException("Wrong return type of scriptable method '" + m.getName() + "'");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return Boolean.TRUE;
    }

    private static Object isStored(Method declaredMethod, Class<?> clazz) {
        QtPropertyStored stored = declaredMethod.getAnnotation(QtPropertyStored.class);
        if (stored != null) {
            String value = stored.value();
            if (value.equals("true")) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return Boolean.FALSE;
            }
            try {
                Method m = clazz.getMethod(value, null);
                if (MetaObjectTools.isBoolean(m.getReturnType())) {
                    return m;
                }
                throw new RuntimeException("Wrong return type of scriptable method '" + m.getName() + "'");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return Boolean.TRUE;
    }

    private static Object isEditable(Method declaredMethod, Class<?> clazz) {
        return Boolean.TRUE;
    }

    private static boolean isValidSetter(Method declaredMethod) {
        return declaredMethod.getParameterTypes().length == 1 && declaredMethod.getReturnType() == Void.TYPE && !MetaObjectTools.internalTypeNameOfParameters(declaredMethod, 1).equals("");
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?>[] args) {
        try {
            return clazz.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String capitalizeFirst(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    private static Object isUser(Method declaredMethod, Class<?> clazz) {
        QtPropertyUser user = declaredMethod.getAnnotation(QtPropertyUser.class);
        if (user != null) {
            String value = user.value();
            if (value.equals("true")) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return Boolean.FALSE;
            }
            try {
                Method m = clazz.getMethod(value, null);
                if (MetaObjectTools.isBoolean(m.getReturnType())) {
                    return m;
                }
                throw new RuntimeException("Wrong return type of scriptable method '" + m.getName() + "'");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return Boolean.FALSE;
    }

    private static Boolean isFinal(Method declaredMethod) {
        return Modifier.isFinal(declaredMethod.getModifiers());
    }

    private static Boolean isConstant(Method declaredMethod) {
        QtPropertyConstant isConstant = declaredMethod.getAnnotation(QtPropertyConstant.class);
        if (isConstant != null) {
            String value = isConstant.value();
            if (value.equals("true")) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    private static boolean isValidGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public static String bunchOfClassNamesInARow(Class<?>[] classes) {
        return MetaObjectTools.bunchOfClassNamesInARow(classes, null);
    }

    public static String bunchOfClassNamesInARow(Class<?>[] classes, int[] arrayDimensions) {
        String classNames = "";
        for (int i = 0; i < classes.length; ++i) {
            Class<?> clazz = classes[i];
            String className = clazz.getName();
            if (arrayDimensions != null) {
                for (int j = 0; j < arrayDimensions[i]; ++j) {
                    className = "java.lang.Object";
                }
            }
            if (!clazz.isPrimitive()) {
                try {
                    MetaObjectTools.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    className = QObject.class.isAssignableFrom(clazz) ? QObject.class.getName() : Object.class.getName();
                }
            }
            classNames = classNames + className;
            if (i >= classes.length - 1) continue;
            classNames = classNames + ",";
        }
        return classNames;
    }

    private static String methodParameters(Method m) {
        return MetaObjectTools.bunchOfClassNamesInARow(m.getParameterTypes());
    }

    private static String methodParameters(Constructor<?> m) {
        return MetaObjectTools.bunchOfClassNamesInARow(m.getParameterTypes());
    }

    private static String methodSignature(Method m, boolean includeReturnType) {
        return (includeReturnType ? m.getReturnType().getName() + " " : "") + m.getName() + "(" + MetaObjectTools.methodParameters(m) + ")";
    }

    private static String methodSignature(Constructor<?> m) {
        return m.getName() + "(" + MetaObjectTools.methodParameters(m) + ")";
    }

    private static String methodSignature(QtJambiInternal.ResolvedSignal r) {
        return r.name + "(" + MetaObjectTools.bunchOfClassNamesInARow(r.types, r.arrayDimensions) + ")";
    }

    public static String methodSignature(Method m) {
        return MetaObjectTools.methodSignature(m, false);
    }

    private static String constructorSignature(Constructor<?> c) {
        String name = c.getName();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            name = name.substring(idx + 1, name.length());
        }
        return name + "(" + MetaObjectTools.constructorParameters(c) + ")";
    }

    private static String constructorParameters(Constructor<?> c) {
        return MetaObjectTools.bunchOfClassNamesInARow(c.getParameterTypes());
    }

    private static int addString(int[] metaData, Hashtable<String, Integer> strings, List<String> stringsInOrder, String string, int offset, int metaDataOffset) {
        if (strings.containsKey(string)) {
            metaData[metaDataOffset] = strings.get(string);
            return 0;
        }
        metaData[metaDataOffset] = offset;
        strings.put(string, offset);
        stringsInOrder.add(string);
        return string.length() + 1;
    }

    public static native void emitNativeSignal(QObject var0, String var1, String var2, Object[] var3);

    public static String cppSignalSignature(QSignalEmitterInternal signalEmitter, String signalName) {
        QSignalEmitter.AbstractSignal signal = (QSignalEmitter.AbstractSignal)QtJambiInternal.lookupSignal(signalEmitter, signalName);
        if (signal != null) {
            return MetaObjectTools.cppSignalSignature(signal);
        }
        return "";
    }

    public static String cppSignalSignature(QSignalEmitterInternal.AbstractSignalInternal signal) {
        String signalParameters = QtJambiInternal.signalParameters(signal);
        String params = MetaObjectTools.internalTypeNameOfSignal(signal.resolveSignal(), signalParameters, 1);
        if (signalParameters.length() > 0 && params.length() == 0) {
            return "";
        }
        return signal.name() + "(" + params + ")";
    }

    private static String signalParameters(QtJambiInternal.ResolvedSignal resolvedSignal) {
        return MetaObjectTools.bunchOfClassNamesInARow(resolvedSignal.types, resolvedSignal.arrayDimensions);
    }

    private static String signalParameters(Field field, Class<?> declaringClass) {
        QtJambiInternal.ResolvedSignal resolvedSignal = QtJambiInternal.resolveSignal(field, declaringClass);
        return MetaObjectTools.signalParameters(resolvedSignal);
    }

    private static native String internalTypeName(String var0, int var1);

    private static Class<?> resolveQFlagsActualTypeArgument(Class<? extends QFlags<?>> cls) {
        Type type = cls;
        while (true) {
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                if (ptype.getRawType() == QFlags.class) {
                    Type[] actualTypeArguments = ptype.getActualTypeArguments();
                    if (actualTypeArguments.length == 1 && actualTypeArguments[0] instanceof Class) {
                        return (Class)actualTypeArguments[0];
                    }
                    return QtEnumerator.class;
                }
                if (ptype.getRawType() instanceof Class) {
                    type = ((Class)ptype.getRawType()).getGenericSuperclass();
                    continue;
                }
                return QtEnumerator.class;
            }
            if (!(type instanceof Class)) continue;
            if (type == QFlags.class) {
                return QtEnumerator.class;
            }
            type = type.getGenericSuperclass();
        }
    }

    public static String internalTypeNameOfSignal(Class<?>[] signals, String s, int varContext) {
        try {
            return MetaObjectTools.internalTypeName(s, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String internalTypeNameOfParameters(Method declaredMethod, int varContext) {
        try {
            String s = MetaObjectTools.methodParameters(declaredMethod);
            return MetaObjectTools.internalTypeName(s, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String internalTypeNameOfParameters(Constructor<?> declaredConstructor, int varContext) {
        try {
            String s = MetaObjectTools.constructorParameters(declaredConstructor);
            return MetaObjectTools.internalTypeName(s, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String internalTypeNameOfMethodSignature(Method slot, int varContext) {
        try {
            String javaMethodSignature = MetaObjectTools.methodSignature(slot);
            return MetaObjectTools.internalTypeName(javaMethodSignature, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String internalTypeNameOfMethodSignature(Constructor<?> constructor, int varContext) {
        try {
            String javaMethodSignature = MetaObjectTools.constructorSignature(constructor);
            return MetaObjectTools.internalTypeName(javaMethodSignature, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String internalTypeNameOfClass(Class<? extends Object> cls, VariableContext varContext) {
        try {
            boolean isEnumOrFlags;
            String returnType = cls.getName();
            if (!cls.isPrimitive()) {
                try {
                    MetaObjectTools.class.getClassLoader().loadClass(returnType);
                }
                catch (Exception e) {
                    returnType = QObject.class.isAssignableFrom(cls) ? QObject.class.getName() : Object.class.getName();
                }
            }
            boolean bl = isEnumOrFlags = Enum.class.isAssignableFrom(cls) || QFlags.class.isAssignableFrom(cls);
            if (isEnumOrFlags && cls.getDeclaringClass() != null && (QObject.class.isAssignableFrom(cls.getDeclaringClass()) || Qt.class.isAssignableFrom(cls.getDeclaringClass())) && cls.getDeclaringClass().isAnnotationPresent(QtJambiGeneratedClass.class)) {
                return MetaObjectTools.internalTypeNameOfClass(cls.getDeclaringClass(), varContext).replace("*", "") + "::" + cls.getSimpleName();
            }
            return MetaObjectTools.internalTypeName(returnType, varContext.ordinal());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "";
        }
    }

    private static MetaData buildMetaData(Class<? extends QObject> clazz) {
        int i;
        int i2;
        Method method;
        int argc;
        Constructor constructor;
        StringList strings = new StringList();
        ArrayList<Integer> intdata = new ArrayList<Integer>();
        String classname = clazz.getName().replace(".", "::");
        strings.add(classname);
        MetaData metaData = new MetaData();
        Hashtable<String, String> classInfos = new Hashtable<String, String>();
        classInfos.put("__qt__binding_shell_language", "Qt Jambi");
        for (Map.Entry entry : classInfos.entrySet()) {
            strings.add(entry.getKey());
            strings.add(entry.getValue());
        }
        ArrayList<AccessibleObject> constructors = new ArrayList<AccessibleObject>();
        ArrayList<AccessibleObject> slots = new ArrayList<AccessibleObject>();
        ArrayList<AccessibleObject> methods = new ArrayList<AccessibleObject>();
        ArrayList<String> originalSignatures = new ArrayList<String>();
        Hashtable<String, AccessibleObject> propertyReaders = new Hashtable<String, AccessibleObject>();
        Hashtable<String, AccessibleObject> propertyWriters = new Hashtable<String, AccessibleObject>();
        Hashtable<String, Object> propertyDesignableResolvers = new Hashtable<String, Object>();
        Hashtable<String, Object> propertyScriptableResolvers = new Hashtable<String, Object>();
        Hashtable<String, Object> propertyEditableResolvers = new Hashtable<String, Object>();
        Hashtable<String, Object> propertyStoredResolvers = new Hashtable<String, Object>();
        Hashtable<String, Object> propertyUserResolvers = new Hashtable<String, Object>();
        Hashtable<String, Boolean> propertyConstantResolvers = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> propertyFinalResolvers = new Hashtable<String, Boolean>();
        Hashtable<String, AccessibleObject> propertyResetters = new Hashtable<String, AccessibleObject>();
        Hashtable<String, Field> propertyNotifies = new Hashtable<String, Field>();
        Hashtable enums = new Hashtable();
        MetaObjectTools.queryEnums(clazz, enums);
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<Field> signalFields = new ArrayList<Field>();
        ArrayList<QtJambiInternal.ResolvedSignal> resolvedSignals = new ArrayList<QtJambiInternal.ResolvedSignal>();
        for (Field field : declaredFields) {
            Container notify;
            if (!QtJambiInternal.isSignal(field.getType())) continue;
            QtJambiInternal.ResolvedSignal resolvedSignal = QtJambiInternal.resolveSignal(field, field.getDeclaringClass());
            String signalParameters = MetaObjectTools.signalParameters(resolvedSignal);
            if (signalParameters.length() == 0 || MetaObjectTools.internalTypeNameOfSignal(resolvedSignal.types, signalParameters, 1).length() != 0) {
                signalFields.add(field);
                resolvedSignals.add(resolvedSignal);
                originalSignatures.add(MetaObjectTools.methodSignature(resolvedSignal));
                strings.add(resolvedSignal.name);
                for (int i3 = 1; i3 <= resolvedSignal.types.length; ++i3) {
                    String typeName = resolvedSignal.arrayDimensions == null || resolvedSignal.arrayDimensions[i3 - 1] == 0 ? MetaObjectTools.internalTypeNameOfClass(resolvedSignal.types[i3 - 1], VariableContext.ArgumentType) : MetaObjectTools.internalTypeNameOfClass(Object.class, VariableContext.ArgumentType);
                    QMetaType.Type type = QMetaType.type(typeName);
                    if (type == QMetaType.Type.UnknownType || type == QMetaType.Type.User) {
                        strings.add(typeName);
                    }
                    strings.add("arg__" + i3);
                }
                strings.add("");
            }
            if ((notify = Container.notifyAnnotation(field)) == null || resolvedSignal.types.length > 1) continue;
            propertyNotifies.put(notify.name(), field);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredConstructors()) {
            if (!accessibleObject.isAnnotationPresent(QtScriptable.class)) continue;
            constructors.add(accessibleObject);
            metaData.hasStaticMembers = true;
            originalSignatures.add(MetaObjectTools.methodSignature(accessibleObject));
            for (int i4 = 1; i4 <= ((Constructor)accessibleObject).getParameterTypes().length; ++i4) {
                String typeName = MetaObjectTools.internalTypeNameOfClass(((Constructor)accessibleObject).getParameterTypes()[i4 - 1], VariableContext.ArgumentType);
                QMetaType.Type type = QMetaType.type(typeName);
                if (type == QMetaType.Type.UnknownType || type == QMetaType.Type.User) {
                    strings.add(typeName);
                }
                strings.add("arg__" + i4);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Container resetter;
            Container writer;
            Container reader;
            Class<?> returnType;
            if (!accessibleObject.isAnnotationPresent(QtBlockedSlot.class) && (((Method)accessibleObject).getModifiers() & 8) != 8 || accessibleObject.isAnnotationPresent(QtScriptable.class) && ((Method)accessibleObject).getAnnotation(QtScriptable.class).value()) {
                String methodParameters = MetaObjectTools.methodParameters((Method)accessibleObject);
                returnType = ((Method)accessibleObject).getReturnType().getName();
                String returnTypeName = MetaObjectTools.internalTypeNameOfClass(((Method)accessibleObject).getReturnType(), VariableContext.ReturnType);
                if (!(!methodParameters.equals("") && MetaObjectTools.internalTypeNameOfParameters((Method)accessibleObject, 1).equals("") || !((String)((Object)returnType)).equals("") && !((String)((Object)returnType)).equals("void") && returnTypeName.equals(""))) {
                    if ((((Method)accessibleObject).getModifiers() & 8) != 8) {
                        slots.add(accessibleObject);
                    } else {
                        methods.add(accessibleObject);
                        metaData.hasStaticMembers = true;
                    }
                    originalSignatures.add(MetaObjectTools.methodSignature((Method)accessibleObject));
                    strings.add(((Method)accessibleObject).getName());
                    strings.add(returnTypeName);
                    for (int i5 = 1; i5 <= ((Method)accessibleObject).getParameterTypes().length; ++i5) {
                        String typeName = MetaObjectTools.internalTypeNameOfClass(((Method)accessibleObject).getParameterTypes()[i5 - 1], VariableContext.ArgumentType);
                        QMetaType.Type type = QMetaType.type(typeName);
                        if (type == QMetaType.Type.UnknownType || type == QMetaType.Type.User) {
                            strings.add(typeName);
                        }
                        strings.add("arg__" + i5);
                    }
                    strings.add("");
                }
            }
            if ((reader = Container.readerAnnotation((Method)accessibleObject)) != null && reader.enabled() && MetaObjectTools.isValidGetter((Method)accessibleObject) && !MetaObjectTools.internalTypeNameOfClass(((Method)accessibleObject).getReturnType(), VariableContext.ReturnType).equals("")) {
                returnType = ((Method)accessibleObject).getReturnType();
                if ((QFlags.class.isAssignableFrom(returnType) || Enum.class.isAssignableFrom(returnType)) && !MetaObjectTools.isEnumAllowedForProperty(returnType)) {
                    System.err.println("Problem in property '" + reader.name() + "' in '" + clazz.getName() + "' with return type '" + returnType.getName() + "': Only enum types 1. declared inside QObject subclasses or the Qt interface and 2. declared without the QtBlockedEnum annotation are supported for properties");
                    continue;
                }
                propertyReaders.put(reader.name(), accessibleObject);
                propertyDesignableResolvers.put(reader.name(), MetaObjectTools.isDesignable((Method)accessibleObject, clazz));
                propertyScriptableResolvers.put(reader.name(), MetaObjectTools.isScriptable((Method)accessibleObject, clazz));
                propertyEditableResolvers.put(reader.name(), MetaObjectTools.isEditable((Method)accessibleObject, clazz));
                propertyStoredResolvers.put(reader.name(), MetaObjectTools.isStored((Method)accessibleObject, clazz));
                propertyUserResolvers.put(reader.name(), MetaObjectTools.isUser((Method)accessibleObject, clazz));
                propertyConstantResolvers.put(reader.name(), MetaObjectTools.isConstant((Method)accessibleObject));
                propertyFinalResolvers.put(reader.name(), MetaObjectTools.isFinal((Method)accessibleObject));
                strings.add(reader.name());
            }
            if ((writer = Container.writerAnnotation((Method)accessibleObject)) != null && writer.enabled() && MetaObjectTools.isValidSetter((Method)accessibleObject)) {
                propertyWriters.put(writer.name(), accessibleObject);
            }
            if ((resetter = Container.resetterAnnotation((Method)accessibleObject)) != null && ((Method)accessibleObject).getParameterTypes().length == 0 && ((Method)accessibleObject).getReturnType() == Void.TYPE) {
                propertyResetters.put(resetter.name(), accessibleObject);
            }
            String declaredMethodName = ((Method)accessibleObject).getName();
            if (writer != null || reader != null || !declaredMethodName.startsWith("set") || declaredMethodName.length() <= 3 || !Character.isUpperCase(declaredMethodName.charAt(3)) || !MetaObjectTools.isValidSetter((Method)accessibleObject)) continue;
            Class<?> paramType = ((Method)accessibleObject).getParameterTypes()[0];
            String propertyName = Character.toLowerCase(declaredMethodName.charAt(3)) + declaredMethodName.substring(4);
            if (propertyReaders.containsKey(propertyName)) continue;
            Method readerMethod = MetaObjectTools.notBogus(MetaObjectTools.getMethod(clazz, propertyName, null), propertyName, paramType);
            if (readerMethod == null) {
                readerMethod = MetaObjectTools.notBogus(MetaObjectTools.getMethod(clazz, "get" + MetaObjectTools.capitalizeFirst(propertyName), null), propertyName, paramType);
            }
            if (readerMethod == null && MetaObjectTools.isBoolean(paramType)) {
                readerMethod = MetaObjectTools.notBogus(MetaObjectTools.getMethod(clazz, "is" + MetaObjectTools.capitalizeFirst(propertyName), null), propertyName, paramType);
            }
            if (readerMethod == null && MetaObjectTools.isBoolean(paramType)) {
                readerMethod = MetaObjectTools.notBogus(MetaObjectTools.getMethod(clazz, "has" + MetaObjectTools.capitalizeFirst(propertyName), null), propertyName, paramType);
            }
            if (readerMethod == null || (reader = Container.readerAnnotation(readerMethod)) != null) continue;
            propertyReaders.put(propertyName, readerMethod);
            propertyWriters.put(propertyName, accessibleObject);
            propertyDesignableResolvers.put(propertyName, MetaObjectTools.isDesignable(readerMethod, clazz));
            propertyScriptableResolvers.put(propertyName, MetaObjectTools.isScriptable(readerMethod, clazz));
            propertyUserResolvers.put(propertyName, MetaObjectTools.isUser(readerMethod, clazz));
        }
        ArrayList<AccessibleObject> slotsMethods = new ArrayList<AccessibleObject>(slots);
        slotsMethods.addAll(methods);
        metaData.signalsArray = signalFields.toArray(new Field[0]);
        metaData.slotsArray = slotsMethods.toArray(new Method[0]);
        metaData.constructorsArray = constructors.toArray(new Constructor[0]);
        int MO_HEADER_LEN = 14;
        intdata.add(MetaObjectTools.resolveMetaDataRevision());
        intdata.add(strings.indexOf(classname));
        intdata.add(classInfos.size());
        intdata.add(classInfos.isEmpty() ? 0 : 14);
        int methodCount = signalFields.size() + slots.size() + methods.size();
        intdata.add(methodCount);
        int n = intdata.size();
        intdata.add(0);
        intdata.add(propertyReaders.size());
        int PROPERTY_METADATA_INDEX = intdata.size();
        intdata.add(0);
        intdata.add(enums.size());
        int ENUM_METADATA_INDEX = intdata.size();
        intdata.add(0);
        intdata.add(!constructors.isEmpty() ? constructors.size() : 0);
        int CONSTRUCTOR_METADATA_INDEX = intdata.size();
        intdata.add(0);
        intdata.add(0);
        intdata.add(signalFields.size());
        for (Map.Entry entry : classInfos.entrySet()) {
            intdata.add(strings.indexOf(entry.getKey()));
            intdata.add(strings.indexOf(entry.getValue()));
        }
        HashMap<Object, Integer> paramIndexOfMethods = new HashMap<Object, Integer>();
        if (!constructors.isEmpty()) {
            intdata.set(CONSTRUCTOR_METADATA_INDEX, intdata.size());
            for (int i6 = 0; i6 < constructors.size(); ++i6) {
                constructor = (Constructor)constructors.get(i6);
                int flags = 12;
                flags = Modifier.isPrivate(constructor.getModifiers()) ? (flags |= 0) : (Modifier.isPublic(constructor.getModifiers()) ? (flags |= 2) : (flags |= 1));
                if (constructor.isAnnotationPresent(QtScriptable.class) && constructor.getAnnotation(QtScriptable.class).value()) {
                    flags |= 0x40;
                }
                argc = constructor.getParameterTypes().length;
                String className = constructor.getDeclaringClass().getName();
                if (className.contains(".")) {
                    className = className.substring(className.lastIndexOf(46) + 1);
                }
                strings.add(className);
                intdata.add(strings.indexOf(className));
                intdata.add(argc);
                paramIndexOfMethods.put(constructor, intdata.size());
                intdata.add(0);
                intdata.add(strings.indexOf(""));
                intdata.add(flags);
            }
        }
        if (signalFields.size() + slotsMethods.size() > 0) {
            intdata.set(n, intdata.size());
            for (int i7 = 0; i7 < signalFields.size(); ++i7) {
                Field signalField = (Field)signalFields.get(i7);
                QtJambiInternal.ResolvedSignal resolvedSignal = (QtJambiInternal.ResolvedSignal)resolvedSignals.get(i7);
                int flags = 4;
                flags = Modifier.isPrivate(signalField.getModifiers()) ? (flags |= 0) : (Modifier.isPublic(signalField.getModifiers()) ? (flags |= 2) : (flags |= 1));
                if (signalField.isAnnotationPresent(QtScriptable.class)) {
                    flags |= 0x40;
                }
                int argc2 = resolvedSignal.types.length;
                intdata.add(strings.indexOf(signalField.getName()));
                intdata.add(argc2);
                paramIndexOfMethods.put(resolvedSignal, intdata.size());
                intdata.add(0);
                intdata.add(strings.indexOf(""));
                intdata.add(flags);
            }
            for (int i3 = 0; i3 < slotsMethods.size(); ++i3) {
                int flags;
                method = (Method)slotsMethods.get(i3);
                int n2 = flags = slots.contains(method) ? 8 : 0;
                flags = Modifier.isPrivate(method.getModifiers()) ? (flags |= 0) : (Modifier.isPublic(method.getModifiers()) ? (flags |= 2) : (flags |= 1));
                if (!method.isAnnotationPresent(QtScriptable.class) || method.getAnnotation(QtScriptable.class).value()) {
                    flags |= 0x40;
                }
                argc = method.getParameterTypes().length;
                intdata.add(strings.indexOf(method.getName()));
                intdata.add(argc);
                paramIndexOfMethods.put(method, intdata.size());
                intdata.add(0);
                intdata.add(strings.indexOf(""));
                intdata.add(flags);
            }
        }
        for (int i22 = 0; i22 < signalFields.size(); ++i22) {
            int j;
            QtJambiInternal.ResolvedSignal resolvedSignal = (QtJambiInternal.ResolvedSignal)resolvedSignals.get(i22);
            int METHOD_PARAMETER_INDEX = (Integer)paramIndexOfMethods.get(resolvedSignal);
            intdata.set(METHOD_PARAMETER_INDEX, intdata.size());
            intdata.add(QMetaType.Type.Void.value);
            for (j = 0; j < resolvedSignal.types.length; ++j) {
                String typeName = resolvedSignal.arrayDimensions == null || resolvedSignal.arrayDimensions[j] == 0 ? MetaObjectTools.internalTypeNameOfClass(resolvedSignal.types[j], VariableContext.ArgumentType) : MetaObjectTools.internalTypeNameOfClass(Object.class, VariableContext.ArgumentType);
                QMetaType.Type type = QMetaType.type(typeName);
                if (type == QMetaType.Type.UnknownType || type == QMetaType.Type.User) {
                    if (!strings.contains(typeName)) {
                        strings.add(typeName);
                    }
                    intdata.add(Integer.MIN_VALUE | strings.indexOf(typeName));
                    continue;
                }
                intdata.add(type.value);
            }
            for (j = 1; j <= resolvedSignal.types.length; ++j) {
                intdata.add(strings.indexOf("arg__" + j));
            }
        }
        for (i2 = 0; i2 < slotsMethods.size(); ++i2) {
            int j;
            method = (Method)slotsMethods.get(i2);
            int METHOD_PARAMETER_INDEX = (Integer)paramIndexOfMethods.get(method);
            intdata.set(METHOD_PARAMETER_INDEX, intdata.size());
            String typeName = MetaObjectTools.internalTypeNameOfClass(method.getReturnType(), VariableContext.ReturnType);
            QMetaType.Type type = QMetaType.type(typeName);
            if (type == QMetaType.Type.UnknownType || type == QMetaType.Type.User) {
                if (!strings.contains(typeName)) {
                    strings.add(typeName);
                }
                intdata.add(Integer.MIN_VALUE | strings.indexOf(typeName));
            } else {
                intdata.add(type.value);
            }
            for (j = 0; j < method.getParameterTypes().length; ++j) {
                typeName = MetaObjectTools.internalTypeNameOfClass(method.getParameterTypes()[j], VariableContext.ArgumentType);
                type = QMetaType.type(typeName);
                if (type == QMetaType.Type.UnknownType || type == QMetaType.Type.User) {
                    if (!strings.contains(typeName)) {
                        strings.add(typeName);
                    }
                    intdata.add(Integer.MIN_VALUE | strings.indexOf(typeName));
                    continue;
                }
                intdata.add(type.value);
            }
            for (j = 1; j <= method.getParameterTypes().length; ++j) {
                intdata.add(strings.indexOf("arg__" + j));
            }
        }
        for (i2 = 0; i2 < constructors.size(); ++i2) {
            int j;
            constructor = (Constructor)constructors.get(i2);
            int METHOD_PARAMETER_INDEX = (Integer)paramIndexOfMethods.get(constructor);
            intdata.set(METHOD_PARAMETER_INDEX, intdata.size());
            intdata.add(Integer.MIN_VALUE | strings.indexOf(""));
            for (j = 0; j < constructor.getParameterTypes().length; ++j) {
                String typeName = MetaObjectTools.internalTypeNameOfClass(constructor.getParameterTypes()[j], VariableContext.ArgumentType);
                QMetaType.Type type = QMetaType.type(typeName);
                if (type == QMetaType.Type.UnknownType || type == QMetaType.Type.User) {
                    if (!strings.contains(typeName)) {
                        strings.add(typeName);
                    }
                    intdata.add(Integer.MIN_VALUE | strings.indexOf(typeName));
                    continue;
                }
                intdata.add(type.value);
            }
            for (j = 1; j <= constructor.getParameterTypes().length; ++j) {
                intdata.add(strings.indexOf("arg__" + j));
            }
        }
        String[] propertyNames = propertyReaders.keySet().toArray(new String[0]);
        metaData.propertyReadersArray = new Method[propertyNames.length];
        metaData.propertyResettersArray = new Method[propertyNames.length];
        metaData.propertyNotifiesArray = new Field[propertyNames.length];
        metaData.propertyWritersArray = new Method[propertyNames.length];
        metaData.propertyDesignableResolverArray = new Method[propertyNames.length];
        metaData.propertyScriptableResolverArray = new Method[propertyNames.length];
        metaData.propertyEditableResolverArray = new Method[propertyNames.length];
        metaData.propertyStoredResolverArray = new Method[propertyNames.length];
        metaData.propertyUserResolverArray = new Method[propertyNames.length];
        if (!propertyReaders.isEmpty()) {
            intdata.set(PROPERTY_METADATA_INDEX, intdata.size());
            for (int i8 = 0; i8 < propertyNames.length; ++i8) {
                int idx;
                Method reader = (Method)propertyReaders.get(propertyNames[i8]);
                Method writer = (Method)propertyWriters.get(propertyNames[i8]);
                Method resetter = (Method)propertyResetters.get(propertyNames[i8]);
                Field notify = (Field)propertyNotifies.get(propertyNames[i8]);
                Object designableVariant = propertyDesignableResolvers.get(propertyNames[i8]);
                Object scriptableVariant = propertyScriptableResolvers.get(propertyNames[i8]);
                Object editableVariant = propertyEditableResolvers.get(propertyNames[i8]);
                Object storedVariant = propertyStoredResolvers.get(propertyNames[i8]);
                Object userVariant = propertyUserResolvers.get(propertyNames[i8]);
                Boolean constantVariant = (Boolean)propertyConstantResolvers.get(propertyNames[i8]);
                Boolean finalVariant = (Boolean)propertyFinalResolvers.get(propertyNames[i8]);
                if (writer != null && !reader.getReturnType().isAssignableFrom(writer.getParameterTypes()[0])) {
                    System.err.println("QtJambiInternal.buildMetaData: Writer for property " + propertyNames[i8] + " takes a type which is incompatible with reader's return type.");
                    writer = null;
                }
                int flags = 0;
                String typeName = MetaObjectTools.internalTypeNameOfClass(reader.getReturnType(), VariableContext.ReturnType);
                if (!MetaObjectTools.isBuiltinType(typeName)) {
                    flags |= 8;
                }
                if (writer != null) {
                    flags |= 2;
                    String s = "set";
                    s = s + propertyNames[i8].toUpperCase().charAt(0);
                    if ((s = s + propertyNames[i8].substring(1)).equals(writer.getName())) {
                        flags |= 0x100;
                    }
                }
                if (reader != null) {
                    flags |= 1;
                }
                if (resetter != null) {
                    flags |= 4;
                }
                if (designableVariant instanceof Boolean) {
                    if (((Boolean)designableVariant).booleanValue()) {
                        flags |= 0x1000;
                    }
                } else if (designableVariant instanceof Method) {
                    metaData.propertyDesignableResolverArray[i8] = (Method)designableVariant;
                    flags |= 0x2000;
                }
                if (scriptableVariant instanceof Boolean) {
                    if (((Boolean)scriptableVariant).booleanValue()) {
                        flags |= 0x4000;
                    }
                } else if (scriptableVariant instanceof Method) {
                    flags |= 0x8000;
                    metaData.propertyScriptableResolverArray[i8] = (Method)scriptableVariant;
                }
                if (editableVariant instanceof Boolean) {
                    if (((Boolean)editableVariant).booleanValue()) {
                        flags |= 0x40000;
                    }
                } else if (editableVariant instanceof Method) {
                    flags |= 0x80000;
                    metaData.propertyEditableResolverArray[i8] = (Method)editableVariant;
                }
                if (storedVariant instanceof Boolean) {
                    if (((Boolean)storedVariant).booleanValue()) {
                        flags |= 0x10000;
                    }
                } else if (storedVariant instanceof Method) {
                    flags |= 0x20000;
                    metaData.propertyStoredResolverArray[i8] = (Method)storedVariant;
                }
                if (userVariant instanceof Boolean) {
                    if (((Boolean)userVariant).booleanValue()) {
                        flags |= 0x100000;
                    }
                } else if (userVariant instanceof Method) {
                    flags |= 0x200000;
                    metaData.propertyUserResolverArray[i8] = (Method)userVariant;
                }
                if (constantVariant instanceof Boolean && constantVariant.booleanValue() && writer != null && notify != null) {
                    flags |= 0x400;
                }
                if (finalVariant instanceof Boolean && finalVariant.booleanValue()) {
                    flags |= 0x800;
                }
                if (notify != null) {
                    flags |= 0x400000;
                }
                if ((idx = strings.indexOf(propertyNames[i8])) == -1) {
                    strings.add(propertyNames[i8]);
                    idx = strings.indexOf(propertyNames[i8]);
                }
                intdata.add(idx);
                QMetaType.Type type = QMetaType.type(typeName);
                if (type == QMetaType.Type.UnknownType || type == QMetaType.Type.User) {
                    idx = strings.indexOf(typeName);
                    if (idx == -1) {
                        strings.add(typeName);
                        idx = strings.indexOf(typeName);
                    }
                    intdata.add(Integer.MIN_VALUE | idx);
                } else {
                    intdata.add(type.value);
                }
                intdata.add(flags);
                metaData.propertyReadersArray[i8] = reader;
                metaData.propertyWritersArray[i8] = writer;
                metaData.propertyResettersArray[i8] = resetter;
                metaData.propertyNotifiesArray[i8] = notify;
            }
        }
        if (!enums.isEmpty()) {
            intdata.set(ENUM_METADATA_INDEX, intdata.size());
            ArrayList enumList = new ArrayList(enums.values());
            HashMap dataIndexOfEnums = new HashMap();
            for (int i9 = 0; i9 < enumList.size(); ++i9) {
                Class<?> enumClass = (Class<?>)enumList.get(i9);
                strings.add(enumClass.getSimpleName());
                intdata.add(strings.indexOf(enumClass.getSimpleName()));
                intdata.add(QFlags.class.isAssignableFrom(enumClass) ? 1 : 0);
                Class<?> contentEnumClass = Enum.class.isAssignableFrom(enumClass) ? enumClass : MetaObjectTools.getEnumForQFlags(enumClass);
                intdata.add(contentEnumClass.getEnumConstants().length);
                dataIndexOfEnums.put(enumClass, intdata.size());
                intdata.add(0);
            }
            for (int i4 = 0; i4 < enumList.size(); ++i4) {
                Class<?> enumClass = (Class<?>)enumList.get(i4);
                Class<?> contentEnumClass = Enum.class.isAssignableFrom(enumClass) ? enumClass : MetaObjectTools.getEnumForQFlags(enumClass);
                int ENUM_DATA_INDEX = (Integer)dataIndexOfEnums.get(enumClass);
                intdata.set(ENUM_DATA_INDEX, intdata.size());
                for (Enum enumConstant : (Enum[])contentEnumClass.getEnumConstants()) {
                    strings.add(enumConstant.name());
                    intdata.add(strings.indexOf(enumConstant.name()));
                    if (enumConstant instanceof QtEnumerator) {
                        QtEnumerator enumerator = (QtEnumerator)((Object)enumConstant);
                        intdata.add(enumerator.value());
                        continue;
                    }
                    intdata.add(enumConstant.ordinal());
                }
            }
        }
        intdata.add(0);
        metaData.metaData = new int[intdata.size()];
        for (i = 0; i < metaData.metaData.length; ++i) {
            metaData.metaData[i] = (Integer)intdata.get(i);
        }
        metaData.stringData = new byte[strings.size()][];
        for (i = 0; i < metaData.stringData.length; ++i) {
            try {
                metaData.stringData[i] = ((String)strings.get(i)).getBytes("UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                metaData.stringData[i] = ((String)strings.get(i)).getBytes();
            }
        }
        metaData.originalSignatures = originalSignatures.toArray(new String[originalSignatures.size()]);
        return metaData;
    }

    private static int resolveMetaDataRevision() {
        int revisionOverride;
        int r = revision;
        if (r != 0) {
            return r;
        }
        int[] versionA = Utilities.getVersion();
        int major = -1;
        if (versionA.length > 0) {
            major = versionA[0];
        }
        int minor = -1;
        if (versionA.length > 1) {
            minor = versionA[1];
        }
        int plevel = -1;
        if (versionA.length > 2) {
            plevel = versionA[2];
        }
        if ((revisionOverride = MetaObjectTools.resolveMetaDataRevisionFromSystemProperty(r = major <= 3 ? 1 : (major == 4 && minor <= 5 ? 1 : (major == 4 && minor == 6 ? 4 : (major == 4 && minor == 7 ? 5 : (major == 4 ? 6 : (major == 5 ? 7 : 7))))))) > 0) {
            r = revisionOverride;
        }
        revision = r;
        return r;
    }

    private static int resolveMetaDataRevisionFromSystemProperty(int defaultRevision) {
        int r = 0;
        String s = null;
        try {
            s = System.getProperty(K_org_qtjambi_qt_qtjambi_metadata_revision);
            if (s != null && ((r = Integer.parseInt(s)) <= 0 || r > 7)) {
                r = -1;
            }
        }
        catch (NumberFormatException e) {
            r = -1;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (r < 0) {
            System.err.println("System Property org.qtjambi.qt.qtjambi.metadata.revision invalid value: " + s + " using default: " + defaultRevision);
        }
        return r;
    }

    private static int generateTypeInfo(List<String> strings, String typeName) {
        if (MetaObjectTools.isBuiltinType(typeName)) {
            QMetaType.Type type = MetaObjectTools.nameToBuiltinType(typeName);
            return type.value;
        }
        return Integer.MIN_VALUE | strings.indexOf(typeName);
    }

    private static boolean isBuiltinType(String type) {
        QMetaType.Type id = QMetaType.type(type);
        if (id == QMetaType.Type.UnknownType) {
            return false;
        }
        return id.value < QMetaType.Type.User.value;
    }

    private static QMetaType.Type nameToBuiltinType(String name) {
        if (name.isEmpty()) {
            return QMetaType.Type.UnknownType;
        }
        QMetaType.Type tp = QMetaType.type(name);
        return tp.value < QMetaType.Type.User.value ? tp : QMetaType.Type.UnknownType;
    }

    private static native int __qt_registerMetaType(Class<?> var0);

    public static int registerMetaType(Class<?> clazz) {
        String packageName = clazz.getName();
        int idx = packageName.lastIndexOf(46);
        if (idx > 0) {
            packageName = packageName.substring(0, idx);
        }
        Utilities.initializePackage(packageName);
        return MetaObjectTools.__qt_registerMetaType(clazz);
    }

    private static int aggregateParameterCount(List<?> list) {
        int sum = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object method = list.get(i);
            if (method instanceof QtJambiInternal.ResolvedSignal) {
                sum += ((QtJambiInternal.ResolvedSignal)method).types.length + 1;
                continue;
            }
            if (method instanceof Method) {
                sum += ((Method)method).getGenericParameterTypes().length + 1;
                continue;
            }
            if (!(method instanceof Constructor)) continue;
            sum += ((Constructor)method).getGenericParameterTypes().length + 1;
        }
        return sum;
    }

    private static class StringList
    extends ArrayList<String> {
        private static final long serialVersionUID = -7793211808465428478L;

        private StringList() {
        }

        @Override
        public boolean add(String e) {
            if (!this.contains(e)) {
                return super.add(e);
            }
            return true;
        }
    }

    private static class MetaData {
        public int[] metaData;
        public byte[][] stringData;
        public Field[] signalsArray;
        public Method[] slotsArray;
        public Constructor<?>[] constructorsArray;
        public Method[] propertyReadersArray;
        public Method[] propertyWritersArray;
        public Method[] propertyResettersArray;
        public Field[] propertyNotifiesArray;
        public Method[] propertyDesignableResolverArray;
        public Method[] propertyScriptableResolverArray;
        public Method[] propertyEditableResolverArray;
        public Method[] propertyStoredResolverArray;
        public Method[] propertyUserResolverArray;
        public Class<?>[] extraDataArray = new Class[0];
        public String[] originalSignatures;
        public boolean hasStaticMembers;

        private MetaData() {
        }
    }

    private static class Container {
        private Member member;
        private String name = null;
        private boolean enabled;
        private AnnotationType type;

        private Container(String name, Member member, boolean enabled, AnnotationType type) {
            this.name = name;
            this.member = member;
            this.enabled = enabled;
            this.type = type;
        }

        private Container(QtPropertyReader reader, Method method) {
            this(reader.name(), method, reader.enabled(), AnnotationType.Reader);
        }

        private Container(QtPropertyWriter writer, Method method) {
            this(writer.name(), method, writer.enabled(), AnnotationType.Writer);
        }

        private Container(QtPropertyResetter resetter, Method method) {
            this(resetter.name(), method, resetter.enabled(), AnnotationType.Resetter);
        }

        private Container(QtPropertyNotify notify, Field method) {
            this(notify.name(), method, notify.enabled(), AnnotationType.Notify);
        }

        private static String removeAndLowercaseFirst(String name, int count) {
            return Character.toLowerCase(name.charAt(count)) + name.substring(count + 1);
        }

        private String getNameFromMethod(Member method) {
            if (this.type == AnnotationType.Resetter) {
                return "";
            }
            if (this.type == AnnotationType.Notify) {
                return "";
            }
            if (this.type == AnnotationType.Reader) {
                String name = method.getName();
                int len = name.length();
                if (name.startsWith("get") && len > 3) {
                    name = Container.removeAndLowercaseFirst(name, 3);
                } else if (MetaObjectTools.isBoolean(((Method)method).getReturnType()) && name.startsWith("is") && len > 2) {
                    name = Container.removeAndLowercaseFirst(name, 2);
                } else if (MetaObjectTools.isBoolean(((Method)method).getReturnType()) && name.startsWith("has") && len > 3) {
                    name = Container.removeAndLowercaseFirst(name, 3);
                }
                return name;
            }
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3) {
                throw new IllegalArgumentException("The correct pattern for setter accessor names is setXxx where Xxx is the property name with upper case initial.");
            }
            name = Container.removeAndLowercaseFirst(name, 3);
            return name;
        }

        private String name() {
            if (this.name == null || this.name.length() == 0) {
                this.name = this.getNameFromMethod(this.member);
            }
            return this.name;
        }

        private boolean enabled() {
            return this.enabled;
        }

        private static Container readerAnnotation(Method method) {
            QtPropertyReader reader = method.getAnnotation(QtPropertyReader.class);
            return reader == null ? null : new Container(reader, method);
        }

        private static Container writerAnnotation(Method method) {
            QtPropertyWriter writer = method.getAnnotation(QtPropertyWriter.class);
            return writer == null ? null : new Container(writer, method);
        }

        private static Container resetterAnnotation(Method method) {
            QtPropertyResetter resetter = method.getAnnotation(QtPropertyResetter.class);
            return resetter == null ? null : new Container(resetter, method);
        }

        private static Container notifyAnnotation(Field field) {
            QtPropertyNotify notify = field.getAnnotation(QtPropertyNotify.class);
            return notify == null ? null : new Container(notify, field);
        }

        private static enum AnnotationType {
            Reader,
            Writer,
            Resetter,
            Notify;

        }
    }

    static enum VariableContext {
        ReturnType,
        ArgumentType;

    }
}

