/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.designer;

import java.util.HashMap;
import org.qtjambi.qt.core.Qt;
import org.qtjambi.qt.designer.AbstractPropertyHandler;
import org.qtjambi.qt.designer.QUiLoaderException;
import org.qtjambi.qt.xml.QDomElement;

class EnumPropertyHandler
extends AbstractPropertyHandler {
    private static HashMap<String, Object> hardcodedValues = new HashMap();

    EnumPropertyHandler() {
    }

    @Override
    public Object create(QDomElement e) throws QUiLoaderException {
        String name = this.childStringValue(e);
        return EnumPropertyHandler.enumForValue(name);
    }

    static Object enumForValue(String name) throws QUiLoaderException {
        Object hcValue = hardcodedValues.get(name);
        if (hcValue != null) {
            return hcValue;
        }
        int valuePos = name.lastIndexOf(46);
        int enumPos = name.lastIndexOf(46, valuePos - 1);
        if (enumPos > 0 && valuePos > 0) {
            String className = name.substring(0, enumPos);
            String enumName = name.substring(enumPos + 1, valuePos);
            String enumValue = name.substring(valuePos + 1);
            try {
                Class<?> cl = Class.forName(className + '$' + enumName);
                return Enum.valueOf(cl, enumValue);
            }
            catch (Exception ex) {
                throw new QUiLoaderException("Converting enum '" + name + "' failed...", ex);
            }
        }
        throw new QUiLoaderException("Converting enum '" + name + "' failed", null);
    }

    static {
        hardcodedValues.put("TopToolBarArea", Qt.ToolBarArea.TopToolBarArea.value());
        hardcodedValues.put("BottomToolBarArea", Qt.ToolBarArea.BottomToolBarArea.value());
        hardcodedValues.put("RightToolBarArea", Qt.ToolBarArea.RightToolBarArea.value());
        hardcodedValues.put("LeftToolBarArea", Qt.ToolBarArea.LeftToolBarArea.value());
    }
}

