/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.qtjambi.qt.core.QCoreApplication;
import org.qtjambi.qt.core.QEvent;
import org.qtjambi.qt.core.QObject;

class QSynchronousInvokable
extends QObject {
    static QEvent.Type SYNCHRONOUS_INVOKABLE_EVENT = QEvent.Type.resolve(QEvent.Type.User.value() + 1);
    private Runnable runnable;
    private Boolean invoked = false;

    public QSynchronousInvokable(Runnable runnable) {
        this.disableGarbageCollection();
        if (QCoreApplication.instance().nativeId() != 0L) {
            this.moveToThread(QCoreApplication.instance().thread());
            this.runnable = runnable;
        }
        if (runnable == null || Thread.currentThread().equals(QCoreApplication.instance().thread())) {
            this.invoked = true;
        }
    }

    synchronized void waitForInvoked() {
        while (!this.invoked.booleanValue()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "waitForInvoked()", "InterruptedException", e);
            }
        }
        this.invoked = false;
    }

    synchronized void waitForInvokedOrInterrupt() throws InterruptedException {
        while (!this.invoked.booleanValue()) {
            this.wait();
        }
        this.invoked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean event(QEvent e) {
        if (e.type() == SYNCHRONOUS_INVOKABLE_EVENT && this.runnable != null) {
            this.runnable.run();
            QSynchronousInvokable qSynchronousInvokable = this;
            synchronized (qSynchronousInvokable) {
                this.invoked = true;
                this.notifyAll();
            }
            return true;
        }
        return super.event(e);
    }
}

