/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.core;

import org.qtjambi.qt.QNativePointer;
import org.qtjambi.qt.core.QAbstractItemModel;

public class QModelIndex {
    private int row;
    private int column;
    private long internalId;
    private QAbstractItemModel model;

    private QModelIndex(int row, int column, long internalId, QAbstractItemModel model) {
        this.row = row;
        this.column = column;
        this.internalId = internalId;
        this.model = model;
    }

    public int row() {
        return this.row;
    }

    public int column() {
        return this.column;
    }

    public long internalId() {
        return this.internalId;
    }

    public QNativePointer internalPointer() {
        QNativePointer np = new QNativePointer(QNativePointer.Type.Long);
        np.setLongValue(this.internalId);
        return np;
    }

    public QModelIndex parent() {
        return this.model != null ? this.model.parent(this) : null;
    }

    public QModelIndex sibling(int arow, int acolumn) {
        return this.model != null ? this.model.index(arow, acolumn, this.model.parent(this)) : null;
    }

    public QModelIndex child(int arow, int acolumn) {
        return this.model != null ? this.model.index(arow, acolumn, this) : null;
    }

    public Object data() {
        return this.data(0);
    }

    public Object data(int role) {
        return this.model != null ? this.model.data(this, role) : null;
    }

    public QAbstractItemModel model() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (!(other instanceof QModelIndex)) {
            return false;
        }
        QModelIndex oi = (QModelIndex)other;
        return oi.row == this.row && oi.column == this.column && oi.internalId == this.internalId && oi.model == this.model;
    }

    public int hashCode() {
        return this.row << (int)((long)(4 + this.column) + this.internalId);
    }

    public String toString() {
        return "QModelIndex(row=" + this.row + ",col=" + this.column + ",internal=" + this.internalId + ")";
    }
}

