/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.qtjambi.qt.QThreadManager;
import org.qtjambi.qt.QtJambi_LibraryShutdown;
import org.qtjambi.qt.Utilities;
import org.qtjambi.qt.core.QMessageHandler;
import org.qtjambi.qt.internal.fileengine.QClassPathFileEngineHandler;

public abstract class QtJambi_LibraryInitializer {
    private static QMessageHandler messageHandler;
    static WeakReference<Thread> shutdownHookThread;

    private static void setupStaticReferences(String className, String[] fieldNameA) {
        Class<?> clazz;
        try {
            ClassLoader classLoader = QtJambi_LibraryInitializer.class.getClassLoader();
            clazz = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException eat) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (String fieldName : fieldNameA) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                field.get(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static void removeMessageHandlerForExceptions() {
        if (messageHandler != null) {
            QMessageHandler.removeMessageHandler(messageHandler);
            messageHandler = null;
        }
    }

    private static void installMessageHandlerForExceptions(String config) {
        if (config != null) {
            final boolean all = (config = config.trim().toUpperCase()).equals("") || config.equals("ALL") || config.equals("TRUE");
            final boolean critical = config.contains("CRITICAL");
            final boolean debug = config.contains("DEBUG");
            final boolean fatal = config.contains("FATAL");
            final boolean warning = config.contains("WARNING");
            boolean none = config.contains("NONE");
            if (all || critical || debug || fatal || warning || none) {
                QMessageHandler newMessageHandler = new QMessageHandler(){

                    @Override
                    public void critical(String message) {
                        if (critical || all) {
                            throw new RuntimeException("Critical: " + message);
                        }
                        System.err.println("Critical: " + message);
                    }

                    @Override
                    public void debug(String message) {
                        if (debug || all) {
                            throw new RuntimeException("Debug: " + message);
                        }
                        System.err.println("Debug: " + message);
                    }

                    @Override
                    public void fatal(String message) {
                        if (fatal || all) {
                            throw new RuntimeException("Fatal: " + message);
                        }
                        System.err.println("Fatal: " + message);
                    }

                    @Override
                    public void warning(String message) {
                        if (warning || all) {
                            throw new RuntimeException("Warning: " + message);
                        }
                        System.err.println("Warning: " + message);
                    }
                };
                QMessageHandler.replaceMessageHandler(messageHandler, newMessageHandler);
                messageHandler = newMessageHandler;
            }
        }
    }

    public static void init() {
    }

    private static native void initialize();

    static {
        try {
            Utilities.loadSystemLibraries();
            if (Utilities.isAvailableUtilityLibrary("icudata", "51")) {
                Utilities.loadUtilityLibrary("icudata", "51");
            }
            if (Utilities.isAvailableUtilityLibrary("icuuc", "51")) {
                Utilities.loadUtilityLibrary("icuuc", "51");
            }
            if (Utilities.isAvailableUtilityLibrary("icui18n", "51")) {
                Utilities.loadUtilityLibrary("icui18n", "51");
            }
            Utilities.loadQtLibrary("QtCore");
            Utilities.loadJambiJniLibrary("qtjambi");
            String s = System.getProperty("org.qtjambi.qt.exceptions-for-messages");
            QtJambi_LibraryInitializer.installMessageHandlerForExceptions(s);
            QClassPathFileEngineHandler.initialize();
            QClassPathFileEngineHandler.start();
            QtJambi_LibraryInitializer.initialize();
            QThreadManager.initialize();
            Thread thread = new Thread(new QtJambi_LibraryShutdown());
            thread.setName("qtjambi-" + QtJambi_LibraryShutdown.class.getName());
            Runtime.getRuntime().addShutdownHook(thread);
            shutdownHookThread = new WeakReference<Thread>(thread);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

