/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt;

import java.util.HashMap;
import org.qtjambi.qt.QtInfo;
import org.qtjambi.qt.gui.QPainter;
import org.qtjambi.qt.gui.QPixmap;
import org.qtjambi.qt.widgets.QAbstractScrollArea;
import org.qtjambi.qt.widgets.QApplication;
import org.qtjambi.qt.widgets.QMessageBox;
import org.qtjambi.qt.widgets.QWidget;

public class QtJambiGuiInternal {
    private static HashMap<QWidget, QPainter> painters = new HashMap();

    public static void aboutQtJambi() {
        QMessageBox mb = new QMessageBox(QApplication.activeWindow());
        mb.setWindowTitle("About Qt Jambi");
        mb.setText("<h3>About Qt Jambi</h3><p>Qt Jambi is a Java toolkit based on Qt, a C++ toolkit for cross-platform application development.</p><p>This program uses Qt version " + QtInfo.versionString() + ".</p><p>Qt Jambi provides single-source portability across MS&nbsp;Windows, Mac&nbsp;OS&nbsp;X, Linux, and all major commercial Unix variants<p>See <a href=\"http://www.qt-jambi.org\">http://www.qt-jambi.org</a> for more information.</p>");
        mb.setIconPixmap(new QPixmap("classpath:org/qtjambi/qt/images/qt-logo.png"));
        mb.exec();
    }

    public static boolean beginPaint(QWidget widget, QPainter painter) {
        if (painters.containsKey(widget)) {
            throw new RuntimeException("Painter opened twice on the same widget");
        }
        if (painter.isActive()) {
            throw new RuntimeException("Painter already active");
        }
        painters.put(widget, painter);
        return painter.begin(widget);
    }

    private static void endPaint(QWidget widget) {
        QPainter p = painters.get(widget);
        if (p != null) {
            if (p.isActive()) {
                p.end();
            }
            p.dispose();
            painters.remove(widget);
        }
        if (widget instanceof QAbstractScrollArea) {
            QtJambiGuiInternal.endPaint(((QAbstractScrollArea)widget).viewport());
        }
    }
}

