/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt;

import org.qtjambi.qt.QtJambi_LibraryInitializer;

public class QNativePointer {
    private long m_ptr;
    private Type m_type;
    private int m_knownSize;
    private AutoDeleteMode m_autodelete;
    private int m_indirections;
    private boolean m_verification_enabled = true;

    public QNativePointer(Type type) {
        this(type, 1);
    }

    public QNativePointer(Type type, int size) {
        this(type, size, 1);
    }

    public QNativePointer(Type type, int size, int indirections) {
        if (indirections < 1) {
            throw new IllegalArgumentException("level of indirection must be at least 1");
        }
        if (size == 0) {
            throw new IllegalArgumentException("size must be at least 1");
        }
        this.m_ptr = QNativePointer.createPointer(type.ordinal(), size, indirections);
        this.m_type = type;
        this.m_knownSize = size;
        this.m_indirections = indirections;
        this.m_autodelete = size == 1 ? AutoDeleteMode.Delete : AutoDeleteMode.DeleteArray;
    }

    private QNativePointer(int type, int size, int indirections) {
        this(QNativePointer.typeOf(type), size, indirections);
    }

    private QNativePointer() {
        this.m_knownSize = -1;
        this.m_autodelete = AutoDeleteMode.None;
    }

    public boolean booleanValue() {
        return this.booleanAt(0);
    }

    public byte byteValue() {
        return this.byteAt(0);
    }

    public char charValue() {
        return this.charAt(0);
    }

    public short shortValue() {
        return this.shortAt(0);
    }

    public int intValue() {
        return this.intAt(0);
    }

    public long longValue() {
        return this.longAt(0);
    }

    public float floatValue() {
        return this.floatAt(0);
    }

    public double doubleValue() {
        return this.doubleAt(0);
    }

    public QNativePointer pointerValue() {
        return this.pointerAt(0);
    }

    public String stringValue() {
        return this.stringAt(0);
    }

    public void setBooleanValue(boolean value) {
        this.setBooleanAt(0, value);
    }

    public void setByteValue(byte value) {
        this.setByteAt(0, value);
    }

    public void setCharValue(char value) {
        this.setCharAt(0, value);
    }

    public void setShortValue(short value) {
        this.setShortAt(0, value);
    }

    public void setIntValue(int value) {
        this.setIntAt(0, value);
    }

    public void setLongValue(long value) {
        this.setLongAt(0, value);
    }

    public void setFloatValue(float value) {
        this.setFloatAt(0, value);
    }

    public void setDoubleValue(double value) {
        this.setDoubleAt(0, value);
    }

    public void setPointerValue(QNativePointer value) {
        this.setPointerAt(0, value);
    }

    public void setStringValue(String value) {
        this.setStringAt(0, value);
    }

    public boolean booleanAt(int pos) {
        this.verifyAccess(Type.Boolean, pos);
        return QNativePointer.readBoolean(this.m_ptr, pos);
    }

    public byte byteAt(int pos) {
        this.verifyAccess(Type.Byte, pos);
        return QNativePointer.readByte(this.m_ptr, pos);
    }

    public char charAt(int pos) {
        this.verifyAccess(Type.Char, pos);
        return QNativePointer.readChar(this.m_ptr, pos);
    }

    public short shortAt(int pos) {
        this.verifyAccess(Type.Short, pos);
        return QNativePointer.readShort(this.m_ptr, pos);
    }

    public int intAt(int pos) {
        this.verifyAccess(Type.Int, pos);
        return QNativePointer.readInt(this.m_ptr, pos);
    }

    public long longAt(int pos) {
        this.verifyAccess(Type.Long, pos);
        return QNativePointer.readLong(this.m_ptr, pos);
    }

    public float floatAt(int pos) {
        this.verifyAccess(Type.Float, pos);
        return QNativePointer.readFloat(this.m_ptr, pos);
    }

    public double doubleAt(int pos) {
        this.verifyAccess(Type.Double, pos);
        return QNativePointer.readDouble(this.m_ptr, pos);
    }

    public QNativePointer pointerAt(int pos) {
        this.verifyAccess(Type.Pointer, pos);
        long ptr = QNativePointer.readPointer(this.m_ptr, pos);
        return QNativePointer.fromNative(ptr, this.m_type, this.m_indirections - 1);
    }

    public String stringAt(int pos) {
        this.verifyAccess(Type.String, pos);
        return QNativePointer.readString(this.m_ptr, pos);
    }

    public void setBooleanAt(int pos, boolean value) {
        this.verifyAccess(Type.Boolean, pos);
        QNativePointer.writeBoolean(this.m_ptr, pos, value);
    }

    public void setByteAt(int pos, byte value) {
        this.verifyAccess(Type.Byte, pos);
        QNativePointer.writeByte(this.m_ptr, pos, value);
    }

    public void setCharAt(int pos, char value) {
        this.verifyAccess(Type.Char, pos);
        QNativePointer.writeChar(this.m_ptr, pos, value);
    }

    public void setShortAt(int pos, short value) {
        this.verifyAccess(Type.Short, pos);
        QNativePointer.writeShort(this.m_ptr, pos, value);
    }

    public void setIntAt(int pos, int value) {
        this.verifyAccess(Type.Int, pos);
        QNativePointer.writeInt(this.m_ptr, pos, value);
    }

    public void setLongAt(int pos, long value) {
        this.verifyAccess(Type.Long, pos);
        QNativePointer.writeLong(this.m_ptr, pos, value);
    }

    public void setFloatAt(int pos, float value) {
        this.verifyAccess(Type.Float, pos);
        QNativePointer.writeFloat(this.m_ptr, pos, value);
    }

    public void setDoubleAt(int pos, double value) {
        this.verifyAccess(Type.Double, pos);
        QNativePointer.writeDouble(this.m_ptr, pos, value);
    }

    public void setPointerAt(int pos, QNativePointer value) {
        this.verifyAccess(Type.Pointer, pos);
        if (value != null) {
            value.setAutoDeleteMode(AutoDeleteMode.None);
        }
        QNativePointer.writePointer(this.m_ptr, pos, value == null ? 0L : value.m_ptr);
    }

    public void setStringAt(int pos, String value) {
        this.verifyAccess(Type.String, pos);
        QNativePointer.writeString(this.m_ptr, pos, value);
    }

    public Type type() {
        return this.m_type;
    }

    public int indirections() {
        return this.m_indirections;
    }

    public boolean isNull() {
        return this.m_ptr == 0L;
    }

    public AutoDeleteMode autoDeleteMode() {
        return this.m_autodelete;
    }

    public void setAutoDeleteMode(AutoDeleteMode autodelete) {
        this.m_autodelete = autodelete;
    }

    public void free() {
        if (this.isNull()) {
            return;
        }
        QNativePointer.deletePointer(this.m_ptr, this.m_type.ordinal(), 0);
        this.m_ptr = 0L;
    }

    public void delete() {
        if (this.isNull()) {
            return;
        }
        QNativePointer.deletePointer(this.m_ptr, this.m_type.ordinal(), 1);
        this.m_ptr = 0L;
    }

    public void deleteArray() {
        if (this.isNull()) {
            return;
        }
        QNativePointer.deletePointer(this.m_ptr, this.m_type.ordinal(), 2);
        this.m_ptr = 0L;
    }

    public long pointer() {
        return this.m_ptr;
    }

    public static QNativePointer fromNative(long ptr, Type type, int indirections) {
        QNativePointer nativePointer = new QNativePointer();
        nativePointer.m_ptr = ptr;
        nativePointer.m_type = type;
        nativePointer.m_indirections = indirections;
        return nativePointer;
    }

    public boolean verificationEnabled() {
        return this.m_verification_enabled;
    }

    public void setVerificationEnabled(boolean a) {
        this.m_verification_enabled = a;
    }

    private static Type typeOf(int type) {
        switch (type) {
            case 0: {
                return Type.Boolean;
            }
            case 1: {
                return Type.Byte;
            }
            case 2: {
                return Type.Char;
            }
            case 3: {
                return Type.Short;
            }
            case 4: {
                return Type.Int;
            }
            case 5: {
                return Type.Long;
            }
            case 6: {
                return Type.Float;
            }
            case 7: {
                return Type.Double;
            }
            case 8: {
                return Type.Pointer;
            }
        }
        throw new IllegalArgumentException("Unknown type id: " + type);
    }

    public static QNativePointer fromNative(long ptr, int type, int indirections) {
        return QNativePointer.fromNative(ptr, QNativePointer.typeOf(type), indirections);
    }

    public static QNativePointer createCharPointerPointer(String[] strings) {
        if (strings == null) {
            return null;
        }
        QNativePointer ptrs = new QNativePointer(Type.Byte, strings.length + 1, 2);
        for (int j = 0; j < strings.length; ++j) {
            String string = strings[j];
            ptrs.setPointerAt(j, QNativePointer.createCharPointer(string));
        }
        ptrs.setPointerAt(strings.length, null);
        return ptrs;
    }

    public static QNativePointer createCharPointer(String string) {
        if (string == null) {
            return null;
        }
        QNativePointer s = new QNativePointer(Type.Byte, string.length() + 1);
        for (int i = 0; i < string.length(); ++i) {
            s.setByteAt(i, (byte)string.charAt(i));
        }
        s.setByteAt(string.length(), (byte)0);
        return s;
    }

    protected void finalize() {
        switch (this.m_autodelete) {
            case Free: {
                this.free();
                break;
            }
            case Delete: {
                this.delete();
                break;
            }
            case DeleteArray: {
                this.deleteArray();
            }
        }
    }

    private void verifyAccess(Type type, int pos) {
        if (!this.m_verification_enabled) {
            return;
        }
        if (this.isNull()) {
            throw new NullPointerException("native pointer is null");
        }
        if (pos < 0) {
            throw new IndexOutOfBoundsException("negative index: " + pos);
        }
        if (this.m_knownSize >= 0 && pos >= this.m_knownSize) {
            throw new IndexOutOfBoundsException("size: " + this.m_knownSize + ", access at: " + pos);
        }
        if (this.m_indirections > 1) {
            if (type != Type.Pointer) {
                throw new ClassCastException("accessing pointer with " + this.m_indirections + " levels of indirection as " + (Object)((Object)type));
            }
        } else if (type != this.m_type) {
            throw new ClassCastException("type: " + (Object)((Object)this.m_type) + ", accessed as: " + (Object)((Object)type));
        }
    }

    private static native boolean readBoolean(long var0, int var2);

    private static native byte readByte(long var0, int var2);

    private static native char readChar(long var0, int var2);

    private static native short readShort(long var0, int var2);

    private static native int readInt(long var0, int var2);

    private static native long readLong(long var0, int var2);

    private static native float readFloat(long var0, int var2);

    private static native double readDouble(long var0, int var2);

    private static native long readPointer(long var0, int var2);

    private static native String readString(long var0, int var2);

    private static native void writeBoolean(long var0, int var2, boolean var3);

    private static native void writeByte(long var0, int var2, byte var3);

    private static native void writeChar(long var0, int var2, char var3);

    private static native void writeShort(long var0, int var2, short var3);

    private static native void writeInt(long var0, int var2, int var3);

    private static native void writeLong(long var0, int var2, long var3);

    private static native void writeFloat(long var0, int var2, float var3);

    private static native void writeDouble(long var0, int var2, double var3);

    private static native void writePointer(long var0, int var2, long var3);

    private static native void writeString(long var0, int var2, String var3);

    private static native long createPointer(int var0, int var1, int var2);

    private static native void deletePointer(long var0, int var2, int var3);

    static {
        QtJambi_LibraryInitializer.init();
    }

    public static enum AutoDeleteMode {
        Free,
        Delete,
        DeleteArray,
        None;

    }

    public static enum Type {
        Boolean,
        Byte,
        Char,
        Short,
        Int,
        Long,
        Float,
        Double,
        Pointer,
        String;

    }
}

