/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.type.BooleanRef;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.type.DoubleRef;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.type.IntegerRef;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.type.StringRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiSynth {
    private static final String JNI_LIBRARY_NAME = new String("tuxguitar-fluidsynth-jni");
    private long instance = this.malloc();
    private MidiOutputPortImpl loadedPort = null;

    public boolean isInitialized() {
        return this.instance != 0L;
    }

    public void finalize() {
        if (this.isInitialized()) {
            this.free(this.instance);
            this.instance = 0L;
        }
    }

    public boolean isConnected(MidiOutputPortImpl port) {
        return port != null && this.loadedPort != null && ((Object)((Object)this.loadedPort)).equals((Object)port);
    }

    public void connect(MidiOutputPortImpl port) {
        if (this.isInitialized()) {
            this.disconnect(this.loadedPort);
            this.open(this.instance);
            this.loadFont(this.instance, port.getSoundFont());
            this.loadedPort = port;
        }
    }

    public void disconnect(MidiOutputPortImpl port) {
        if (this.isInitialized() && this.isConnected(port)) {
            this.unloadFont(this.instance);
            this.close(this.instance);
            this.loadedPort = null;
        }
    }

    public void reconnect() {
        MidiOutputPortImpl connection = this.loadedPort;
        if (this.isConnected(connection)) {
            this.disconnect(connection);
            this.connect(connection);
        }
    }

    public void sendSystemReset() {
        if (this.isInitialized()) {
            this.systemReset(this.instance);
        }
    }

    public void sendNoteOn(int channel, int key, int velocity) {
        if (this.isInitialized()) {
            this.noteOn(this.instance, channel, key, velocity);
        }
    }

    public void sendNoteOff(int channel, int key, int velocity) {
        if (this.isInitialized()) {
            this.noteOff(this.instance, channel, key, velocity);
        }
    }

    public void sendControlChange(int channel, int controller, int value) {
        if (this.isInitialized()) {
            this.controlChange(this.instance, channel, controller, value);
        }
    }

    public void sendProgramChange(int channel, int value) {
        if (this.isInitialized()) {
            this.programChange(this.instance, channel, value);
        }
    }

    public void sendPitchBend(int channel, int value) {
        if (this.isInitialized()) {
            this.pitchBend(this.instance, channel, value);
        }
    }

    public void setDoubleProperty(String key, double value) {
        if (this.isInitialized()) {
            this.setDoubleProperty(this.instance, key, value);
        }
    }

    public void setIntegerProperty(String key, int value) {
        if (this.isInitialized()) {
            this.setIntegerProperty(this.instance, key, value);
        }
    }

    public void setStringProperty(String key, String value) {
        if (this.isInitialized()) {
            this.setStringProperty(this.instance, key, value);
        }
    }

    public double getDoubleProperty(String key) {
        DoubleRef value = new DoubleRef();
        if (this.isInitialized()) {
            this.getDoubleProperty(this.instance, key, value);
        }
        return value.getValue();
    }

    public int getIntegerProperty(String key) {
        IntegerRef value = new IntegerRef();
        if (this.isInitialized()) {
            this.getIntegerProperty(this.instance, key, value);
        }
        return value.getValue();
    }

    public String getStringProperty(String key) {
        StringRef value = new StringRef();
        if (this.isInitialized()) {
            this.getStringProperty(this.instance, key, value);
        }
        return value.getValue();
    }

    public double getDoublePropertyDefault(String key) {
        DoubleRef value = new DoubleRef();
        if (this.isInitialized()) {
            this.getDoublePropertyDefault(this.instance, key, value);
        }
        return value.getValue();
    }

    public int getIntegerPropertyDefault(String key) {
        IntegerRef value = new IntegerRef();
        if (this.isInitialized()) {
            this.getIntegerPropertyDefault(this.instance, key, value);
        }
        return value.getValue();
    }

    public String getStringPropertyDefault(String key) {
        StringRef value = new StringRef();
        if (this.isInitialized()) {
            this.getStringPropertyDefault(this.instance, key, value);
        }
        return value.getValue();
    }

    public <T> List<T> getPropertyOptions(String key) {
        ArrayList options = new ArrayList();
        if (this.isInitialized()) {
            this.getPropertyOptions(this.instance, key, options);
        }
        return options;
    }

    public int[] getIntegerPropertyRange(String key) {
        IntegerRef minimum = new IntegerRef();
        IntegerRef maximum = new IntegerRef();
        if (this.isInitialized()) {
            this.getIntegerPropertyRange(this.instance, key, minimum, maximum);
        }
        return new int[]{minimum.getValue(), maximum.getValue()};
    }

    public double[] getDoublePropertyRange(String key) {
        DoubleRef minimum = new DoubleRef();
        DoubleRef maximum = new DoubleRef();
        if (this.isInitialized()) {
            this.getDoublePropertyRange(this.instance, key, minimum, maximum);
        }
        return new double[]{minimum.getValue(), maximum.getValue()};
    }

    public boolean isRealtimeProperty(String key) {
        BooleanRef value = new BooleanRef();
        if (this.isInitialized()) {
            this.isRealtimeProperty(this.instance, key, value);
        }
        return value.getValue();
    }

    private native long malloc();

    private native void free(long var1);

    private native void open(long var1);

    private native void close(long var1);

    private native void loadFont(long var1, String var3);

    private native void unloadFont(long var1);

    private native void systemReset(long var1);

    private native void noteOn(long var1, int var3, int var4, int var5);

    private native void noteOff(long var1, int var3, int var4, int var5);

    private native void controlChange(long var1, int var3, int var4, int var5);

    private native void programChange(long var1, int var3, int var4);

    private native void pitchBend(long var1, int var3, int var4);

    private native void setDoubleProperty(long var1, String var3, double var4);

    private native void setIntegerProperty(long var1, String var3, int var4);

    private native void setStringProperty(long var1, String var3, String var4);

    private native void getDoubleProperty(long var1, String var3, DoubleRef var4);

    private native void getIntegerProperty(long var1, String var3, IntegerRef var4);

    private native void getStringProperty(long var1, String var3, StringRef var4);

    private native void getDoublePropertyDefault(long var1, String var3, DoubleRef var4);

    private native void getIntegerPropertyDefault(long var1, String var3, IntegerRef var4);

    private native void getStringPropertyDefault(long var1, String var3, StringRef var4);

    private native void getDoublePropertyRange(long var1, String var3, DoubleRef var4, DoubleRef var5);

    private native void getIntegerPropertyRange(long var1, String var3, IntegerRef var4, IntegerRef var5);

    private native <T> void getPropertyOptions(long var1, String var3, List<T> var4);

    private native void isRealtimeProperty(long var1, String var3, BooleanRef var4);

    static {
        System.loadLibrary(JNI_LIBRARY_NAME);
    }
}

