/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.alsa;

import org.herac.tuxguitar.gm.port.GMReceiver;
import org.herac.tuxguitar.player.impl.midiport.alsa.MidiOutputPortImpl;
import org.herac.tuxguitar.player.impl.midiport.alsa.MidiSystem;

public class MidiReceiverImpl
implements GMReceiver {
    private boolean connected;
    private MidiOutputPortImpl midiPort;
    private MidiSystem midiSystem;

    public MidiReceiverImpl(MidiOutputPortImpl midiPort, MidiSystem midiSystem) {
        this.midiPort = midiPort;
        this.midiSystem = midiSystem;
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void connect() {
        if (!this.isConnected()) {
            this.midiSystem.openPort(this.midiPort.getClient(), this.midiPort.getPort());
            this.connected = true;
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.midiSystem.closePort();
            this.connected = false;
        }
    }

    public void sendAllNotesOff() {
        for (int i = 0; i < 16; ++i) {
            this.sendControlChange(i, 123, 0);
        }
    }

    public void sendControlChange(int channel, int controller, int value) {
        if (this.isConnected()) {
            this.midiSystem.controlChange(channel, controller, value);
        }
    }

    public void sendNoteOff(int channel, int key, int velocity) {
        if (this.isConnected()) {
            this.midiSystem.noteOff(channel, key, velocity);
        }
    }

    public void sendNoteOn(int channel, int key, int velocity) {
        if (this.isConnected()) {
            this.midiSystem.noteOn(channel, key, velocity);
        }
    }

    public void sendPitchBend(int channel, int value) {
        if (this.isConnected()) {
            this.midiSystem.pitchBend(channel, value);
        }
    }

    public void sendProgramChange(int channel, int value) {
        if (this.isConnected()) {
            this.midiSystem.programChange(channel, value);
        }
    }

    public void sendSystemReset() {
    }
}

