/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.channel;

import org.herac.tuxguitar.app.view.dialog.channel.TGChannelItem;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGKnobSelectionListener
implements UISelectionListener,
Runnable {
    private static final long MAXIMUM_TIME = 500L;
    private long time;
    private boolean running;
    private TGChannelItem handle;
    private Object mutex = new Object();

    public TGKnobSelectionListener(TGChannelItem handle) {
        this.handle = handle;
    }

    public void onSelect(UISelectionEvent event) {
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                Thread thread = new Thread(this);
                thread.start();
            }
            this.time = System.currentTimeMillis();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            long timeToWait = 500L;
            while (this.running) {
                Object object = this.mutex;
                synchronized (object) {
                    timeToWait = this.time + 500L - System.currentTimeMillis();
                    boolean bl = this.running = timeToWait > 0L;
                    if (this.running) {
                        this.mutex.wait(timeToWait);
                    }
                }
            }
            this.doActionSynchronized();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void doActionSynchronized() throws Throwable {
        TGSynchronizer.getInstance((TGContext)this.handle.getContext()).executeLater(new Runnable(){

            public void run() throws TGException {
                TGKnobSelectionListener.this.doAction();
            }
        });
    }

    public void doAction() {
        this.handle.updateChannel(false);
    }
}

