/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal.fileengine;

import com.trolltech.qt.QNativePointer;
import com.trolltech.qt.core.QAbstractFileEngine;
import com.trolltech.qt.core.QDate;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QTime;
import com.trolltech.qt.internal.fileengine.MyJarFile;
import com.trolltech.qt.internal.fileengine.QClassPathEngine;
import com.trolltech.qt.internal.fileengine.QClassPathEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QJarEntryEngine
extends QAbstractFileEngine
implements QClassPathEntry {
    private String m_entryFileName;
    private JarEntry m_entry;
    private MyJarFile m_myJarFile;
    private InputStream m_stream;
    private long m_pos = -1L;
    private int m_openMode;
    private boolean m_valid;
    private boolean m_directory;
    private String m_name;
    private boolean m_eof;
    private boolean m_closed;

    public QJarEntryEngine(MyJarFile myJarFile, String fileName, boolean isDirectory) {
        this.m_myJarFile = myJarFile;
        this.m_directory = isDirectory;
        this.setFileName(fileName);
    }

    void disown() {
        this.m_myJarFile = null;
        this.m_closed = true;
    }

    @Override
    protected void disposed() {
        this.close();
        this.m_entry = null;
        if (!this.m_closed) {
            this.m_myJarFile.put();
            this.m_closed = true;
        }
    }

    @Override
    public void setFileName(String fileName) {
        this.m_entry = null;
        if (this.m_closed) {
            return;
        }
        if (fileName.length() == 0) {
            this.m_entryFileName = "";
            this.m_name = "";
            this.m_valid = true;
            this.m_directory = true;
            return;
        }
        this.m_entryFileName = fileName;
        this.m_entry = this.m_myJarFile.getJarEntry(this.m_entryFileName);
        if (this.m_entry == null && !this.m_directory) {
            this.m_valid = false;
        } else {
            this.m_name = this.m_entry == null ? fileName : this.m_entry.getName();
            this.m_valid = true;
        }
    }

    @Override
    public String classPathEntryName() {
        if (this.m_closed) {
            return null;
        }
        return this.m_myJarFile.getName();
    }

    public boolean isValid() {
        return this.m_valid;
    }

    @Override
    public boolean copy(String newName) {
        int BUFFER_SIZE = 65536;
        QNativePointer buffer = new QNativePointer(QNativePointer.Type.Byte, 65536);
        QFile newFile = new QFile(newName);
        if (newFile.exists()) {
            return false;
        }
        if (!this.open(new QIODevice.OpenMode(QIODevice.OpenModeFlag.ReadOnly))) {
            return false;
        }
        if (!newFile.open(new QIODevice.OpenMode(QIODevice.OpenModeFlag.WriteOnly))) {
            this.closeInternal();
            return false;
        }
        long sz = this.size();
        long i = 0L;
        int bytes_to_read = 0;
        if (sz > 0L) {
            do {
                bytes_to_read = (int)Math.min(sz - i, 65536L);
                bytes_to_read = (int)this.read(buffer, bytes_to_read);
                byte[] bytes = new byte[bytes_to_read];
                for (int j = 0; j < bytes_to_read; ++j) {
                    bytes[j] = buffer.byteAt(j);
                }
                if (bytes_to_read <= 0 || newFile.write(bytes) == bytes_to_read) continue;
                return false;
            } while (i < sz && bytes_to_read > 0);
        }
        newFile.close();
        if (!this.closeInternal()) {
            return false;
        }
        return i == sz;
    }

    public boolean reset() {
        if (this.m_stream == null) {
            return false;
        }
        if (this.m_pos == 0L) {
            return true;
        }
        return this.reopen();
    }

    private boolean reopen() {
        if (this.m_stream == null) {
            return false;
        }
        QIODevice.OpenMode om = new QIODevice.OpenMode(this.m_openMode);
        if (this.closeInternal()) {
            return this.open(om);
        }
        return false;
    }

    private boolean atEnd_internal() {
        return this.m_eof;
    }

    @Override
    public boolean setPermissions(int perms) {
        return false;
    }

    @Override
    public boolean caseSensitive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal() {
        boolean bf = false;
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.m_stream = null;
                this.m_myJarFile.put();
                bf = true;
            }
        }
        return bf;
    }

    @Override
    public boolean close() {
        boolean bf = this.closeInternal();
        if (!this.m_closed) {
            this.m_myJarFile.put();
            this.m_closed = true;
        }
        return bf;
    }

    @Override
    public List<String> entryList(QDir.Filters filters, List<String> filterNames) {
        String mentryName;
        if (!this.m_directory) {
            return new LinkedList<String>();
        }
        LinkedList<String> result = new LinkedList<String>();
        if (!filters.isSet(new QDir.Filter[]{QDir.Filter.NoDotAndDotDot}) && filters.isSet(new QDir.Filter[]{QDir.Filter.Dirs})) {
            result.add(".");
            if (this.m_entryFileName.length() > 0) {
                result.add("..");
            }
        }
        if (!filters.isSet(new QDir.Filter[]{QDir.Filter.Readable, QDir.Filter.Writable, QDir.Filter.Executable})) {
            filters.set(new QDir.Filter[]{QDir.Filter.Readable});
        }
        if (!(mentryName = this.m_name).endsWith("/") && mentryName.length() > 0) {
            mentryName = mentryName + "/";
        }
        Enumeration<JarEntry> entries = this.m_myJarFile.entries();
        HashSet<String> used = new HashSet<String>();
        while (entries.hasMoreElements()) {
            boolean isDir;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (entryName.length() <= mentryName.length() || !mentryName.equals(entryName.substring(0, mentryName.length())) || mentryName.equals(entryName)) continue;
            int pos = entryName.indexOf("/", mentryName.length());
            if (pos > 0) {
                entryName = entryName.substring(0, pos);
                isDir = true;
            } else {
                isDir = entry.isDirectory();
                if (!isDir) {
                    isDir = QClassPathEngine.checkIsDirectory(this.m_myJarFile, entry);
                }
            }
            if (!filters.isSet(new QDir.Filter[]{QDir.Filter.Readable}) || !filters.isSet(new QDir.Filter[]{QDir.Filter.Dirs}) && isDir || !filters.isSet(new QDir.Filter[]{QDir.Filter.Files}) && !isDir || filterNames.size() > 0 && (!isDir || !filters.isSet(new QDir.Filter[]{QDir.Filter.AllDirs})) && !QDir.match(filterNames, entryName)) continue;
            if (entryName.endsWith("/") && entryName.length() > 1) {
                entryName = entryName.substring(0, entryName.length() - 1);
            }
            if (used.contains(entryName = entryName.substring(mentryName.length()))) continue;
            used.add(entryName);
            result.add(entryName);
        }
        return result;
    }

    @Override
    public QAbstractFileEngine.FileFlags fileFlags(QAbstractFileEngine.FileFlags type) {
        try {
            int flags = 0;
            QFileInfo info = new QFileInfo(this.m_myJarFile.getName());
            if (info.exists()) {
                flags |= info.permissions().value() & (QAbstractFileEngine.FileFlag.ReadOwnerPerm.value() | QAbstractFileEngine.FileFlag.ReadGroupPerm.value() | QAbstractFileEngine.FileFlag.ReadOtherPerm.value() | QAbstractFileEngine.FileFlag.ReadUserPerm.value());
            }
            flags = this.m_directory ? (flags |= QAbstractFileEngine.FileFlag.DirectoryType.value()) : (flags |= QAbstractFileEngine.FileFlag.FileType.value());
            return new QAbstractFileEngine.FileFlags((flags | QAbstractFileEngine.FileFlag.ExistsFlag.value()) & type.value());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String fileName(QAbstractFileEngine.FileName file) {
        String s;
        String entryFileName = this.m_entryFileName;
        if (file == QAbstractFileEngine.FileName.LinkName) {
            s = "";
        } else if (file == QAbstractFileEngine.FileName.DefaultName || file == QAbstractFileEngine.FileName.AbsoluteName || file == QAbstractFileEngine.FileName.CanonicalName) {
            s = "classpath:" + this.m_myJarFile.getName() + "#" + entryFileName;
        } else if (file == QAbstractFileEngine.FileName.BaseName) {
            int pos = this.m_entryFileName.lastIndexOf("/");
            s = pos >= 0 ? this.m_entryFileName.substring(pos + 1) : entryFileName;
        } else if (file == QAbstractFileEngine.FileName.PathName) {
            int pos = this.m_entryFileName.lastIndexOf("/");
            s = pos > 0 ? this.m_entryFileName.substring(0, pos) : "";
        } else if (file == QAbstractFileEngine.FileName.CanonicalPathName || file == QAbstractFileEngine.FileName.AbsolutePathName) {
            s = "classpath:" + this.m_myJarFile.getName() + "#" + this.fileName(QAbstractFileEngine.FileName.PathName);
        } else {
            throw new IllegalArgumentException("Unknown file name type: " + file);
        }
        return s;
    }

    @Override
    public QDateTime fileTime(QAbstractFileEngine.FileTime time) {
        if (this.m_entry == null) {
            QFileInfo info = new QFileInfo(this.m_myJarFile.getName());
            if (info.exists()) {
                return info.lastModified();
            }
            return new QDateTime();
        }
        long tm = this.m_entry.getTime();
        if (tm == -1L) {
            return new QDateTime();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(tm));
        return new QDateTime(new QDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5)), new QTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)));
    }

    @Override
    public boolean link(String newName) {
        return false;
    }

    @Override
    public boolean mkdir(String dirName, boolean createParentDirectories) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open(QIODevice.OpenMode openMode) {
        boolean bf = false;
        this.closeInternal();
        if (this.m_entry != null && !openMode.isSet(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly}) && !openMode.isSet(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.Append})) {
            int oldRefCount = -1;
            try {
                oldRefCount = this.m_myJarFile.getOrReopen();
                this.m_stream = this.m_myJarFile.getInputStream(this.m_entry);
                if (this.m_stream != null) {
                    this.m_pos = 0L;
                    this.m_openMode = openMode.value();
                    this.m_closed = false;
                    bf = true;
                }
            }
            catch (IOException eat) {
            }
            finally {
                if (!bf && oldRefCount >= 0) {
                    if (oldRefCount == 0) {
                        this.m_myJarFile.put();
                    }
                    this.m_myJarFile.put();
                }
            }
        }
        return bf;
    }

    @Override
    public long pos() {
        return this.m_pos;
    }

    @Override
    public long read(QNativePointer data, long maxlen) {
        if (this.m_stream == null) {
            return -1L;
        }
        if (maxlen > Integer.MAX_VALUE) {
            maxlen = Integer.MAX_VALUE;
        }
        byte[] b = new byte[(int)maxlen];
        int bytes_read = 0;
        try {
            int read = -1;
            while (this.m_stream.available() > 0 && (long)bytes_read < maxlen) {
                read = this.m_stream.read(b, 0, (int)maxlen - bytes_read);
                if (read > 0) {
                    for (int i = 0; i < read; ++i) {
                        data.setByteAt(i + bytes_read, b[i]);
                    }
                    bytes_read += read;
                    continue;
                }
                if (read != -1) continue;
            }
            if (read < 0 && bytes_read == 0) {
                this.m_eof = true;
                return -1L;
            }
        }
        catch (IOException e) {
            return -1L;
        }
        this.m_pos += (long)bytes_read;
        return bytes_read;
    }

    @Override
    public long readLine(QNativePointer data, long maxlen) {
        if (this.m_stream == null) {
            return -1L;
        }
        int bytes_read = 0;
        try {
            int read = -1;
            while (this.m_stream.available() > 0 && (long)bytes_read < maxlen && (read = this.m_stream.read()) != -1) {
                data.setByteAt(bytes_read++, (byte)read);
                if (read != 10) continue;
            }
            if (read < 0 && bytes_read == 0) {
                this.m_eof = true;
                return -1L;
            }
        }
        catch (IOException e) {
            return -1L;
        }
        this.m_pos += (long)bytes_read;
        return bytes_read;
    }

    @Override
    public boolean remove() {
        return false;
    }

    @Override
    public boolean rename(String newName) {
        return false;
    }

    @Override
    public boolean rmdir(String dirName, boolean recursive) {
        return false;
    }

    @Override
    public boolean seek(long offset) {
        if (offset < 0L) {
            return false;
        }
        try {
            if (!this.open(new QIODevice.OpenMode(this.m_openMode))) {
                return false;
            }
            if (offset < this.m_pos) {
                if (!this.reset()) {
                    // empty if block
                }
                return false;
            }
            while (this.m_pos < offset) {
                long skipBytesRemaining = Math.min(offset - this.m_pos, Integer.MAX_VALUE);
                long skipBytesActual = this.m_stream.skip(skipBytesRemaining);
                if (skipBytesActual < 0L) {
                    throw new IOException("InputStream#skip() = " + skipBytesActual);
                }
                this.m_pos += skipBytesActual;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public String owner(QAbstractFileEngine.FileOwner owner) {
        return "";
    }

    @Override
    public int ownerId(QAbstractFileEngine.FileOwner owner) {
        return -2;
    }

    @Override
    public boolean isRelativePath() {
        return false;
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    @Override
    public boolean setSize(long sz) {
        return false;
    }

    @Override
    public long size() {
        long size = this.m_entry == null ? 0L : this.m_entry.getSize();
        return size;
    }

    @Override
    public long write(QNativePointer data, long len) {
        return -1L;
    }
}

