/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

import com.trolltech.qt.QBlockedSlotException;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtBlockedSlot;
import com.trolltech.qt.QtJambiGeneratedClass;
import com.trolltech.qt.core.QCoreApplication;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.internal.MetaObjectTools;
import com.trolltech.qt.internal.QtJambiInternal;
import com.trolltech.qt.internal.QtJambiObject;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public abstract class QSignalEmitterInternal {
    protected static final ThreadLocal<QSignalEmitterInternal> currentSender = new ThreadLocal();

    protected boolean __qt_signalInitialization(String name) {
        return false;
    }

    public abstract boolean signalsBlocked();

    public abstract Thread thread();

    static void currentSenderRemove() {
        currentSender.remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractSignalInternal {
        private boolean inCppEmission = false;
        private List<Connection> connections = null;
        private Class<?>[] types = null;
        private int[] arrayDimensions = null;
        private String name = "";
        private Class<?> declaringClass = null;
        private boolean connectedToCpp = false;
        private boolean inDisconnect = false;
        private boolean inJavaEmission = false;
        private String signalParameters = null;
        private String cppSignalSignature = null;

        public final QSignalEmitterInternal containingObject() {
            return QSignalEmitterInternal.this;
        }

        public final String name() {
            this.resolveSignal();
            return this.name;
        }

        public final String declaringClassName() {
            this.resolveSignal();
            return this.declaringClass == null ? "" : this.declaringClass.getName();
        }

        public final String fullName() {
            return this.declaringClassName() + "." + this.name();
        }

        private boolean isGenerated() {
            this.resolveSignal();
            return this.declaringClass == null ? false : this.declaringClass.isAnnotationPresent(QtJambiGeneratedClass.class);
        }

        private boolean slotIsCppEmit(Connection connection) {
            return connection.slot.getName().equals(this.name()) && connection.resolveReceiver() == QSignalEmitterInternal.this && connection.slot.getDeclaringClass().equals(this.declaringClass);
        }

        protected void connectSignalMethod(Method slotMethod, Object receiver, int connectionType) {
            if (slotMethod.getAnnotation(QtBlockedSlot.class) != null) {
                throw new QBlockedSlotException(slotMethod.toString());
            }
            if (!this.matchSlot(slotMethod)) {
                throw new RuntimeException("Signature of signal '" + this.fullName() + "' does not match slot '" + slotMethod.toString() + "'");
            }
            this.addConnection(receiver, slotMethod, connectionType);
        }

        int[] arrayDimensions() {
            this.resolveSignal();
            return this.arrayDimensions;
        }

        Class<?>[] resolveSignal() {
            if (this.types == null) {
                boolean found = false;
                this.types = new Class[0];
                this.arrayDimensions = new int[0];
                block0: for (Class<?> cls = QSignalEmitterInternal.this.getClass(); cls != null; cls = cls.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = cls.getDeclaredFields()) {
                        AbstractSignalInternal sig;
                        if (!AbstractSignalInternal.class.isAssignableFrom(field.getType()) || (sig = QtJambiInternal.fetchSignal(QSignalEmitterInternal.this, field)) != this) continue;
                        found = true;
                        this.declaringClass = field.getDeclaringClass();
                        QtJambiInternal.ResolvedSignal resolvedSignal = QtJambiInternal.resolveSignal(field, this.declaringClass);
                        this.name = resolvedSignal.name;
                        this.types = resolvedSignal.types;
                        this.arrayDimensions = resolvedSignal.arrayDimensions;
                        continue block0;
                    }
                }
                if (!found) {
                    throw new RuntimeException("Signals must be declared as members of QSignalEmitter subclasses");
                }
            }
            if (this.types.length == 0 && !(this instanceof QSignalEmitter.Signal0) && !(this instanceof QSignalEmitter.PrivateSignal0)) {
                throw new RuntimeException("Signal initialization failed");
            }
            return this.types;
        }

        private String signalParameters() {
            if (this.signalParameters == null) {
                this.signalParameters = QtJambiInternal.signalParameters(this);
            }
            return this.signalParameters;
        }

        private String cppSignalSignature() {
            if (this.cppSignalSignature == null) {
                this.cppSignalSignature = MetaObjectTools.cppSignalSignature(this);
            }
            return this.cppSignalSignature;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final synchronized void emit_helper(Object ... args) {
            List<Connection> cons;
            if (QSignalEmitterInternal.this instanceof QObject && ((QObject)QSignalEmitterInternal.this).nativeId() == 0L) {
                return;
            }
            if (!this.isGenerated() && QSignalEmitterInternal.this instanceof QObject) {
                MetaObjectTools.emitNativeSignal((QObject)QSignalEmitterInternal.this, this.name() + "(" + this.signalParameters() + ")", this.cppSignalSignature(), args);
            }
            if ((cons = this.connections) == null) {
                return;
            }
            this.inJavaEmission = true;
            try {
                ArrayList<Connection> toRemove = null;
                for (Connection c : cons) {
                    boolean senderWithAffinity;
                    Object receiver = c.resolveReceiver();
                    if (receiver == null || receiver instanceof QtJambiObject && ((QtJambiObject)receiver).nativeId() == 0L) {
                        if (toRemove == null) {
                            toRemove = new ArrayList<Connection>();
                        }
                        toRemove.add(c);
                        continue;
                    }
                    if (this.inCppEmission && this.slotIsCppEmit(c)) continue;
                    if (args.length == c.convertTypes.length) {
                        c.args = args;
                    } else {
                        if (c.args == null) {
                            c.args = new Object[c.convertTypes.length];
                        }
                        System.arraycopy(args, 0, c.args, 0, c.args.length);
                    }
                    boolean notEmitterFlag = !(receiver instanceof QSignalEmitter);
                    boolean receiverWithAffinity = receiver instanceof QSignalEmitter && ((QSignalEmitter)receiver).thread() == Thread.currentThread() && ((QSignalEmitter)receiver).thread() == QSignalEmitterInternal.this.thread();
                    boolean bl = senderWithAffinity = QSignalEmitterInternal.this.thread() == Thread.currentThread() && QSignalEmitterInternal.this.thread() == QSignalEmitterInternal.this.thread();
                    if (senderWithAffinity && (c.isDirectConnection() && receiverWithAffinity || c.isAutoConnection() && notEmitterFlag || c.isAutoConnection() && receiverWithAffinity)) {
                        if (QSignalEmitterInternal.this.signalsBlocked()) continue;
                        QSignalEmitterInternal oldEmitter = currentSender.get();
                        currentSender.set(QSignalEmitterInternal.this);
                        try {
                            boolean updateSender = receiver instanceof QObject && QSignalEmitterInternal.this instanceof QObject;
                            long oldSender = 0L;
                            if (updateSender) {
                                oldSender = QtJambiInternal.setQObjectSender(((QObject)receiver).nativeId(), ((QObject)QSignalEmitterInternal.this).nativeId());
                            }
                            try {
                                c.slot.invoke(receiver, c.args);
                            }
                            catch (IllegalAccessException e) {
                                QtJambiInternal.invokeSlot(receiver, c.slotId, c.returnType, c.args, c.convertTypes);
                            }
                            if (!updateSender) continue;
                            QtJambiInternal.resetQObjectSender(((QObject)receiver).nativeId(), oldSender);
                            continue;
                        }
                        catch (InvocationTargetException e) {
                            System.err.println("Exception caught after invoking slot");
                            e.getCause().printStackTrace();
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println("Exception caught after invoking slot:");
                            e.printStackTrace();
                            continue;
                        }
                        finally {
                            currentSender.set(oldEmitter);
                            continue;
                        }
                    }
                    if (c.isDirectConnection()) {
                        System.err.println("emit() discarded due to thread-affinity mismatch sender=" + QSignalEmitterInternal.this + "; receiver=" + receiver + "; type=DirectConnection; senderWithAffinity=" + senderWithAffinity + "; receiverWithAffinity=" + receiverWithAffinity);
                        continue;
                    }
                    QObject sender = null;
                    if (receiver instanceof QObject && QSignalEmitterInternal.this instanceof QObject) {
                        sender = (QObject)QSignalEmitterInternal.this;
                    }
                    QtJambiInternal.QMetaCallEvent event = new QtJambiInternal.QMetaCallEvent(c, sender, c.args);
                    QObject eventReceiver = null;
                    eventReceiver = receiver instanceof QObject ? (QObject)receiver : QCoreApplication.instance();
                    QCoreApplication.postEvent(eventReceiver, event);
                }
                this.removeConnection_helper(toRemove);
            }
            finally {
                this.inJavaEmission = false;
            }
        }

        private boolean matchSlot(Method slot) {
            Class<?>[] slotArguments = slot.getParameterTypes();
            Class<?>[] signalArguments = this.resolveSignal();
            int[] signalArrayDims = this.arrayDimensions();
            if (slotArguments.length > signalArguments.length) {
                return false;
            }
            for (int i = 0; i < slotArguments.length; ++i) {
                if (this.matchTwoTypes(slotArguments[i], signalArguments[i], signalArrayDims[i])) continue;
                return false;
            }
            return true;
        }

        private boolean matchTwoTypes(Class<?> slotArgument, Class<?> signalArgument, int signalArrayDims) {
            return this.matchTwoTypes(slotArgument, signalArgument, signalArrayDims, false);
        }

        private boolean matchTwoTypes(Class<?> slotArgument, Class<?> signalArgument, int signalArrayDims, boolean wasArray) {
            if (slotArgument.isArray() || signalArrayDims < 0) {
                int slotArrayDims = 0;
                while (slotArgument.isArray()) {
                    slotArgument = slotArgument.getComponentType();
                    ++slotArrayDims;
                }
                return slotArrayDims == signalArrayDims && this.matchTwoTypes(slotArgument, signalArgument, 0, true);
            }
            if (slotArgument.isPrimitive() && !wasArray) {
                return this.matchTwoTypes(QtJambiInternal.getComplexType(slotArgument), signalArgument, signalArrayDims);
            }
            return slotArgument.isAssignableFrom(signalArgument);
        }

        private synchronized void addConnection(Object receiver, Method slot, int connectionType) {
            Class<?> returnType;
            if (!this.connectedToCpp) {
                this.connectedToCpp = true;
                QSignalEmitterInternal.this.__qt_signalInitialization(this.name());
            }
            byte returnSig = !(returnType = slot.getReturnType()).isPrimitive() ? (byte)76 : (byte)QtJambiInternal.primitiveToByte(returnType);
            try {
                slot.setAccessible(true);
            }
            catch (SecurityException e) {
                // empty catch block
            }
            List<Connection> newList = this.cloneConnectionsForceInstance();
            newList.add(new Connection(receiver, slot, returnSig, (byte)connectionType));
            this.connections = newList;
        }

        private List<Connection> cloneConnectionsForceInstance() {
            ArrayList<Connection> newList = new ArrayList<Connection>();
            if (this.connections != null) {
                newList.addAll(this.connections);
            }
            return newList;
        }

        private List<Connection> cloneConnections() {
            if (this.connections == null) {
                return null;
            }
            ArrayList<Connection> newList = new ArrayList<Connection>();
            newList.addAll(this.connections);
            return newList;
        }

        protected synchronized boolean removeConnection(Object receiver, Method slot) {
            if (this.inDisconnect) {
                return false;
            }
            this.inDisconnect = true;
            if (!this.connectedToCpp) {
                this.connectedToCpp = true;
                QSignalEmitterInternal.this.__qt_signalInitialization(this.name());
            }
            boolean returned = false;
            if (this.connections != null) {
                ArrayList<Connection> toRemove = null;
                for (Connection c : this.connections) {
                    Object resolvedReceiver = c.resolveReceiver();
                    if (resolvedReceiver == null) {
                        if (toRemove == null) {
                            toRemove = new ArrayList<Connection>();
                        }
                        toRemove.add(c);
                        continue;
                    }
                    if (receiver != null && resolvedReceiver != receiver || slot != null && !slot.equals(c.slot)) continue;
                    if (toRemove == null) {
                        toRemove = new ArrayList();
                    }
                    toRemove.add(c);
                    returned = true;
                }
                this.removeConnection_helper(toRemove);
            }
            if (QSignalEmitterInternal.this instanceof QObject && (receiver instanceof QObject || receiver == null)) {
                String methodSignature = null;
                if (slot != null) {
                    methodSignature = slot.toString();
                    int paren_pos = methodSignature.indexOf(40);
                    methodSignature = methodSignature.substring(methodSignature.lastIndexOf(32, paren_pos) + 1);
                }
                returned |= QtJambiInternal.cppDisconnect((QObject)QSignalEmitterInternal.this, this.fullName(), (QObject)receiver, methodSignature);
                if (receiver == null && slot == null) {
                    this.connectedToCpp = false;
                }
            }
            this.inDisconnect = false;
            return returned;
        }

        private void removeConnection_helper(List<Connection> toRemove) {
            if (toRemove != null) {
                List<Connection> newList = this.cloneConnections();
                for (Connection c : toRemove) {
                    newList.remove(c);
                }
                this.connections = newList;
            }
        }

        protected class Connection {
            private WeakReference<Object> weakReceiver = null;
            private Object receiver = null;
            public int flags = 0;
            public Method slot = null;
            public byte returnType = 0;
            public int[] convertTypes = null;
            public long slotId = 0L;
            public Object[] args = null;
            public static final int DIRECT_CONNECTION = 1;
            public static final int QUEUED_CONNECTION = 2;
            public static final int PUBLIC_SLOT = 16;
            public static final int HARD_REFERENCE_CONNECTION = 64;
            public static final int CONNECTION_TYPE_MASK = 135;

            public final boolean isSlotPublic() {
                return (this.flags & 0x10) != 0;
            }

            public final boolean isQueuedConnection() {
                return (this.flags & 2) != 0;
            }

            public final boolean isDirectConnection() {
                return (this.flags & 1) != 0;
            }

            public final boolean isAutoConnection() {
                return (this.flags & 3) == 0;
            }

            public final boolean isHardReferenceConnection() {
                return (this.flags & 0x40) != 0;
            }

            public final Object resolveReceiver() {
                if (this.weakReceiver != null) {
                    return this.weakReceiver.get();
                }
                return this.receiver;
            }

            public Connection(Object receiver, Method slot, byte returnType, byte connectionType) {
                if ((connectionType & 0x40) != 0) {
                    this.receiver = receiver;
                    this.flags |= 0x40;
                } else {
                    this.weakReceiver = new WeakReference<Object>(receiver);
                }
                this.slot = slot;
                this.slotId = QtJambiInternal.resolveSlot(slot);
                this.returnType = returnType;
                if ((connectionType & 0x87) == Qt.ConnectionType.QueuedConnection.value()) {
                    this.flags |= 2;
                } else if ((connectionType & 0x87) == Qt.ConnectionType.DirectConnection.value()) {
                    this.flags |= 1;
                }
                if (Modifier.isPublic(slot.getModifiers()) && Modifier.isPublic(receiver.getClass().getModifiers())) {
                    this.flags |= 0x10;
                }
                Class<?>[] slotParameterTypes = slot.getParameterTypes();
                Class<?>[] signalParameterTypes = AbstractSignalInternal.this.resolveSignal();
                this.convertTypes = QtJambiInternal.resolveConversionSchema(signalParameterTypes, slotParameterTypes);
            }
        }
    }
}

