/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.designer;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.designer.AbstractPropertyHandler;
import com.trolltech.qt.designer.QUiLoaderException;
import com.trolltech.qt.xml.QDomElement;
import java.util.HashMap;

class EnumPropertyHandler
extends AbstractPropertyHandler {
    private static HashMap<String, Object> hardcodedValues = new HashMap();

    EnumPropertyHandler() {
    }

    public Object create(QDomElement e) throws QUiLoaderException {
        String name = this.childStringValue(e);
        return EnumPropertyHandler.enumForValue(name);
    }

    static Object enumForValue(String name) throws QUiLoaderException {
        Object hcValue = hardcodedValues.get(name);
        if (hcValue != null) {
            return hcValue;
        }
        int valuePos = name.lastIndexOf(46);
        int enumPos = name.lastIndexOf(46, valuePos - 1);
        if (enumPos > 0 && valuePos > 0) {
            String className = name.substring(0, enumPos);
            String enumName = name.substring(enumPos + 1, valuePos);
            String enumValue = name.substring(valuePos + 1);
            try {
                Class<?> cl = Class.forName(className + '$' + enumName);
                return Enum.valueOf(cl, enumValue);
            }
            catch (Exception ex) {
                throw new QUiLoaderException("Converting enum '" + name + "' failed...", ex);
            }
        }
        throw new QUiLoaderException("Converting enum '" + name + "' failed", null);
    }

    static {
        hardcodedValues.put("TopToolBarArea", Qt.ToolBarArea.TopToolBarArea.value());
        hardcodedValues.put("BottomToolBarArea", Qt.ToolBarArea.BottomToolBarArea.value());
        hardcodedValues.put("RightToolBarArea", Qt.ToolBarArea.RightToolBarArea.value());
        hardcodedValues.put("LeftToolBarArea", Qt.ToolBarArea.LeftToolBarArea.value());
    }
}

