/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.jack.sequencer.JackEvent;
import org.herac.tuxguitar.jack.sequencer.JackSequencer;
import org.herac.tuxguitar.player.base.MidiPlayerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JackEventController {
    private JackSequencer sequencer;
    private List<JackEvent> events;
    private double tick;
    private double lastTick;
    private boolean reset;

    public JackEventController(JackSequencer sequencer) {
        this.sequencer = sequencer;
        this.events = new ArrayList<JackEvent>();
        this.reset();
    }

    public void process() throws MidiPlayerException {
        this.lastTick = this.tick;
        this.tick = this.sequencer.getJackTickController().getTick();
        for (int i = 0; i < this.events.size(); ++i) {
            JackEvent event = this.events.get(i);
            if (!this.shouldSend(event, this.tick, this.lastTick)) continue;
            this.sequencer.sendEvent(event);
        }
        this.reset = false;
    }

    private boolean shouldSend(JackEvent event, double tick, double lastTick) {
        if ((double)event.getTick() > tick) {
            return false;
        }
        if (event.getTrack() != -1) {
            if (this.sequencer.getJackTrackController().isMute(event.getTrack())) {
                return false;
            }
            if (this.sequencer.getJackTrackController().isAnySolo() && !this.sequencer.getJackTrackController().isSolo(event.getTrack())) {
                return false;
            }
        }
        if (this.reset) {
            if (event.getType() == 1) {
                return true;
            }
            if (event.getType() == 5) {
                return true;
            }
            if (event.getType() == 4) {
                return true;
            }
        }
        return (double)event.getTick() > lastTick;
    }

    public List<JackEvent> getEvents() {
        return this.events;
    }

    public void addEvent(JackEvent event) {
        this.events.add(event);
    }

    public void clearEvents() {
        this.events.clear();
    }

    public void reset() {
        this.tick = this.sequencer.getTickPosition() - 120L;
        this.reset = true;
    }

    public List<long[]> getTempoChanges() {
        ArrayList<long[]> tempoChanges = new ArrayList<long[]>();
        for (int i = 0; i < this.events.size(); ++i) {
            JackEvent event = this.events.get(i);
            if (event.getType() != 1 || event.getData()[0] != 81) continue;
            int usq = event.getData()[1] & 0xFF | (event.getData()[2] & 0xFF) << 8 | (event.getData()[3] & 0xFF) << 16;
            long[] tempoChange = new long[]{event.getTick(), (long)(60000.0 / ((double)usq / 1000.0))};
            tempoChanges.add(tempoChange);
        }
        return tempoChanges;
    }
}

