/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.ConnectionException;
import com.trolltech.qt.qtjambi.util.RetroTranslatorHelper;
import java.lang.reflect.Method;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNoSuchSlotException
extends ConnectionException {
    private static final long serialVersionUID = 1L;
    private Object reciver;
    private String slotSignature;
    private String message;

    public QNoSuchSlotException(String message) {
        this.message = message != null ? message : "";
    }

    public QNoSuchSlotException(Object reciver, String slotSignature) {
        this.reciver = reciver;
        this.slotSignature = slotSignature;
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        if (this.slotSignature.equals("")) {
            return "Slot can't be an empty string";
        }
        String res = "\n\nCould not find slot with signature: " + this.slotSignature + "\n";
        Vector<Method> possibleMethods = QNoSuchSlotException.findPossibleFunctionRecursive(this.reciver, this.slotSignature);
        if (!possibleMethods.isEmpty()) {
            res = res + "Possible matching methods:\n";
            for (Method method : possibleMethods) {
                res = res + "   " + this.methodToString(method) + "\n";
            }
        }
        return res;
    }

    private String methodToString(Method method) {
        Class<?>[] a = method.getParameterTypes();
        String args = "";
        for (int i = 0; i < a.length; ++i) {
            Class<?> t = a[i];
            String brackets = "";
            if (t.isArray()) {
                do {
                    t = t.getComponentType();
                    brackets = brackets + "[]";
                } while (t.isArray());
            }
            args = args + (i > 0 ? ", " : "") + t.getName() + brackets;
        }
        return method.getDeclaringClass().getName() + "." + method.getName() + "(" + args + ")";
    }

    private static Vector<Method> findPossibleFunctionRecursive(Object reciver, String signature) {
        Class<?> cls = reciver.getClass();
        int pos = signature.indexOf(40);
        String name = signature.substring(0, pos).trim();
        int pos2 = signature.indexOf(41, pos);
        String strTypes = signature.substring(pos + 1, pos2).trim();
        String[] argumentTypes = strTypes.length() == 0 ? new String[]{} : RetroTranslatorHelper.split(strTypes, ",");
        for (int i = 0; i < argumentTypes.length; ++i) {
            argumentTypes[i] = argumentTypes[i].replace(" ", "");
        }
        return QNoSuchSlotException.findPossibleFunctionRecursiveHelper(cls, name, argumentTypes, new Vector<Method>());
    }

    private static Vector<Method> findPossibleFunctionRecursiveHelper(Class<?> cls, String functionName, String[] argumentTypes, Vector<Method> res) {
        Method[] methods;
        for (Method m : methods = cls.getDeclaredMethods()) {
            Class<?>[] a;
            if (!m.getName().equalsIgnoreCase(functionName) || (a = m.getParameterTypes()).length != argumentTypes.length) continue;
            res.add(m);
        }
        if ((cls = cls.getSuperclass()) == null) {
            return res;
        }
        return QNoSuchSlotException.findPossibleFunctionRecursiveHelper(cls, functionName, argumentTypes, res);
    }
}

