/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.widget;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QHeaderView;
import com.trolltech.qt.gui.QTableWidget;
import com.trolltech.qt.gui.QTableWidgetItem;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.ui.event.UICheckTableSelectionListener;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.qt.event.QTCheckTableSelectionListenerManager;
import org.herac.tuxguitar.ui.qt.event.QTSelectionListenerManager;
import org.herac.tuxguitar.ui.qt.event.QTTableDoubleClickListenerManager;
import org.herac.tuxguitar.ui.qt.resource.QTImage;
import org.herac.tuxguitar.ui.qt.widget.QTContainer;
import org.herac.tuxguitar.ui.qt.widget.QTWidget;
import org.herac.tuxguitar.ui.widget.UICheckTable;
import org.herac.tuxguitar.ui.widget.UITableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTTable<T>
extends QTWidget<QTableWidget>
implements UICheckTable<T> {
    private boolean checkable;
    private List<UITableItem<T>> items;
    private List<QTColumnName> columnNames;
    private QTSelectionListenerManager selectionListener;
    private QTCheckTableSelectionListenerManager<T> checkSelectionListener;
    private QTTableDoubleClickListenerManager doubleClickListenerManager;

    public QTTable(QTContainer parent, boolean headerVisible, boolean checkable) {
        super(new QTableWidget(parent.getContainerControl()), parent);
        this.checkable = checkable;
        this.items = new ArrayList<UITableItem<T>>();
        this.columnNames = new ArrayList<QTColumnName>();
        this.selectionListener = new QTSelectionListenerManager(this);
        this.checkSelectionListener = new QTCheckTableSelectionListenerManager(this);
        this.doubleClickListenerManager = new QTTableDoubleClickListenerManager(this);
        ((QTableWidget)this.getControl()).setShowGrid(false);
        ((QTableWidget)this.getControl()).setFocusPolicy(Qt.FocusPolicy.NoFocus);
        ((QTableWidget)this.getControl()).setSelectionMode(QAbstractItemView.SelectionMode.SingleSelection);
        ((QTableWidget)this.getControl()).setSelectionBehavior(QAbstractItemView.SelectionBehavior.SelectRows);
        ((QTableWidget)this.getControl()).horizontalHeader().setVisible(headerVisible);
        ((QTableWidget)this.getControl()).verticalHeader().setVisible(false);
    }

    public void updateColumnNames() {
        int columnCount = this.getColumns();
        while (this.columnNames.size() < columnCount) {
            this.columnNames.add(new QTColumnName());
        }
        while (this.columnNames.size() > columnCount) {
            this.columnNames.remove(this.columnNames.size() - 1);
        }
    }

    public void setColumns(int count) {
        if (count >= 0) {
            ((QTableWidget)this.getControl()).setColumnCount(count);
            this.updateColumnNames();
            for (int i = 0; i < count; ++i) {
                ((QTableWidget)this.getControl()).horizontalHeader().setResizeMode(i, i == count - 1 ? QHeaderView.ResizeMode.Stretch : QHeaderView.ResizeMode.Interactive);
            }
        }
    }

    public int getColumns() {
        return ((QTableWidget)this.getControl()).columnCount();
    }

    public void setColumnName(int column, String name) {
        if (column >= 0 && column < this.columnNames.size()) {
            this.columnNames.get(column).setValue(name);
            ArrayList<String> labels = new ArrayList<String>();
            for (QTColumnName columnName : this.columnNames) {
                labels.add(columnName.getValue());
            }
            ((QTableWidget)this.getControl()).setHorizontalHeaderLabels(labels);
        }
    }

    public String getColumnName(int column) {
        this.updateColumnNames();
        if (column >= 0 && column < this.columnNames.size()) {
            return this.columnNames.get(column).getValue();
        }
        return null;
    }

    public T getSelectedValue() {
        UITableItem<T> selectedItem = this.getSelectedItem();
        return (T)(selectedItem != null ? selectedItem.getValue() : null);
    }

    public void setSelectedValue(T value) {
        this.setSelectedItem(new UITableItem(value));
    }

    public UITableItem<T> getSelectedItem() {
        List selectedItems = ((QTableWidget)this.getControl()).selectedItems();
        if (selectedItems != null) {
            for (QTableWidgetItem selectedItem : selectedItems) {
                int row = selectedItem.row();
                if (row < 0 || row >= this.items.size()) continue;
                return this.items.get(row);
            }
        }
        return null;
    }

    public void setSelectedItem(UITableItem<T> item) {
        if (this.items.contains(item)) {
            ((QTableWidget)this.getControl()).selectRow(this.items.indexOf(item));
        } else {
            ((QTableWidget)this.getControl()).clearSelection();
        }
    }

    public void addItem(UITableItem<T> item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
            ((QTableWidget)this.getControl()).setRowCount(this.items.size());
            int row = this.items.indexOf(item);
            int columns = this.getColumns();
            for (int column = 0; column < columns; ++column) {
                QTableWidgetItem qTableWidgetItem = new QTableWidgetItem();
                qTableWidgetItem.setFlags(new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsEnabled, Qt.ItemFlag.ItemIsSelectable, Qt.ItemFlag.ItemIsUserCheckable});
                String text = item.getText(column);
                if (text != null) {
                    qTableWidgetItem.setText(text);
                }
                if (item.getImage() != null && !item.getImage().isDisposed()) {
                    qTableWidgetItem.setIcon(((QTImage)item.getImage()).createIcon());
                }
                if (this.checkable && column == 0) {
                    qTableWidgetItem.setCheckState(Qt.CheckState.Unchecked);
                }
                ((QTableWidget)this.getControl()).setItem(row, column, qTableWidgetItem);
            }
        }
    }

    public void removeItem(UITableItem<T> item) {
        int row = this.items.indexOf(item);
        if (row >= 0) {
            this.items.remove(row);
            ((QTableWidget)this.getControl()).removeRow(row);
            ((QTableWidget)this.getControl()).setRowCount(this.items.size());
        }
    }

    public void removeItems() {
        this.items.clear();
        ((QTableWidget)this.getControl()).clearContents();
        ((QTableWidget)this.getControl()).setRowCount(this.items.size());
    }

    public UITableItem<T> getItem(int index) {
        if (index >= 0 && index < this.getItemCount()) {
            return this.items.get(index);
        }
        return null;
    }

    public T getItemValue(int index) {
        UITableItem<T> item = this.getItem(index);
        if (item != null) {
            return (T)item.getValue();
        }
        return null;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public boolean isCheckedValue(T value) {
        return this.isCheckedItem(new UITableItem(value));
    }

    public boolean isCheckedItem(UITableItem<T> item) {
        int row = this.items.indexOf(item);
        if (row >= 0) {
            QTableWidgetItem qTableWidgetItem = ((QTableWidget)this.getControl()).item(row, 0);
            return Qt.CheckState.Checked.equals((Object)qTableWidgetItem.checkState());
        }
        return false;
    }

    public void setCheckedValue(T value, boolean checked) {
        this.setCheckedItem(new UITableItem(value), checked);
    }

    public void setCheckedItem(UITableItem<T> item, boolean checked) {
        int row = this.items.indexOf(item);
        if (row >= 0) {
            QTableWidgetItem qTableWidgetItem = ((QTableWidget)this.getControl()).item(row, 0);
            qTableWidgetItem.setCheckState(checked ? Qt.CheckState.Checked : Qt.CheckState.Unchecked);
        }
    }

    public void addSelectionListener(UISelectionListener listener) {
        if (this.selectionListener.isEmpty()) {
            ((QTableWidget)this.getControl()).itemSelectionChanged.connect((Object)this.selectionListener, "handle()");
        }
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
        if (this.selectionListener.isEmpty()) {
            ((QTableWidget)this.getControl()).itemSelectionChanged.disconnect();
        }
    }

    public void addCheckSelectionListener(UICheckTableSelectionListener<T> listener) {
        if (this.checkSelectionListener.isEmpty()) {
            ((QTableWidget)this.getControl()).cellChanged.connect(this.checkSelectionListener, "handle(Integer,Integer)");
        }
        this.checkSelectionListener.addListener(listener);
    }

    public void removeCheckSelectionListener(UICheckTableSelectionListener<T> listener) {
        this.checkSelectionListener.removeListener(listener);
        if (this.checkSelectionListener.isEmpty()) {
            ((QTableWidget)this.getControl()).cellChanged.disconnect();
        }
    }

    @Override
    public void addMouseDoubleClickListener(UIMouseDoubleClickListener listener) {
        if (this.doubleClickListenerManager.isEmpty()) {
            ((QTableWidget)this.getControl()).itemDoubleClicked.connect((Object)this.doubleClickListenerManager, "handle(com.trolltech.qt.gui.QTableWidgetItem)");
        }
        this.doubleClickListenerManager.addListener(listener);
    }

    @Override
    public void removeMouseDoubleClickListener(UIMouseDoubleClickListener listener) {
        this.doubleClickListenerManager.removeListener(listener);
        if (this.doubleClickListenerManager.isEmpty()) {
            ((QTableWidget)this.getControl()).itemDoubleClicked.disconnect();
        }
    }

    private class QTColumnName {
        private String value = new String();

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

