/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.resource;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QCursor;
import java.util.HashMap;
import java.util.Map;
import org.herac.tuxguitar.ui.resource.UICursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTCursor {
    private static final Map<UICursor, QCursor> CURSOR_MAP = QTCursor.createCursorMap();

    private QTCursor() {
    }

    private static Map<UICursor, QCursor> createCursorMap() {
        HashMap<UICursor, QCursor> cursorMap = new HashMap<UICursor, QCursor>();
        cursorMap.put(UICursor.NORMAL, new QCursor(Qt.CursorShape.ArrowCursor));
        cursorMap.put(UICursor.WAIT, new QCursor(Qt.CursorShape.WaitCursor));
        cursorMap.put(UICursor.HAND, new QCursor(Qt.CursorShape.OpenHandCursor));
        cursorMap.put(UICursor.SIZEWE, new QCursor(Qt.CursorShape.SizeHorCursor));
        cursorMap.put(UICursor.SIZENS, new QCursor(Qt.CursorShape.SizeVerCursor));
        return cursorMap;
    }

    public static QCursor getCursor(UICursor cursor) {
        return CURSOR_MAP.get(cursor);
    }
}

