/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt;

import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.gui.QDesktopServices;
import java.net.URL;
import org.herac.tuxguitar.ui.UIApplication;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.qt.QTApplicationHandle;
import org.herac.tuxguitar.ui.qt.QTComponent;
import org.herac.tuxguitar.ui.qt.QTEnvironment;
import org.herac.tuxguitar.ui.qt.QTFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTApplication
extends QTComponent<QTApplicationHandle>
implements UIApplication {
    private Thread uiThread;
    private UIFactory uiFactory;
    private QTEnvironment environment = new QTEnvironment();

    public QTApplication(String name) {
        super(new QTApplicationHandle());
        this.uiFactory = new QTFactory();
        ((QTApplicationHandle)this.getControl()).setApplicationName(name);
    }

    @Override
    public void dispose() {
        ((QTApplicationHandle)this.getControl()).quit();
        super.dispose();
    }

    public UIFactory getFactory() {
        return this.uiFactory;
    }

    public void openUrl(URL url) {
        QDesktopServices.openUrl((QUrl)new QUrl(url.toExternalForm()));
    }

    public void runInUiThread(Runnable runnable) {
        ((QTApplicationHandle)this.getControl()).invokeLater(runnable);
    }

    public boolean isInUiThread() {
        return this.uiThread == Thread.currentThread();
    }

    public void start(Runnable runnable) {
        this.uiThread = Thread.currentThread();
        ((QTApplicationHandle)this.getControl()).initialize();
        String qtStyle = this.environment.findStyle();
        if (qtStyle != null && qtStyle.length() > 0) {
            ((QTApplicationHandle)this.getControl()).setStyle(qtStyle);
        }
        this.runInUiThread(runnable);
        ((QTApplicationHandle)this.getControl()).exec();
    }
}

