/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.printer;

import java.util.Arrays;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.color.TGColorManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIKeyEvent;
import org.herac.tuxguitar.ui.event.UIKeyReleasedListener;
import org.herac.tuxguitar.ui.event.UIPaintEvent;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIKey;
import org.herac.tuxguitar.ui.resource.UIKeyConvination;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIScrollBar;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.ui.widget.UIWindow;

public class TGPrintPreviewDialog {
    private static final int SCROLL_INCREMENT = 50;
    public static final String ATTRIBUTE_PAGES = TGPrintPreviewDialog.class.getName() + "-pages";
    public static final String ATTRIBUTE_SIZE = TGPrintPreviewDialog.class.getName() + "-size";
    public static final UIKeyConvination ENTER_KEY_CONVINATION = new UIKeyConvination(Arrays.asList(UIKey.ENTER));
    private TGViewContext context;
    private UIWindow dialog;
    private UIScrollBarPanel previewComposite;
    private UICanvas pageComposite;
    private UITextField currentText;
    private UIButton previous;
    private UIButton next;
    private UISize size;
    private List<UIImage> pages;
    private int currentPage;

    public TGPrintPreviewDialog(TGViewContext context) {
        this.context = context;
        this.pages = (List)context.getAttribute(ATTRIBUTE_PAGES);
        this.size = (UISize)context.getAttribute(ATTRIBUTE_SIZE);
    }

    public void show() {
        UIFactory uiFactory = TGApplication.getInstance(this.context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)this.context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, true, true);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("print.preview"));
        this.initToolBar();
        this.initPreviewComposite();
        this.changePage(0);
        UIDisposeListener disposeListener = (UIDisposeListener)this.context.getAttribute(TGViewContext.ATTRIBUTE_DISPOSE_LISTENER);
        if (disposeListener != null) {
            this.dialog.addDisposeListener(disposeListener);
        }
        TGDialogUtil.openDialog(this.dialog, 8);
    }

    private void initToolBar() {
        UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout compositeLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel composite = factory.createPanel((UIContainer)this.dialog, false);
        composite.setLayout((UILayout)compositeLayout);
        dialogLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.previous = factory.createButton((UIContainer)composite);
        this.previous.setImage(TuxGuitar.getInstance().getIconManager().getArrowLeft());
        compositeLayout.set((UIControl)this.previous, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.currentText = factory.createTextField((UIContainer)composite);
        compositeLayout.set((UIControl)this.currentText, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        compositeLayout.set((UIControl)this.currentText, "packed_width", (Object)Float.valueOf(25.0f));
        this.next = factory.createButton((UIContainer)composite);
        this.next.setImage(TuxGuitar.getInstance().getIconManager().getArrowRight());
        compositeLayout.set((UIControl)this.next, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UILabel maxPages = factory.createLabel((UIContainer)composite);
        compositeLayout.set((UIControl)maxPages, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UIButton close = factory.createButton((UIContainer)composite);
        compositeLayout.set((UIControl)close, Integer.valueOf(1), Integer.valueOf(5), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        this.currentText.addKeyReleasedListener(new UIKeyReleasedListener(){

            public void onKeyReleased(UIKeyEvent event) {
                if (event.getKeyConvination().equals((Object)ENTER_KEY_CONVINATION)) {
                    try {
                        Integer number = new Integer(TGPrintPreviewDialog.this.currentText.getText());
                        TGPrintPreviewDialog.this.changePage(number - 1);
                    }
                    catch (NumberFormatException exception) {
                        TGPrintPreviewDialog.this.changePage(TGPrintPreviewDialog.this.currentPage);
                    }
                }
            }
        });
        this.previous.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGPrintPreviewDialog.this.currentPage >= 0) {
                    TGPrintPreviewDialog.this.changePage(TGPrintPreviewDialog.this.currentPage - 1);
                }
            }
        });
        this.next.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGPrintPreviewDialog.this.currentPage >= 0) {
                    TGPrintPreviewDialog.this.changePage(TGPrintPreviewDialog.this.currentPage + 1);
                }
            }
        });
        close.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGPrintPreviewDialog.this.dialog.dispose();
            }
        });
        maxPages.setText(TuxGuitar.getProperty("print.preview.page-of") + " " + this.pages.size());
        close.setText(TuxGuitar.getProperty("close"));
    }

    private void initPreviewComposite() {
        UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout previewLayout = new UITableLayout();
        this.previewComposite = factory.createScrollBarPanel((UIContainer)this.dialog, true, false, true);
        this.previewComposite.setLayout((UILayout)previewLayout);
        this.previewComposite.setBgColor(TGColorManager.getInstance(this.context.getContext()).getColor(3));
        this.previewComposite.setFocus();
        dialogLayout.set((UIControl)this.previewComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        dialogLayout.set((UIControl)this.previewComposite, "packed_width", (Object)Float.valueOf(0.0f));
        dialogLayout.set((UIControl)this.previewComposite, "packed_height", (Object)Float.valueOf(0.0f));
        this.pageComposite = factory.createCanvas((UIContainer)this.previewComposite, true);
        this.pageComposite.setBgColor(TGColorManager.getInstance(this.context.getContext()).getColor(1));
        this.pageComposite.addPaintListener(new UIPaintListener(){

            public void onPaint(UIPaintEvent event) {
                if (TGPrintPreviewDialog.this.currentPage >= 0) {
                    TGPrintPreviewDialog.this.updateScroll();
                    int vScroll = TGPrintPreviewDialog.this.previewComposite.getVScroll().getValue();
                    UIImage page = (UIImage)TGPrintPreviewDialog.this.pages.get(TGPrintPreviewDialog.this.currentPage);
                    UIPainter painter = event.getPainter();
                    painter.drawImage(page, 0.0f, (float)(-vScroll));
                }
            }
        });
        previewLayout.set((UIControl)this.pageComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        previewLayout.set((UIControl)this.pageComposite, "packed_width", (Object)Float.valueOf(this.size.getWidth()));
        previewLayout.set((UIControl)this.pageComposite, "packed_height", (Object)Float.valueOf(this.size.getHeight()));
        this.previewComposite.getVScroll().setIncrement(50);
        this.previewComposite.getVScroll().addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGPrintPreviewDialog.this.pageComposite.redraw();
            }
        });
    }

    protected void updateScroll() {
        UIScrollBar vBar = this.previewComposite.getVScroll();
        UIRectangle client = this.previewComposite.getChildArea();
        vBar.setMaximum(Math.max(Math.round(this.size.getHeight() - client.getHeight()), 0));
        vBar.setThumb(Math.round(client.getHeight()));
    }

    protected void changePage(int index) {
        if (!this.pages.isEmpty()) {
            int pageCount = this.pages.size();
            if (index >= 0 && index < pageCount) {
                this.currentPage = index;
                this.currentText.setText(Integer.toString(index + 1));
                this.pageComposite.redraw();
            } else if (this.currentPage >= 0 && this.currentPage < pageCount) {
                this.currentText.setText(Integer.toString(this.currentPage + 1));
            }
            this.previous.setEnabled(this.currentPage > 0);
            this.next.setEnabled(this.currentPage + 1 < pageCount);
            this.previewComposite.getVScroll().setValue(0);
            this.previewComposite.setFocus();
        } else {
            this.currentText.setEnabled(false);
            this.previous.setEnabled(false);
            this.next.setEnabled(false);
        }
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context.getContext()).getFactory();
    }

    public TGViewContext getContext() {
        return this.context;
    }
}

