/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.listener.undoable;

import java.util.HashMap;
import java.util.Map;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.app.action.listener.undoable.TGUndoableJoined;
import org.herac.tuxguitar.editor.undo.TGUndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGUndoableContext {
    private TGUndoableJoined undoable;
    private Map<Object, TGUndoableEdit> undoableEdits = new HashMap<Object, TGUndoableEdit>();
    private Integer level;

    public TGUndoableContext() {
        this.reset();
    }

    public void reset() {
        this.level = 0;
        this.undoable = null;
        this.undoableEdits.clear();
    }

    public void addUndoableToCurrentLevel(TGUndoableEdit undoableEdit) {
        this.undoableEdits.put(this.level, undoableEdit);
    }

    public TGUndoableEdit getUndoableFromCurrentLevel() {
        if (this.undoableEdits.containsKey(this.level)) {
            return this.undoableEdits.get(this.level);
        }
        return null;
    }

    public void incrementLevel() {
        TGUndoableContext tGUndoableContext = this;
        Integer n = tGUndoableContext.level;
        Integer n2 = tGUndoableContext.level = Integer.valueOf(tGUndoableContext.level + 1);
    }

    public void decrementLevel() {
        TGUndoableContext tGUndoableContext = this;
        Integer n = tGUndoableContext.level;
        Integer n2 = tGUndoableContext.level = Integer.valueOf(tGUndoableContext.level - 1);
    }

    public TGUndoableJoined getUndoable() {
        return this.undoable;
    }

    public void setUndoable(TGUndoableJoined undoable) {
        this.undoable = undoable;
    }

    public Map<Object, TGUndoableEdit> getUndoableEdits() {
        return this.undoableEdits;
    }

    public void setUndoableEdits(Map<Object, TGUndoableEdit> undoableEdits) {
        this.undoableEdits = undoableEdits;
    }

    public Integer getLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TGUndoableContext getInstance(TGActionContext actionContext) {
        Class<TGUndoableContext> clazz = TGUndoableContext.class;
        synchronized (TGUndoableContext.class) {
            String key = TGUndoableContext.class.getName();
            if (actionContext.hasAttribute(key)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (TGUndoableContext)actionContext.getAttribute(key);
            }
            actionContext.setAttribute(key, (Object)new TGUndoableContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return TGUndoableContext.getInstance(actionContext);
        }
    }
}

