/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal.fileengine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MyJarFile {
    private URLConnection urlConnection;
    private File fileToJarFile;
    private URL urlToJarFile;
    private JarFile jarFile;
    private int refCount;

    MyJarFile(File fileToJarFile) throws IOException {
        this.fileToJarFile = fileToJarFile;
        this.openInternal();
    }

    MyJarFile(URL urlToJarFile) throws IOException {
        this.urlToJarFile = urlToJarFile;
        this.openInternal();
    }

    private void openInternal() throws IOException {
        if (this.fileToJarFile != null) {
            this.jarFile = new JarFile(this.fileToJarFile);
        } else {
            this.urlConnection = this.urlToJarFile.openConnection();
            if (!(this.urlConnection instanceof JarURLConnection)) {
                IOException thr = new IOException("not a JarURLConnection: " + this.urlConnection.getClass().getName());
                this.urlConnection = null;
                throw thr;
            }
            JarURLConnection jarUrlConnection = (JarURLConnection)this.urlConnection;
            this.jarFile = jarUrlConnection.getJarFile();
        }
        this.refCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void get() {
        MyJarFile myJarFile = this;
        synchronized (myJarFile) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOrReopen() throws IOException {
        int oldRefCount;
        MyJarFile myJarFile = this;
        synchronized (myJarFile) {
            oldRefCount = this.refCount;
            if (this.refCount <= 0) {
                this.reopen();
            }
            this.get();
        }
        return oldRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put() {
        JarFile closeJarFile = null;
        MyJarFile myJarFile = this;
        synchronized (myJarFile) {
            --this.refCount;
            if (this.refCount == 0) {
                closeJarFile = this.jarFile;
                this.jarFile = null;
            }
        }
        if (closeJarFile != null) {
            try {
                closeJarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.urlConnection != null) {
                this.urlConnection = null;
            }
        }
    }

    void reopen() throws IOException {
        if (this.jarFile != null) {
            throw new IOException("jarFile already open");
        }
        this.openInternal();
    }

    String getName() {
        return this.jarFile.getName();
    }

    Enumeration<JarEntry> entries() {
        return this.jarFile.entries();
    }

    JarEntry getJarEntry(String name) {
        return this.jarFile.getJarEntry(name);
    }

    InputStream getInputStream(ZipEntry ze) throws IOException {
        return this.jarFile.getInputStream(ze);
    }
}

