/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

import com.trolltech.qt.Utilities;
import com.trolltech.qt.internal.DeploymentSpec;
import com.trolltech.qt.internal.DeploymentSpecException;
import com.trolltech.qt.internal.LibraryEntry;
import com.trolltech.qt.internal.Reporter;
import com.trolltech.qt.internal.WrongSystemException;
import com.trolltech.qt.osinfo.OSInfo;
import com.trolltech.qt.qtjambi.util.RetroTranslatorHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLibraryManager {
    public static String DEPLOY_DESCRIPTOR_NAME = "qtjambi-deployment.xml";
    private static final String DEBUG_SUFFIX = "_debuglib";
    private static final boolean VERBOSE_LOADING;
    private static final int LOAD_TRUE = 1;
    private static final int LOAD_SYSTEM = 2;
    private static final int LOAD_FALSE = 3;
    private static final int LOAD_NEVER = 4;
    private static DeploymentSpec[] activeDeploymentSpecA;
    private static Map<String, LibraryEntry> libraryMap;
    private static Map<String, LibraryEntry> neverLoad;
    private static List<DeploymentSpec> deploymentSpecs;
    private static Reporter reporter;
    private static boolean unpacked;

    public static String loadToString(int load) {
        switch (load) {
            case 1: {
                return "load-true";
            }
            case 2: {
                return "load-system";
            }
            case 4: {
                return "load-never";
            }
            case 3: {
                return "load-false";
            }
        }
        return null;
    }

    public static File jambiTempDir() {
        if (activeDeploymentSpecA == null) {
            return null;
        }
        return activeDeploymentSpecA[0].buildPath("");
    }

    public static DeploymentSpec[] getActiveDeploymentSpec() {
        return activeDeploymentSpecA;
    }

    public static DeploymentSpec[] resetActiveDeploymentSpec() {
        DeploymentSpec[] rv = activeDeploymentSpecA;
        activeDeploymentSpecA = null;
        return rv;
    }

    private static File jambiTempDirBase(String key) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String user = System.getProperty("user.name");
        String arch = System.getProperty("os.arch");
        return new File(tmpDir, "QtJambi_" + user + "_" + arch + "_" + Utilities.VERSION_STRING + "_" + key);
    }

    public static List<String> pluginPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (DeploymentSpec spec : deploymentSpecs) {
            File root = spec.getBaseDir();
            List<String> pluginPaths = spec.getPluginPaths();
            if (pluginPaths == null) continue;
            for (String path : pluginPaths) {
                paths.add(new File(root, path).getAbsolutePath());
            }
        }
        return paths;
    }

    public static List<String> pluginDesignerPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (DeploymentSpec spec : deploymentSpecs) {
            File root = spec.getBaseDir();
            List<String> pluginDesignerPaths = spec.getPluginDesignerPaths();
            if (pluginDesignerPaths == null) continue;
            for (String path : pluginDesignerPaths) {
                paths.add(new File(root, path).getAbsolutePath());
            }
        }
        return paths;
    }

    public static void loadLibrary(String library) {
        if (Utilities.configuration == Utilities.Configuration.Debug) {
            library = library + DEBUG_SUFFIX;
        }
        String version = Utilities.QTJAMBI_SONAME_VERSION_MAJOR;
        String lib = NativeLibraryManager.jniLibraryName(library, version);
        NativeLibraryManager.loadNativeLibrary(lib);
    }

    public static void loadJambiJniLibrary(String library) {
        NativeLibraryManager.loadLibrary(library);
    }

    public static void loadJambiLibrary(String library) {
        if (Utilities.configuration == Utilities.Configuration.Debug) {
            library = library + DEBUG_SUFFIX;
        }
        String version = Utilities.QTJAMBI_SONAME_VERSION_MAJOR;
        String lib = NativeLibraryManager.jambiLibraryName(library, version);
        NativeLibraryManager.loadNativeLibrary(lib);
    }

    public static void loadQtLibrary(String library) {
        NativeLibraryManager.loadQtLibrary(library, "4");
    }

    public static void loadQtLibrary(String library, String version) {
        String lib = NativeLibraryManager.qtLibraryName(library, version);
        NativeLibraryManager.loadNativeLibrary(lib);
    }

    public static boolean isAvailableQtLibrary(String library, String version) {
        String lib = NativeLibraryManager.qtLibraryName(library, version);
        DeploymentSpec[] deploymentSpecA = NativeLibraryManager.getActiveDeploymentSpec();
        if (deploymentSpecA == null) {
            return false;
        }
        for (DeploymentSpec deploymentSpec : deploymentSpecA) {
            List<LibraryEntry> libraries = deploymentSpec.getLibraries();
            for (LibraryEntry libraryEntry : libraries) {
                String lastPart;
                String name = libraryEntry.getName();
                if (name == null) continue;
                if (lib.equals(name)) {
                    return true;
                }
                String[] pathA = RetroTranslatorHelper.split(name, "/");
                if (pathA == null || pathA.length == 0 || !lib.equals(lastPart = pathA[pathA.length - 1])) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> unpackPlugins() {
        if (activeDeploymentSpecA != null) {
            File resolvedFile;
            ArrayList<String> paths = new ArrayList<String>();
            for (DeploymentSpec spec : activeDeploymentSpecA) {
                List<String> pluginPaths = spec.getPluginPaths();
                if (pluginPaths == null) continue;
                for (String p : pluginPaths) {
                    resolvedFile = spec.buildPath(p);
                    if (resolvedFile == null || !resolvedFile.isDirectory()) continue;
                    paths.add(resolvedFile.getAbsolutePath());
                }
            }
            for (DeploymentSpec spec : activeDeploymentSpecA) {
                List<String> pluginDesignerPaths = spec.getPluginDesignerPaths();
                if (pluginDesignerPaths == null) continue;
                for (String p : pluginDesignerPaths) {
                    resolvedFile = spec.buildPath(p);
                    if (resolvedFile == null || !resolvedFile.isDirectory()) continue;
                    paths.add(resolvedFile.getAbsolutePath());
                }
            }
            return paths;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentSpec[] unpack() {
        if (unpacked) {
            return activeDeploymentSpecA;
        }
        try {
            Class<NativeLibraryManager> clazz = NativeLibraryManager.class;
            synchronized (NativeLibraryManager.class) {
                if (unpacked) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return activeDeploymentSpecA;
                }
                activeDeploymentSpecA = NativeLibraryManager.unpack_helper();
                unpacked = true;
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to unpack native libraries, progress so far:\n" + reporter, t);
        }
        {
            return activeDeploymentSpecA;
        }
    }

    private static DeploymentSpec[] unpack_helper() throws Exception {
        ArrayList<DeploymentSpec> specList = new ArrayList<DeploymentSpec>();
        ClassLoader loader = NativeLibraryManager.classLoader();
        Enumeration<URL> specsFound = loader.getResources(DEPLOY_DESCRIPTOR_NAME);
        while (specsFound.hasMoreElements()) {
            URL url = specsFound.nextElement();
            if (VERBOSE_LOADING) {
                reporter.report("Found ", url.toString());
            }
            DeploymentSpec spec = null;
            String protocol = url.getProtocol();
            if (protocol.equals("jar")) {
                int start;
                String eform = url.toExternalForm();
                int end = eform.indexOf("!/", start = 4);
                if (end != -1) {
                    URL jarUrl = new URL(eform.substring(start, end));
                    String jarName = new File(jarUrl.getFile()).getName();
                    if (VERBOSE_LOADING) {
                        reporter.report("Loading ", jarName, " from ", eform);
                    }
                    spec = NativeLibraryManager.unpackDeploymentSpec(url, jarName, null);
                }
            } else if (protocol.equals("file")) {
                spec = NativeLibraryManager.unpackDeploymentSpec(url, null, Boolean.FALSE);
            }
            if (spec == null) continue;
            specList.add(spec);
        }
        if (specList.size() == 0) {
            reporter.report("No '", DEPLOY_DESCRIPTOR_NAME, "' found in classpath, loading libraries via 'java.library.path'");
            return null;
        }
        return specList.toArray(new DeploymentSpec[specList.size()]);
    }

    private static ClassLoader classLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = NativeLibraryManager.class.getClassLoader();
            assert (loader != null);
        }
        return loader;
    }

    private static void loadNativeLibrary(String lib) {
        try {
            NativeLibraryManager.loadLibrary_helper(lib);
            if (VERBOSE_LOADING) {
                System.out.println(reporter.recentReports());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Loading library failed, progress so far:\n" + reporter, e);
        }
    }

    private static void loadLibrary_helper(String lib) {
        NativeLibraryManager.unpack();
        reporter.report("Loading library: '", lib, "'...");
        LibraryEntry e = neverLoad.get(lib);
        if (e != null) {
            throw new RuntimeException("Library '" + lib + "' cannot be loaded, deploy spec");
        }
        e = libraryMap.get(lib);
        if (e != null) {
            if (e.isLoaded()) {
                reporter.report(" - already loaded, skipping...");
                return;
            }
            File libFile = e.getDeploymentSpec().buildPath(e.getName());
            reporter.report(" - using deployment spec at " + libFile.getAbsolutePath());
            Runtime.getRuntime().load(libFile.getAbsolutePath());
            reporter.report(" - ok!");
            e.setLoaded(true);
        } else {
            boolean loaded = false;
            String libPaths = System.getProperty("com.trolltech.qt.library-path-override");
            if (libPaths != null && libPaths.length() > 0) {
                reporter.report(" - using 'com.trolltech.qt.library-path-override'");
            } else {
                reporter.report(" - using 'java.library.path'");
                libPaths = System.getProperty("java.library.path");
            }
            String[] paths = null;
            if (libPaths != null) {
                paths = RetroTranslatorHelper.split(libPaths, File.pathSeparator);
            }
            if ((paths = Utilities.mergeJniLibdir(paths)) != null) {
                for (String path : paths) {
                    File f = new File(path, lib);
                    if (!f.exists()) continue;
                    Runtime.getRuntime().load(f.getAbsolutePath());
                    reporter.report(" - ok, path was: " + f.getAbsolutePath());
                    loaded = true;
                    break;
                }
            }
            if (!loaded) {
                throw new RuntimeException("Library '" + lib + "' was not found in 'java.library.path=" + libPaths + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeploymentSpec readDeploySpec(URL url) throws Exception {
        reporter.report("Checking Archive '", url.toString(), "'");
        DeploymentSpec spec = new DeploymentSpec();
        spec.setSourceUrl(url);
        SAXParserFactory fact = SAXParserFactory.newInstance();
        SAXParser parser = fact.newSAXParser();
        XMLHandler handler = new XMLHandler();
        handler.spec = spec;
        InputStream inStream = null;
        try {
            inStream = url.openStream();
            parser.parse(inStream, (DefaultHandler)handler);
            if (spec.getKey() == null) {
                throw new DeploymentSpecException("Deployment Specification doesn't include required <cache key='...'/>");
            }
            deploymentSpecs.add(spec);
            DeploymentSpec deploymentSpec = spec;
            return deploymentSpec;
        }
        catch (WrongSystemException e) {
            reporter.report(" - skipping because of wrong system: " + e.getMessage());
            DeploymentSpec deploymentSpec = null;
            return deploymentSpec;
        }
        finally {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeploymentSpec unpackDeploymentSpec(URL deploymentSpec, String jarName, Boolean shouldUnpack) throws Exception {
        reporter.report("Unpacking .jar file: '", jarName, "'");
        DeploymentSpec spec = NativeLibraryManager.readDeploySpec(deploymentSpec);
        if (spec == null) {
            return spec;
        }
        File tmpDir = NativeLibraryManager.jambiTempDirBase(spec.getKey());
        reporter.report(" - using cache directory: '", tmpDir.getAbsolutePath(), "'");
        File dummyFile = null;
        if (shouldUnpack == null) {
            dummyFile = new File(tmpDir, ".dummy");
            if (dummyFile.exists()) {
                reporter.report(" - cache directory exists");
                shouldUnpack = Boolean.FALSE;
                spec.setBaseDir(tmpDir);
                spec.setBaseUrl(new URL(Utilities.convertAbsolutePathStringToFileUrlString(tmpDir)));
            } else {
                shouldUnpack = Boolean.TRUE;
            }
        }
        if (shouldUnpack.booleanValue()) {
            List<LibraryEntry> libraries;
            reporter.report(" - starting to copy content to cache directory...");
            List<String> dirents = spec.getDirents();
            if (dirents != null) {
                for (String path : dirents) {
                    reporter.report(" - copying over: '", path, "'...");
                    InputStream in = null;
                    FileOutputStream out = null;
                    try {
                        Enumeration<URL> resources = NativeLibraryManager.classLoader().getResources(path);
                        while (resources.hasMoreElements()) {
                            URL url = resources.nextElement();
                            String eform = url.toExternalForm();
                            if (eform.contains(jarName)) {
                                in = url.openStream();
                                reporter.report("    - matched url: ", url.toExternalForm());
                                continue;
                            }
                            if (!VERBOSE_LOADING) continue;
                            reporter.report("    - unmatched .jar file: ", eform);
                        }
                        if (in == null) {
                            throw new FileNotFoundException("Dirent '" + path + "' specified in qtjambi-deployment.xml in '" + jarName + "' does not exist");
                        }
                        File outFile = new File(tmpDir, path);
                        File outFileDir = outFile.getParentFile();
                        if (!outFileDir.exists()) {
                            reporter.report(" - creating directory: ", outFileDir.getAbsolutePath());
                            outFileDir.mkdirs();
                        }
                        out = new FileOutputStream(new File(tmpDir, path));
                        try {
                            NativeLibraryManager.copy(in, out);
                        }
                        finally {
                            in = null;
                            out = null;
                        }
                    }
                    finally {
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException eat) {}
                    }
                }
            }
            if ((libraries = spec.getLibraries()) != null) {
                for (LibraryEntry e : libraries) {
                    reporter.report(" - copying over: '", e.getName(), "'...");
                    InputStream in = null;
                    FileOutputStream out = null;
                    try {
                        Enumeration<URL> resources = NativeLibraryManager.classLoader().getResources(e.getName());
                        while (resources.hasMoreElements()) {
                            URL url = resources.nextElement();
                            String eform = url.toExternalForm();
                            if (eform.contains(jarName)) {
                                in = url.openStream();
                                reporter.report("    - matched url: ", url.toExternalForm());
                                continue;
                            }
                            if (!VERBOSE_LOADING) continue;
                            reporter.report("    - unmatched .jar file: ", eform);
                        }
                        if (in == null) {
                            throw new FileNotFoundException("Library '" + e.getName() + "' specified in qtjambi-deployment.xml in '" + jarName + "' does not exist");
                        }
                        File outFile = new File(tmpDir, e.getName());
                        File outFileDir = outFile.getParentFile();
                        if (!outFileDir.exists()) {
                            reporter.report(" - creating directory: ", outFileDir.getAbsolutePath());
                            outFileDir.mkdirs();
                        }
                        out = new FileOutputStream(new File(tmpDir, e.getName()));
                        try {
                            NativeLibraryManager.copy(in, out);
                        }
                        finally {
                            in = null;
                            out = null;
                        }
                    }
                    finally {
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException eat) {}
                    }
                }
            }
            if (dummyFile != null && !dummyFile.createNewFile()) {
                throw new DeploymentSpecException("Can't create dummy file in cache directory");
            }
            spec.setBaseDir(tmpDir);
            spec.setBaseUrl(new URL(Utilities.convertAbsolutePathStringToFileUrlString(tmpDir)));
        } else if (spec.getBaseUrl() == null) {
            String path = deploymentSpec.getPath();
            int i = path.lastIndexOf(47);
            if (i >= 0) {
                path = path.substring(0, i);
            }
            spec.setBaseDir(new File(path));
            spec.setBaseUrl(new URL(deploymentSpec, path));
        }
        List<LibraryEntry> libraries = spec.getLibraries();
        for (LibraryEntry e : libraries) {
            if (e.getLoad() != 1) continue;
            NativeLibraryManager.loadSystemLibrary(e.getName());
        }
        return spec;
    }

    public static boolean loadSystemLibrary(String name) {
        DeploymentSpec[] activeSpecA = NativeLibraryManager.getActiveDeploymentSpec();
        if (activeSpecA == null) {
            throw new RuntimeException("No active deployment spec is set");
        }
        reporter.report(" - trying to load: ", name);
        File foundFile = null;
        for (DeploymentSpec deploymentSpec : activeSpecA) {
            File f = new File(deploymentSpec.getBaseDir(), name);
            if (!f.isFile()) continue;
            foundFile = f;
            break;
        }
        if (foundFile == null) {
            return false;
        }
        Runtime rt = Runtime.getRuntime();
        rt.load(foundFile.getAbsolutePath());
        reporter.report(" - ok!");
        return true;
    }

    private static String jniLibraryName(String lib, String version) {
        String dotVersion;
        if (version != null) {
            dotVersion = "." + version;
        } else {
            version = "";
            dotVersion = "";
        }
        switch (Utilities.operatingSystem) {
            case Windows: {
                return lib + version + ".dll";
            }
            case MacOSX: {
                return "lib" + lib + dotVersion + ".jnilib";
            }
            case Linux: 
            case FreeBSD: {
                return "lib" + lib + ".so" + dotVersion;
            }
        }
        throw new RuntimeException("Unreachable statement");
    }

    private static String jambiLibraryName(String lib, String version) {
        String dotVersion;
        if (version != null) {
            dotVersion = "." + version;
        } else {
            version = "";
            dotVersion = "";
        }
        switch (Utilities.operatingSystem) {
            case Windows: {
                return lib + version + ".dll";
            }
            case MacOSX: {
                return "lib" + lib + dotVersion + ".dylib";
            }
            case Linux: 
            case FreeBSD: {
                return "lib" + lib + ".so" + dotVersion;
            }
        }
        throw new RuntimeException("Unreachable statement");
    }

    private static String qtLibraryName(String lib, String version) {
        String dotVersion;
        if (version != null) {
            dotVersion = "." + version;
        } else {
            version = "";
            dotVersion = "";
        }
        switch (Utilities.operatingSystem) {
            case Windows: {
                return Utilities.configuration == Utilities.Configuration.Debug ? lib + "d" + version + ".dll" : lib + version + ".dll";
            }
            case MacOSX: {
                return Utilities.configuration == Utilities.Configuration.Debug ? "lib" + lib + "_debug" + dotVersion + ".dylib" : "lib" + lib + dotVersion + ".dylib";
            }
            case Linux: 
            case FreeBSD: {
                return "lib" + lib + ".so." + version;
            }
        }
        throw new RuntimeException("Unreachable statement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copy(InputStream in, OutputStream out) throws IOException {
        boolean bf = false;
        try {
            int n;
            byte[] buffer = new byte[8192];
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
            out.close();
            out = null;
            in.close();
            in = null;
            bf = true;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException eat) {}
                out = null;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
        }
        return bf;
    }

    public static boolean isUsingDeploymentSpec() {
        NativeLibraryManager.unpack();
        return deploymentSpecs != null && deploymentSpecs.size() != 0;
    }

    public static void main(String[] args) throws Exception {
        NativeLibraryManager.unpack();
        NativeLibraryManager.loadQtLibrary("QtCore");
        NativeLibraryManager.loadQtLibrary("QtGui");
        NativeLibraryManager.loadJambiJniLibrary("qtjambi");
        NativeLibraryManager.loadJambiJniLibrary("com_trolltech_qt_core");
        NativeLibraryManager.loadJambiJniLibrary("com_trolltech_qt_gui");
        NativeLibraryManager.loadQtLibrary("QtGui");
        NativeLibraryManager.loadQtLibrary("QtNetwork");
        for (String s : NativeLibraryManager.pluginPaths()) {
            System.out.println("PluginPath: " + s);
        }
        for (String s : NativeLibraryManager.pluginDesignerPaths()) {
            System.out.println("PluginDesignerPath: " + s);
        }
    }

    static {
        Boolean bf = Utilities.matchBooleanProperty("com.trolltech.qt.verbose-loading", Boolean.FALSE, Boolean.TRUE, null, null);
        VERBOSE_LOADING = bf;
        libraryMap = new HashMap<String, LibraryEntry>();
        neverLoad = new HashMap<String, LibraryEntry>();
        deploymentSpecs = new ArrayList<DeploymentSpec>();
        reporter = new Reporter();
        unpacked = false;
    }

    private static class XMLHandler
    extends DefaultHandler {
        public DeploymentSpec spec;
        private List<String> direntCurrentPathList = new ArrayList<String>();

        private XMLHandler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) {
            if (name.equals("cache")) {
                String key = attributes.getValue("key");
                if (key == null) {
                    throw new DeploymentSpecException("<cache> element missing required attribute \"key\"");
                }
                this.spec.setKey(key);
                reporter.report(" - cache key='", this.spec.getKey(), "'");
            } else if (name.equals("library")) {
                LibraryEntry e = new LibraryEntry();
                e.setName(attributes.getValue("name"));
                if (e.getName() == null) {
                    throw new DeploymentSpecException("<library> element missing required attribute \"name\"");
                }
                String load = attributes.getValue("load");
                e.setLoad(3);
                if (load != null) {
                    if (load.equals("true")) {
                        e.setLoad(1);
                    } else if (load.equals("never")) {
                        e.setLoad(4);
                    } else if (load.equals("system")) {
                        e.setLoad(2);
                    }
                }
                e.setDeploymentSpec(this.spec);
                String fileName = new File(e.getName()).getName();
                if (e.getLoad() == 4) {
                    neverLoad.put(fileName, e);
                } else {
                    LibraryEntry old = (LibraryEntry)libraryMap.get(fileName);
                    if (old != null) {
                        throw new DeploymentSpecException("<library> '" + e.getName() + "' is duplicated. Present in both '" + this.spec.getSourceUrl() + "' and '" + old.getDeploymentSpec().getSourceUrl() + "'.");
                    }
                    reporter.report(" - adding '", fileName, "' to library map");
                    libraryMap.put(fileName, e);
                }
                this.spec.addLibraryEntry(e);
                reporter.report(" - library: name='", e.getName(), "', ", NativeLibraryManager.loadToString(e.getLoad()));
            } else if (name.equals("plugin")) {
                String path = attributes.getValue("path");
                if (path == null) {
                    throw new DeploymentSpecException("<plugin> element missing required attribute \"path\"");
                }
                this.spec.addPluginPath(path);
                reporter.report(" - plugin path='", path, "'");
            } else if (name.equals("plugin-designer")) {
                String path = attributes.getValue("path");
                if (path == null) {
                    throw new DeploymentSpecException("<plugin-designer> element missing required attribute \"path\"");
                }
                this.spec.addPluginDesignerPath(path);
                reporter.report(" - plugin-designer path='", path, "'");
            } else if (name.equals("qtjambi-deploy")) {
                String system = attributes.getValue("system");
                if (system == null || system.length() == 0) {
                    throw new DeploymentSpecException("<qtjambi-deploy> element missing required attribute 'system'");
                }
                if (!system.equals(OSInfo.osArchName())) {
                    throw new WrongSystemException("trying to load: '" + system + "', expected: '" + OSInfo.osArchName() + "'");
                }
            } else if (name.equals("directory")) {
                String attrName = attributes.getValue("name");
                if (attrName == null) {
                    throw new DeploymentSpecException("<directory> element missing required attribute \"name\"");
                }
                while (attrName.length() > 0 && attrName.charAt(0) == '/') {
                    attrName = attrName.substring(1);
                }
                while (attrName.length() > 0 && attrName.charAt(attrName.length() - 1) == '/') {
                    attrName = attrName.substring(0, attrName.length() - 1 - 1);
                }
                this.direntCurrentPathList.add(attrName);
            } else if (name.equals("file")) {
                String attrName = attributes.getValue("name");
                if (attrName == null) {
                    throw new DeploymentSpecException("<file> element missing required attribute \"name\"");
                }
                StringBuilder sb = new StringBuilder();
                for (String s : this.direntCurrentPathList) {
                    if (sb.length() > 0) {
                        sb.append('/');
                    }
                    sb.append(s);
                }
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(attrName);
                this.spec.addDirentPath(sb.toString());
                reporter.report(" - dirent path='", sb.toString(), "'");
            }
        }

        public void endElement(String uri, String localName, String name) {
            if (name.equals("directory") && !this.direntCurrentPathList.isEmpty()) {
                this.direntCurrentPathList.remove(this.direntCurrentPathList.size() - 1);
            }
        }
    }
}

