/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.core;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class QMessageHandler {
    private static ReadWriteLock handlersLock = new ReentrantReadWriteLock();
    private static QMessageHandler[] handlers;

    public abstract void debug(String var1);

    public abstract void warning(String var1);

    public abstract void critical(String var1);

    public abstract void fatal(String var1);

    public static void installMessageHandler(QMessageHandler addHandler) {
        QMessageHandler.replaceMessageHandler(null, addHandler);
    }

    public static void removeMessageHandler(QMessageHandler removeHandler) {
        QMessageHandler.replaceMessageHandler(removeHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceMessageHandler(QMessageHandler removeHandler, QMessageHandler addHandler) {
        handlersLock.writeLock().lock();
        try {
            QMessageHandler[] tmpHandlers;
            int oldLength;
            QMessageHandler[] newHandlers = handlers;
            boolean didRemove = false;
            boolean didAppend = false;
            if (removeHandler != null && handlers != null) {
                oldLength = handlers.length;
                int index = 0;
                for (QMessageHandler h : handlers) {
                    if (h == removeHandler) break;
                    ++index;
                }
                if (index < oldLength) {
                    tmpHandlers = null;
                    if (oldLength > 1) {
                        tmpHandlers = new QMessageHandler[oldLength - 1];
                        System.arraycopy(handlers, 0, tmpHandlers, 0, index);
                        System.arraycopy(handlers, index + 1, tmpHandlers, index, oldLength - index - 1);
                    }
                    didRemove = true;
                    newHandlers = tmpHandlers;
                }
            }
            if (addHandler != null) {
                QMessageHandler[] useHandlers = newHandlers != null ? newHandlers : handlers;
                oldLength = useHandlers != null ? useHandlers.length : 0;
                tmpHandlers = new QMessageHandler[oldLength + 1];
                if (useHandlers != null) {
                    System.arraycopy(useHandlers, 0, tmpHandlers, 0, oldLength);
                }
                tmpHandlers[oldLength] = addHandler;
                didAppend = true;
                newHandlers = tmpHandlers;
            }
            if (didRemove != didAppend) {
                if (didRemove && newHandlers == null) {
                    QMessageHandler.removeMessageHandlerProxy();
                } else if (didAppend && handlers == null) {
                    QMessageHandler.installMessageHandlerProxy();
                }
            }
            handlers = newHandlers;
        }
        finally {
            handlersLock.writeLock().unlock();
        }
    }

    public static int shutdown(boolean verbose) {
        QMessageHandler[] hA;
        int count;
        for (count = 0; count < 999 && (hA = handlers) != null && hA.length != 0; ++count) {
            QMessageHandler h = hA[0];
            if (verbose) {
                System.err.println("QMessageHandler.shutdown(): removing handler " + h + "; remove your handler(s) before shutdown");
            }
            QMessageHandler.removeMessageHandler(h);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean process(int id, String message) {
        boolean bf;
        handlersLock.readLock().lock();
        try {
            if (handlers == null) {
                bf = false;
            } else {
                switch (id) {
                    case 0: {
                        for (QMessageHandler h : handlers) {
                            h.debug(message);
                        }
                        break;
                    }
                    case 1: {
                        for (QMessageHandler h : handlers) {
                            h.warning(message);
                        }
                        break;
                    }
                    case 2: {
                        for (QMessageHandler h : handlers) {
                            h.critical(message);
                        }
                        break;
                    }
                    default: {
                        for (QMessageHandler h : handlers) {
                            h.fatal(message);
                        }
                    }
                }
                bf = true;
            }
        }
        finally {
            handlersLock.readLock().unlock();
        }
        return bf;
    }

    private static native void installMessageHandlerProxy();

    private static native void removeMessageHandlerProxy();

    static {
        try {
            Class.forName("com.trolltech.qt.QtJambi_LibraryInitializer");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

