/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.internal.DeploymentSpec;
import com.trolltech.qt.internal.NativeLibraryManager;
import com.trolltech.qt.osinfo.OSInfo;
import com.trolltech.qt.qtjambi.util.RetroTranslatorHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static final String VERSION_STRING;
    public static final String VERSION_MAJOR_STRING;
    public static final String QTJAMBI_SONAME_VERSION_MAJOR;
    private static final List<String> systemLibrariesList;
    private static final List<String> jniLibdirBeforeList;
    private static final List<String> jniLibdirList;
    private static final int[] versionA;
    private static final String K_qtjambi_version = "qtjambi.version";
    private static final String K_qtjambi_soname_version_major = "qtjambi.soname.version.major";
    private static final String K_qtjambi_system_libraries = "qtjambi.system.libraries";
    private static final String K_qtjambi_jni_libdir_before = "qtjambi.jni.libdir.before";
    private static final String K_qtjambi_jni_libdir = "qtjambi.jni.libdir";
    private static final Configuration DEFAULT_CONFIGURATION;
    public static final String K_Bundle_SymbolicName = "Bundle-SymbolicName";
    public static final String K_X_QtJambi_Build = "X-QtJambi-Build";
    public static final String K_com_trolltech_qt = "com.trolltech.qt";
    public static final String K_debug = "debug";
    public static final String K_test = "test";
    public static final String K_release = "release";
    public static OperatingSystem operatingSystem;
    public static Configuration configuration;
    public static String libSubPath;

    public static List<String> resolveSystemLibraries(List<String> tmpSystemLibrariesList) {
        if (tmpSystemLibrariesList == null) {
            return null;
        }
        DeploymentSpec[] deploymentSpecA = NativeLibraryManager.unpack();
        if (deploymentSpecA == null) {
            return null;
        }
        ArrayList<String> resolvedList = new ArrayList<String>();
        Iterator<String> i$ = tmpSystemLibrariesList.iterator();
        while (i$.hasNext()) {
            String original;
            String s = original = i$.next();
            if (OSInfo.isWindows()) {
                s = Utilities.stringCharReplace(s, "/", File.separator);
            }
            String resolvedPath = null;
            for (DeploymentSpec deploymentSpec : deploymentSpecA) {
                File f = new File(deploymentSpec.getBaseDir(), s);
                if (f.isFile()) {
                    resolvedPath = s;
                    break;
                }
                File libDir = new File(deploymentSpec.getBaseDir(), "lib");
                f = new File(libDir, s);
                if (f.isFile()) {
                    resolvedPath = "lib" + File.separator + s;
                    break;
                }
                File binDir = new File(deploymentSpec.getBaseDir(), "bin");
                f = new File(binDir, s);
                if (!f.isFile()) continue;
                resolvedPath = "bin" + File.separator + s;
                break;
            }
            if (resolvedPath != null) {
                resolvedList.add(resolvedPath);
                continue;
            }
            System.err.println("IGNORED version.properties qtjambi.system.libraries entry \"" + original + "\": file could not be found");
        }
        return Collections.unmodifiableList(resolvedList);
    }

    public static Boolean match(String value, Boolean defaultValue, String[] falseA, String[] trueA) {
        for (String s : trueA) {
            if (!value.contains(s)) continue;
            return true;
        }
        for (String s : falseA) {
            if (!value.contains(s)) continue;
            return false;
        }
        return defaultValue;
    }

    public static Boolean matchBooleanProperty(String name, Boolean ifNotExistsValue, Boolean ifExistsValue, String[] falseA, String[] trueA) {
        String value = System.getProperty(name);
        if (falseA == null) {
            falseA = new String[]{"false", "no"};
        }
        if (trueA == null) {
            trueA = new String[]{"true", "yes"};
        }
        if (value == null) {
            return ifNotExistsValue;
        }
        return Utilities.match(value, ifExistsValue, falseA, trueA);
    }

    public static Boolean matchProperty(String name, Boolean ifNotExistsValue, Boolean defaultValue, String[] falseA, String[] trueA) {
        String value = System.getProperty(name);
        if (value == null) {
            return ifNotExistsValue;
        }
        return Utilities.match(value, defaultValue, falseA, trueA);
    }

    public static boolean matchProperty(String name, String ... substrings) {
        String[] substringsA = substrings;
        if (substringsA == null) {
            substringsA = new String[]{};
        }
        Boolean ifExistsValue = Boolean.FALSE;
        if (substringsA.length == 0) {
            ifExistsValue = Boolean.TRUE;
        }
        return Utilities.matchProperty(name, Boolean.FALSE, ifExistsValue, new String[0], substringsA);
    }

    public static void loadSystemLibraries() {
        if (systemLibrariesList != null) {
            for (String s : systemLibrariesList) {
                NativeLibraryManager.loadSystemLibrary(s);
            }
        }
    }

    public static String[] mergeJniLibdir(String[] middle) {
        ArrayList<String> newList = new ArrayList<String>();
        if (jniLibdirBeforeList != null) {
            newList.addAll(jniLibdirBeforeList);
        }
        if (middle != null) {
            for (String s : middle) {
                newList.add(s);
            }
        }
        if (jniLibdirList != null) {
            newList.addAll(jniLibdirList);
        }
        if (newList.size() == 0) {
            return middle;
        }
        return newList.toArray(new String[newList.size()]);
    }

    public static boolean isAvailableQtLibrary(String library) {
        return NativeLibraryManager.isAvailableQtLibrary(library, VERSION_MAJOR_STRING);
    }

    public static void loadQtLibrary(String library) {
        Utilities.loadQtLibrary(library, VERSION_MAJOR_STRING);
    }

    public static void loadQtLibrary(String library, String version) {
        NativeLibraryManager.loadQtLibrary(library, version);
    }

    public static void loadJambiLibrary(String library) {
        NativeLibraryManager.loadJambiLibrary(library);
    }

    public static void loadJambiJniLibrary(String library) {
        NativeLibraryManager.loadJambiJniLibrary(library);
    }

    public static boolean loadLibrary(String lib) {
        try {
            NativeLibraryManager.loadLibrary(lib);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File jambiTempDir() {
        return NativeLibraryManager.jambiTempDir();
    }

    private static OperatingSystem decideOperatingSystem() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return OperatingSystem.Windows;
        }
        if (osName.startsWith("mac os x")) {
            return OperatingSystem.MacOSX;
        }
        if (osName.startsWith("freebsd")) {
            return OperatingSystem.FreeBSD;
        }
        if (osName.equals("sunos")) {
            return OperatingSystem.SunOS;
        }
        return OperatingSystem.Linux;
    }

    private static Configuration decideConfiguration() {
        Configuration configuration = null;
        String K_com_trolltech_qt_debug = "com.trolltech.qt.debug";
        String debugString = System.getProperty("com.trolltech.qt.debug");
        try {
            if (debugString != null) {
                Boolean booleanValue;
                if (Configuration.Release.toString().compareToIgnoreCase(debugString) == 0) {
                    configuration = Configuration.Release;
                } else if (Configuration.Debug.toString().compareToIgnoreCase(debugString) == 0) {
                    configuration = Configuration.Debug;
                } else if (Configuration.Test.toString().compareToIgnoreCase(debugString) == 0) {
                    configuration = Configuration.Test;
                }
                if (configuration == null && ((booleanValue = Boolean.valueOf(debugString)) != null && booleanValue.booleanValue() || debugString.length() == 0)) {
                    configuration = Configuration.Debug;
                    System.err.println("-Dcom.trolltech.qt.debug=" + Boolean.TRUE + "; is set");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("-Dcom.trolltech.qt.debug=" + Boolean.FALSE + "; is assumed default");
        }
        if (configuration == null) {
            configuration = Utilities.decideDefaultConfiguration();
        }
        if (configuration == null) {
            configuration = DEFAULT_CONFIGURATION;
        }
        return configuration;
    }

    private static boolean bundleSymbolicNameMatch(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        int i = a.indexOf(59);
        if (i >= 0) {
            a = a.substring(0, i);
        }
        if ((i = a.indexOf(59)) >= 0) {
            b = b.substring(0, i);
        }
        if (a.equals(b)) {
            return true;
        }
        return b.startsWith(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration decideDefaultConfiguration() {
        Configuration configuration = null;
        String configurationSource = null;
        try {
            boolean error = false;
            Enumeration<URL> enumUrls = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumUrls.hasMoreElements()) {
                URL url = enumUrls.nextElement();
                InputStream inStream = null;
                try {
                    URLConnection urlConnection = url.openConnection();
                    inStream = urlConnection.getInputStream();
                    Manifest manifest = new Manifest(inStream);
                    inStream.close();
                    inStream = null;
                    Attributes attributes = manifest.getMainAttributes();
                    String tmpBundleSymbolicName = attributes.getValue(K_Bundle_SymbolicName);
                    String tmpXQtJambiBuild = attributes.getValue(K_X_QtJambi_Build);
                    Configuration tmpConfiguration = null;
                    if (!Utilities.bundleSymbolicNameMatch(K_com_trolltech_qt, tmpBundleSymbolicName)) continue;
                    if (K_release.equals(tmpXQtJambiBuild)) {
                        tmpConfiguration = Configuration.Release;
                    } else if (K_debug.equals(tmpXQtJambiBuild)) {
                        tmpConfiguration = Configuration.Debug;
                    } else if (K_test.equals(tmpXQtJambiBuild)) {
                        tmpConfiguration = Configuration.Test;
                    } else if (tmpXQtJambiBuild == null) {
                        tmpXQtJambiBuild = "<notset>";
                    }
                    if (configuration != null && tmpConfiguration != null && tmpConfiguration != configuration) {
                        System.err.println(Utilities.class.getName() + "#decideDefaultConfiguration()  " + configurationSource + "(" + configuration.toString() + ") != " + url.toString() + "(" + tmpConfiguration.toString() + ") multiple different " + K_X_QtJambi_Build + ": found in ClassPath JARs, this is currently not supported");
                        configuration = null;
                        configurationSource = null;
                        error = true;
                        continue;
                    }
                    if (tmpConfiguration == null || error) continue;
                    configuration = tmpConfiguration;
                    configurationSource = url.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (inStream == null) continue;
                    try {
                        inStream.close();
                    }
                    catch (IOException eat) {}
                    inStream = null;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return configuration;
    }

    private static String decideLibSubPath() {
        return operatingSystem == OperatingSystem.Windows ? "bin" : "lib";
    }

    public static List<String> unpackPlugins() {
        String[] classPathElements;
        List<String> paths = NativeLibraryManager.unpackPlugins();
        if (paths != null) {
            return paths;
        }
        paths = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path");
        for (String element : classPathElements = RetroTranslatorHelper.split(classPath, File.pathSeparator)) {
            File base = new File(element);
            if (base.isDirectory()) {
                File pluginsDir;
                File descriptorFile = new File(base, "qtjambi-deployment.xml");
                if (descriptorFile.isFile() && configuration == Configuration.Debug) {
                    System.out.println("unpackPlugins() found qtjambi-deployment.xml at " + descriptorFile.getAbsolutePath());
                }
                if ((pluginsDir = new File(base, "plugins")).isDirectory()) {
                    if (configuration == Configuration.Debug) {
                        System.out.println("unpackPlugins() found plugins/ at " + pluginsDir.getAbsolutePath());
                    }
                    paths.add(pluginsDir.getAbsolutePath());
                    continue;
                }
                if (configuration != Configuration.Debug) continue;
                System.out.println("unpackPlugins() found DIRECTORY at " + base.getAbsolutePath());
                continue;
            }
            if (element.toLowerCase().endsWith(".jar")) {
                if (configuration != Configuration.Debug) continue;
                System.out.println("unpackPlugins() found JAR at " + base.getAbsolutePath());
                continue;
            }
            if (configuration != Configuration.Debug) continue;
            System.out.println("unpackPlugins() found FILE at " + base.getAbsolutePath());
        }
        if (paths.isEmpty()) {
            return null;
        }
        return paths;
    }

    public static String stringCharReplace(String s, char fromChar, char toChar) {
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == fromChar) {
                sb.append(toChar);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean stringCompareAt(CharSequence a, int aOffset, CharSequence b, int bOffset) {
        int aLen = a.length();
        int bLen = b.length();
        while (aOffset < aLen && bOffset < bLen) {
            char ba;
            char ca;
            if ((ca = a.charAt(aOffset++)) == (ba = b.charAt(bOffset++))) continue;
            return false;
        }
        return bOffset >= bLen;
    }

    public static String stringCharReplace(String s, CharSequence fromCharSequence, CharSequence toCharSequence) {
        int len = s.length();
        char[] cA = new char[fromCharSequence.length()];
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == fromCharSequence.charAt(0) && Utilities.stringCompareAt(s, i, fromCharSequence, 0)) {
                sb.append(toCharSequence);
                i += fromCharSequence.length();
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String convertAbsolutePathStringToFileUrlString(String pathString) {
        if (File.separatorChar == '\\') {
            pathString = Utilities.stringCharReplace(pathString, '\\', '/');
        }
        String schemePrefix = pathString.length() > 0 && pathString.charAt(0) != '/' ? "file:///" : "file://";
        return schemePrefix + pathString;
    }

    public static String convertAbsolutePathStringToFileUrlString(File file) {
        return Utilities.convertAbsolutePathStringToFileUrlString(file.getAbsolutePath());
    }

    public static int[] getVersion() {
        int[] vA = new int[versionA.length];
        System.arraycopy(versionA, 0, vA, 0, versionA.length);
        return vA;
    }

    public static int[] getVersion(String versionString) {
        String[] sA = RetroTranslatorHelper.split(versionString, ".");
        int[] vA = new int[sA.length];
        int i = 0;
        for (String s : sA) {
            vA[i++] = Integer.valueOf(s);
        }
        return vA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        DEFAULT_CONFIGURATION = Configuration.Release;
        String tmpVERSION_STRING = null;
        String tmpVERSION_MAJOR_STRING = null;
        String tmpQTJAMBI_SONAME_VERSION_MAJOR = null;
        int[] tmpVERSION_A = null;
        List<String> tmpSystemLibrariesList = null;
        List<String> tmpJniLibdirBeforeList = null;
        List<String> tmpJniLibdirList = null;
        try {
            Properties props = new Properties();
            ClassLoader loader = Utilities.class.getClassLoader();
            if (loader == null) {
                throw new ExceptionInInitializerError("Could not get classloader!");
            }
            InputStream in = loader.getResourceAsStream("com/trolltech/qt/version.properties");
            if (in == null) {
                throw new ExceptionInInitializerError("version.properties not found!");
            }
            try {
                props.load(in);
            }
            catch (Exception ex) {
                throw new ExceptionInInitializerError("Cannot read properties!");
            }
            tmpVERSION_STRING = props.getProperty(K_qtjambi_version);
            if (tmpVERSION_STRING == null) {
                throw new ExceptionInInitializerError("qtjambi.version is not set!");
            }
            int dotIndex = tmpVERSION_STRING.indexOf(".");
            tmpVERSION_MAJOR_STRING = dotIndex > 0 ? tmpVERSION_STRING.substring(0, dotIndex) : tmpVERSION_STRING;
            tmpQTJAMBI_SONAME_VERSION_MAJOR = props.getProperty(K_qtjambi_soname_version_major);
            TreeMap<String, String> tmpSystemLibrariesMap = new TreeMap<String, String>();
            TreeMap<String, String> tmpJniLibdirBeforeMap = new TreeMap<String, String>();
            TreeMap<String, String> tmpJniLibdirMap = new TreeMap<String, String>();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                if (key.equals(K_qtjambi_system_libraries) || key.startsWith("qtjambi.system.libraries.")) {
                    tmpSystemLibrariesMap.put(key, value);
                    continue;
                }
                if (key.equals(K_qtjambi_jni_libdir_before) || key.startsWith("qtjambi.jni.libdir.before.")) {
                    tmpJniLibdirBeforeMap.put(key, value);
                    continue;
                }
                if (!key.equals(K_qtjambi_jni_libdir) && !key.startsWith("qtjambi.jni.libdir.")) continue;
                tmpJniLibdirMap.put(key, value);
            }
            tmpVERSION_A = Utilities.getVersion(tmpVERSION_STRING);
            tmpSystemLibrariesList = new ArrayList<String>();
            for (String v : tmpSystemLibrariesMap.values()) {
                tmpSystemLibrariesList.add(v);
            }
            tmpSystemLibrariesList = tmpSystemLibrariesList.size() > 0 ? Utilities.resolveSystemLibraries(tmpSystemLibrariesList) : null;
            tmpJniLibdirBeforeList = new ArrayList<String>();
            for (String v : tmpJniLibdirBeforeMap.values()) {
                tmpJniLibdirBeforeList.add(v);
            }
            tmpJniLibdirBeforeList = tmpJniLibdirBeforeList.size() > 0 ? Collections.unmodifiableList(tmpJniLibdirBeforeList) : null;
            tmpJniLibdirList = new ArrayList<String>();
            for (String v : tmpJniLibdirMap.values()) {
                tmpJniLibdirList.add(v);
            }
            tmpJniLibdirList = tmpJniLibdirList.size() > 0 ? Collections.unmodifiableList(tmpJniLibdirList) : null;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            VERSION_STRING = tmpVERSION_STRING;
            VERSION_MAJOR_STRING = tmpVERSION_MAJOR_STRING;
            versionA = tmpVERSION_A;
            QTJAMBI_SONAME_VERSION_MAJOR = tmpQTJAMBI_SONAME_VERSION_MAJOR;
            systemLibrariesList = tmpSystemLibrariesList;
            jniLibdirBeforeList = tmpJniLibdirBeforeList;
            jniLibdirList = tmpJniLibdirList;
        }
        operatingSystem = Utilities.decideOperatingSystem();
        configuration = Utilities.decideConfiguration();
        libSubPath = Utilities.decideLibSubPath();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Configuration {
        Release("Release"),
        Debug("Debug"),
        Test("Test");

        private String label;

        private Configuration(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperatingSystem {
        Windows("Windows"),
        MacOSX("MacOSX"),
        Linux("Linux"),
        FreeBSD("FreeBSD"),
        SunOS("SunOS");

        private String label;

        private OperatingSystem(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

