/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.QThreadManager;
import com.trolltech.qt.QtJambi_LibraryShutdown;
import com.trolltech.qt.Utilities;
import com.trolltech.qt.core.QMessageHandler;
import com.trolltech.qt.internal.fileengine.QClassPathFileEngineHandler;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class QtJambi_LibraryInitializer {
    private static QMessageHandler messageHandler;
    static WeakReference<Thread> shutdownHookThread;

    private static void setupStaticReferences(String className, String[] fieldNameA) {
        Class<?> clazz;
        try {
            ClassLoader classLoader = QtJambi_LibraryInitializer.class.getClassLoader();
            clazz = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException eat) {
            eat.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (String fieldName : fieldNameA) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                field.get(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static void removeMessageHandlerForExceptions() {
        if (messageHandler != null) {
            QMessageHandler.removeMessageHandler(messageHandler);
            messageHandler = null;
        }
    }

    private static void installMessageHandlerForExceptions(String config) {
        if (config != null) {
            final boolean all = (config = config.trim().toUpperCase()).equals("") || config.equals("ALL") || config.equals("TRUE");
            final boolean critical = config.contains("CRITICAL");
            final boolean debug = config.contains("DEBUG");
            final boolean fatal = config.contains("FATAL");
            final boolean warning = config.contains("WARNING");
            boolean none = config.contains("NONE");
            if (all || critical || debug || fatal || warning || none) {
                QMessageHandler newMessageHandler = new QMessageHandler(){

                    public void critical(String message) {
                        if (critical || all) {
                            throw new RuntimeException("Critical: " + message);
                        }
                        System.err.println("Critical: " + message);
                    }

                    public void debug(String message) {
                        if (debug || all) {
                            throw new RuntimeException("Debug: " + message);
                        }
                        System.err.println("Debug: " + message);
                    }

                    public void fatal(String message) {
                        if (fatal || all) {
                            throw new RuntimeException("Fatal: " + message);
                        }
                        System.err.println("Fatal: " + message);
                    }

                    public void warning(String message) {
                        if (warning || all) {
                            throw new RuntimeException("Warning: " + message);
                        }
                        System.err.println("Warning: " + message);
                    }
                };
                QMessageHandler.replaceMessageHandler(messageHandler, newMessageHandler);
                messageHandler = newMessageHandler;
            }
        }
    }

    public static void init() {
    }

    private static native void initialize();

    static {
        try {
            Utilities.loadSystemLibraries();
            Utilities.loadQtLibrary("QtCore");
            Utilities.loadJambiJniLibrary("qtjambi");
            String s = System.getProperty("com.trolltech.qt.exceptions-for-messages");
            QtJambi_LibraryInitializer.installMessageHandlerForExceptions(s);
            QClassPathFileEngineHandler.initialize();
            QClassPathFileEngineHandler.start();
            QtJambi_LibraryInitializer.initialize();
            QThreadManager.initialize();
            Thread thread = new Thread(new QtJambi_LibraryShutdown());
            thread.setName("qtjambi-" + QtJambi_LibraryShutdown.class.getName());
            Runtime.getRuntime().addShutdownHook(thread);
            shutdownHookThread = new WeakReference<Thread>(thread);
            if (Utilities.configuration == Utilities.Configuration.Debug) {
                QtJambi_LibraryInitializer.setupStaticReferences("com.trolltech.qt.gui.QPen", QtJambi_LibraryShutdown.K_com_trolltech_qt_gui_QPen_FIELDNAMES);
                QtJambi_LibraryInitializer.setupStaticReferences("com.trolltech.qt.gui.QColor", QtJambi_LibraryShutdown.K_com_trolltech_qt_gui_QColor_FIELDNAMES);
                QtJambi_LibraryInitializer.setupStaticReferences("com.trolltech.qt.gui.QBrush", QtJambi_LibraryShutdown.K_com_trolltech_qt_gui_QBrush_FIELDNAMES);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

