/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.TGSettingsOption;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class SoundOption
extends TGSettingsOption {
    private boolean initialized = false;
    private String msCurrentKey;
    private List<MidiSequencer> msList;
    private UIDropDownSelect<MidiSequencer> msCombo;
    private String mpCurrentKey;
    private List<MidiOutputPort> mpList;
    private UIDropDownSelect<MidiOutputPort> mpCombo;

    public SoundOption(TGSettingsEditor configEditor, UIToolBar toolBar, UILayoutContainer parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.sound"));
    }

    public void createOption() {
        UIFactory uiFactory = this.getUIFactory();
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.sound"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionSound());
        this.getToolItem().addSelectionListener((UISelectionListener)this);
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("midi.sequencer"), true, 1, 1);
        UITableLayout msCompositeLayout = new UITableLayout();
        UIPanel msComposite = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        msComposite.setLayout((UILayout)msCompositeLayout);
        this.indent((UIControl)msComposite, 2, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, true, false);
        this.msCombo = uiFactory.createDropDownSelect((UIContainer)msComposite);
        msCompositeLayout.set(this.msCombo, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("midi.port"), true, 3, 1);
        UITableLayout mpCompositeLayout = new UITableLayout();
        UIPanel mpComposite = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        mpComposite.setLayout((UILayout)mpCompositeLayout);
        this.indent((UIControl)mpComposite, 4, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, true, false);
        this.mpCombo = uiFactory.createDropDownSelect((UIContainer)mpComposite);
        mpCompositeLayout.set(this.mpCombo, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.loadConfig();
    }

    public void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                SoundOption.this.mpList = TuxGuitar.getInstance().getPlayer().listOutputPorts();
                SoundOption.this.msList = TuxGuitar.getInstance().getPlayer().listSequencers();
                SoundOption.this.mpCurrentKey = SoundOption.this.getConfig().getStringValue("midi.port");
                SoundOption.this.msCurrentKey = SoundOption.this.getConfig().getStringValue("midi.sequencer");
                MidiSequencer sequencer = TuxGuitar.getInstance().getPlayer().getSequencer();
                MidiOutputPort outputPort = TuxGuitar.getInstance().getPlayer().getOutputPort();
                final String msLoaded = sequencer != null ? sequencer.getKey() : null;
                final String mpLoaded = outputPort != null ? outputPort.getKey() : null;
                TGSynchronizer.getInstance((TGContext)SoundOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (!SoundOption.this.isDisposed()) {
                            String loadedSequencer = msLoaded;
                            UISelectItem selectedSequencerItem = null;
                            for (MidiSequencer sequencer : SoundOption.this.msList) {
                                UISelectItem item = new UISelectItem(sequencer.getName(), (Object)sequencer);
                                SoundOption.this.msCombo.addItem(item);
                                if (SoundOption.this.msCurrentKey != null && SoundOption.this.msCurrentKey.equals(sequencer.getKey())) {
                                    loadedSequencer = null;
                                    selectedSequencerItem = item;
                                    continue;
                                }
                                if (loadedSequencer != null && loadedSequencer.equals(sequencer.getKey())) {
                                    selectedSequencerItem = item;
                                    continue;
                                }
                                if (selectedSequencerItem != null) continue;
                                selectedSequencerItem = item;
                            }
                            if (selectedSequencerItem != null) {
                                SoundOption.this.msCombo.setSelectedItem(selectedSequencerItem);
                            }
                            String loadedPort = mpLoaded;
                            UISelectItem selectedPortItem = null;
                            for (MidiOutputPort port : SoundOption.this.mpList) {
                                UISelectItem item = new UISelectItem(port.getName(), (Object)port);
                                SoundOption.this.mpCombo.addItem(item);
                                if (SoundOption.this.mpCurrentKey != null && SoundOption.this.mpCurrentKey.equals(port.getKey())) {
                                    loadedPort = null;
                                    selectedPortItem = item;
                                    continue;
                                }
                                if (loadedPort != null && loadedPort.equals(port.getKey())) {
                                    selectedPortItem = item;
                                    continue;
                                }
                                if (selectedPortItem != null) continue;
                                selectedPortItem = item;
                            }
                            if (selectedPortItem != null) {
                                SoundOption.this.mpCombo.setSelectedItem(selectedPortItem);
                            }
                            SoundOption.this.initialized = true;
                            SoundOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            MidiOutputPort midiPort;
            MidiSequencer midiSequencer = (MidiSequencer)this.msCombo.getSelectedValue();
            if (midiSequencer != null) {
                this.getConfig().setValue("midi.sequencer", midiSequencer.getKey());
            }
            if ((midiPort = (MidiOutputPort)this.mpCombo.getSelectedValue()) != null) {
                this.getConfig().setValue("midi.port", midiPort.getKey());
            }
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("midi.port", this.getDefaults().getValue("midi.port"));
            this.getConfig().setValue("midi.sequencer", this.getDefaults().getValue("midi.sequencer"));
        }
    }
}

