/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.lyric;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingActionManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.dialog.lyric.TGLyricModifyListener;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIEvent;
import org.herac.tuxguitar.ui.event.UIKeyEvent;
import org.herac.tuxguitar.ui.event.UIKeyPressedListener;
import org.herac.tuxguitar.ui.event.UIModifyListener;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIKeyConvination;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UITextArea;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGAbstractContext;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGLyricEditor
implements TGEventListener {
    public static final String ATTRIBUTE_BYPASS_EVENTS_FROM = "bypass-events-from";
    private static final float EDITOR_WIDTH = 450.0f;
    private static final float EDITOR_HEIGHT = 200.0f;
    private TGContext context;
    private TGTrack track;
    private UIWindow dialog;
    private TGLyricModifyListener listener;
    private UIButton previous;
    private UIButton next;
    private UILabel label;
    private UILabel fromLabel;
    private UISpinner from;
    private UITextArea text;
    private boolean updated;
    private int lastTrack;
    private int lastMeasuseCount;
    private String lastTrackName;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateItemsProcess;
    private List<KeyBindingAction> keyBindings;

    public TGLyricEditor(TGContext context) {
        this.context = context;
        this.listener = new TGLyricModifyListener(this);
        this.keyBindings = new ArrayList<KeyBindingAction>();
        this.createSyncProcesses();
    }

    public TGLyric createLyrics() {
        if (!this.isDisposed()) {
            TGLyric tgLyric = TGDocumentManager.getInstance((TGContext)this.context).getSongManager().getFactory().newLyric();
            tgLyric.setFrom(this.from.getValue());
            tgLyric.setLyrics(this.text.getText());
            return tgLyric;
        }
        return null;
    }

    public void show() {
        UIFactory uiFactory = this.getUIFactory();
        this.dialog = uiFactory.createWindow(TGWindow.getInstance(this.context).getWindow(), false, true);
        this.dialog.setLayout((UILayout)new UITableLayout(Float.valueOf(0.0f)));
        this.dialog.setBounds(new UIRectangle(0.0f, 0.0f, 450.0f, 200.0f));
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGLyricEditor.this.onDispose();
            }
        });
        this.track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
        this.loadComposites();
        this.loadProperties();
        this.loadIcons();
        this.updateItems();
        this.addListeners();
        TGDialogUtil.openDialog(this.dialog, 6);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public void onDispose() {
        this.track = null;
        this.label = null;
        this.text = null;
        this.dialog = null;
        this.removeListeners();
    }

    private void loadComposites() {
        this.loadToolBar();
        this.loadLyricText();
    }

    private void loadToolBar() {
        UIFactory uiFactory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = uiFactory.createPanel((UIContainer)this.dialog, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.previous = uiFactory.createButton((UIContainer)panel);
        panelLayout.set((UIControl)this.previous, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.next = uiFactory.createButton((UIContainer)panel);
        panelLayout.set((UIControl)this.next, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.label = uiFactory.createLabel((UIContainer)panel);
        this.label.setText(this.track.getName());
        panelLayout.set((UIControl)this.label, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.fromLabel = uiFactory.createLabel((UIContainer)panel);
        panelLayout.set((UIControl)this.fromLabel, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.from = uiFactory.createSpinner((UIContainer)panel);
        this.from.setMinimum(1);
        this.from.setMaximum(this.track.countMeasures());
        this.from.setValue(this.track.getLyrics().getFrom());
        this.from.setEnabled(this.track.countMeasures() > 1);
        this.from.addSelectionListener((UISelectionListener)this.listener);
        panelLayout.set((UIControl)this.from, Integer.valueOf(1), Integer.valueOf(5), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(60.0f), null, null);
        this.previous.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.track.go-previous"));
        this.next.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.track.go-next"));
    }

    private void loadLyricText() {
        UIFactory uiFactory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = uiFactory.createPanel((UIContainer)this.dialog, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.text = uiFactory.createTextArea((UIContainer)panel, true, false);
        this.text.setFocus();
        this.text.setText(this.track.getLyrics().getLyrics());
        this.text.addModifyListener((UIModifyListener)this.listener);
        this.text.addKeyPressedListener(new UIKeyPressedListener(){

            public void onKeyPressed(UIKeyEvent event) {
                for (KeyBindingAction keyBinding : TGLyricEditor.this.keyBindings) {
                    if (!event.getKeyConvination().equals((Object)keyBinding.getConvination())) continue;
                    new TGActionProcessorListener(TGLyricEditor.this.context, keyBinding.getAction()).processEvent((UIEvent)event);
                    return;
                }
            }
        });
        panelLayout.set((UIControl)this.text, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        panelLayout.set((UIControl)this.text, "packed_width", (Object)Float.valueOf(0.0f));
        panelLayout.set((UIControl)this.text, "packed_height", (Object)Float.valueOf(0.0f));
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            boolean enabled = !TuxGuitar.getInstance().getPlayer().isRunning();
            boolean doLayout = false;
            this.listener.setEnabled(false);
            if (this.updated) {
                this.lastTrack = 0;
                this.lastTrackName = null;
                this.lastMeasuseCount = 0;
            }
            this.track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
            if (this.isTrackNameChanged()) {
                doLayout = true;
                this.label.setText(this.track.getName());
            }
            if (this.isMeasureCountChanged()) {
                doLayout = true;
                this.from.setMaximum(this.track.countMeasures());
            }
            if (this.isTrackChanged() || this.isTrackLyricChanged()) {
                doLayout = true;
                this.from.setValue(this.track.getLyrics().getFrom());
                this.text.setText(this.track.getLyrics().getLyrics());
            }
            this.from.setEnabled(enabled && this.track.countMeasures() > 1);
            this.text.setEnabled(enabled);
            this.listener.setEnabled(enabled);
            this.updated = false;
            if (doLayout) {
                this.dialog.layout();
            }
        }
    }

    private boolean isTrackChanged() {
        int current = this.track.getNumber();
        if (current != this.lastTrack) {
            this.lastTrack = current;
            return true;
        }
        return false;
    }

    private boolean isTrackLyricChanged() {
        if (this.track.getLyrics().getFrom() != this.from.getValue()) {
            return true;
        }
        return !this.track.getLyrics().getLyrics().equals(this.text.getText());
    }

    private boolean isTrackNameChanged() {
        String current = this.track.getName();
        if (this.lastTrackName == null || !current.equals(this.lastTrackName)) {
            this.lastTrackName = current;
            return true;
        }
        return false;
    }

    private boolean isMeasureCountChanged() {
        int current = this.track.countMeasures();
        if (current != this.lastMeasuseCount) {
            this.lastMeasuseCount = current;
            return true;
        }
        return false;
    }

    public void update() {
        this.updated = true;
    }

    public TGTrack getTrack() {
        return this.track;
    }

    public TGContext getContext() {
        return this.context;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public void loadKeyBinding(String actionId) {
        UIKeyConvination keyConvination = KeyBindingActionManager.getInstance(this.context).getKeyBindingForAction(actionId);
        if (keyConvination != null) {
            this.keyBindings.add(new KeyBindingAction(actionId, keyConvination));
        }
    }

    public void loadKeyBindings() {
        if (!this.isDisposed()) {
            this.keyBindings.clear();
            this.loadKeyBinding("action.edit.undo");
            this.loadKeyBinding("action.edit.redo");
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.loadKeyBindings();
            this.dialog.setText(TuxGuitar.getProperty("lyric.editor"));
            this.fromLabel.setText(TuxGuitar.getProperty("edit.from"));
            this.dialog.layout();
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.previous.setImage(TuxGuitar.getInstance().getIconManager().getArrowLeft());
            this.next.setImage(TuxGuitar.getInstance().getIconManager().getArrowRight());
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public boolean isByPassEvent(TGEvent event) {
        Object owner;
        TGAbstractContext context = (TGAbstractContext)event.getAttribute("sourceContext");
        return context != null && (owner = context.getAttribute(ATTRIBUTE_BYPASS_EVENTS_FROM)) != null && owner.equals(this);
    }

    public void createSyncProcesses() {
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGLyricEditor.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGLyricEditor.this.loadIcons();
            }
        });
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGLyricEditor.this.updateItems();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        if (!this.isByPassEvent(event)) {
            int type = (Integer)event.getAttribute("updateMode");
            if (type == 1) {
                this.updateItemsProcess.process();
            } else if (type == 3 || type == 4) {
                this.update();
            }
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TGLyricEditor getInstance(TGContext context) {
        return (TGLyricEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TGLyricEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGLyricEditor>(){

            public TGLyricEditor createInstance(TGContext context) {
                return new TGLyricEditor(context);
            }
        });
    }
}

