/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.component.tab.TablatureStyles;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLayoutHorizontal;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.graphics.control.TGLayoutVertical;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.util.TGContext;

public class Tablature
implements TGController {
    public static final Float DEFAULT_SCALE = Float.valueOf(1.0f);
    private TGContext context;
    private UIResourceFactory resourceFactory;
    private TGDocumentManager documentManager;
    private TGResourceBuffer resourceBuffer;
    private TGSyncProcess disposeUnregisteredResources;
    private Caret caret;
    private TGLayout viewLayout;
    private EditorKit editorKit;
    private Float scale;

    public Tablature(TGContext context, TGDocumentManager documentManager) {
        this.context = context;
        this.documentManager = documentManager;
        this.scale = DEFAULT_SCALE;
        this.caret = new Caret(this);
        this.editorKit = new EditorKit(this);
        this.createSyncProcesses();
    }

    public void createSyncProcesses() {
        this.disposeUnregisteredResources = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                Tablature.this.getResourceBuffer().disposeUnregisteredResources();
            }
        });
    }

    public void updateTablature() {
        this.getViewLayout().updateSong();
        this.getCaret().update();
        this.disposeUnregisteredResources.process();
    }

    public void updateMeasure(int number) {
        this.getViewLayout().updateMeasureNumber(number);
        this.getCaret().update();
        this.disposeUnregisteredResources.process();
    }

    public void resetCaret() {
        this.caret.update(1, 960L, 1);
    }

    public void paintTablature(UIPainter painter, UIRectangle area, float fromX, float fromY) {
        this.getViewLayout().fillBackground(painter, area);
        this.getViewLayout().paint(painter, area, fromX, fromY);
        this.getCaret().paintCaret(this.getViewLayout(), painter);
        this.getEditorKit().paintSelection(this.getViewLayout(), painter);
    }

    public Float getScale() {
        return this.scale;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public TGContext getContext() {
        return this.context;
    }

    public TGSongManager getSongManager() {
        return this.documentManager.getSongManager();
    }

    public TGSong getSong() {
        return this.documentManager.getSong();
    }

    public TGLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(TGLayout viewLayout) {
        if (this.getViewLayout() != null) {
            this.getViewLayout().disposeLayout();
        }
        this.viewLayout = viewLayout;
        this.reloadStyles();
    }

    public void reloadStyles() {
        if (this.getViewLayout() != null) {
            this.getViewLayout().loadStyles(this.scale.floatValue());
        }
        this.loadCaretStyles();
    }

    public void reloadViewLayout() {
        TGConfigManager config = TGConfigManager.getInstance(this.context);
        this.loadViewLayout(config.getIntegerValue("layout.style"), config.getIntegerValue("layout.mode"));
    }

    private void loadViewLayout(int style, int mode) {
        switch (mode) {
            case 1: {
                this.setViewLayout((TGLayout)new TGLayoutVertical((TGController)this, style));
                break;
            }
            case 2: {
                this.setViewLayout((TGLayout)new TGLayoutHorizontal((TGController)this, style));
                break;
            }
            default: {
                if (mode == 2) break;
                this.loadViewLayout(style, 2);
            }
        }
    }

    public void loadCaretStyles() {
        TGConfigManager config = TGConfigManager.getInstance(this.context);
        this.getCaret().setColor1(config.getColorModelConfigValue("color.caret.1"));
        this.getCaret().setColor2(config.getColorModelConfigValue("color.caret.2"));
    }

    public void scale(Float scale) {
        if (!this.scale.equals(scale)) {
            this.scale = scale != null ? scale : DEFAULT_SCALE;
            this.reloadStyles();
        }
    }

    public void dispose() {
        this.getCaret().dispose();
        this.getViewLayout().disposeLayout();
        this.getResourceBuffer().disposeAllResources();
    }

    public UIResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = TGApplication.getInstance(this.context).getFactory();
        }
        return this.resourceFactory;
    }

    public TGResourceBuffer getResourceBuffer() {
        if (this.resourceBuffer == null) {
            this.resourceBuffer = new TGResourceBuffer();
        }
        return this.resourceBuffer;
    }

    public int getTrackSelection() {
        if ((this.getViewLayout().getStyle() & 2) == 0) {
            return this.getCaret().getTrack().getNumber();
        }
        return -1;
    }

    public boolean isRunning(TGBeat beat) {
        return this.isRunning(beat.getMeasure()) && TuxGuitar.getInstance().getEditorCache().isPlaying(beat.getMeasure(), beat);
    }

    public boolean isRunning(TGMeasure measure) {
        return measure.getTrack().equals(this.getCaret().getTrack()) && TuxGuitar.getInstance().getEditorCache().isPlaying(measure);
    }

    public boolean isLoopSHeader(TGMeasureHeader measureHeader) {
        MidiPlayerMode pm = TuxGuitar.getInstance().getPlayer().getMode();
        return pm.isLoop() && pm.getLoopSHeader() == measureHeader.getNumber();
    }

    public boolean isLoopEHeader(TGMeasureHeader measureHeader) {
        MidiPlayerMode pm = TuxGuitar.getInstance().getPlayer().getMode();
        return pm.isLoop() && pm.getLoopEHeader() == measureHeader.getNumber();
    }

    public TGLayoutStyles getStyles() {
        return new TablatureStyles(TGConfigManager.getInstance(this.context));
    }
}

