/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.browser.filesystem;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowser;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserCallBack;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserElement;
import org.herac.tuxguitar.app.tools.browser.filesystem.TGBrowserElementComparator;
import org.herac.tuxguitar.app.tools.browser.filesystem.TGBrowserElementImpl;
import org.herac.tuxguitar.app.tools.browser.filesystem.TGBrowserSettingsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGBrowserImpl
implements TGBrowser {
    private File root;
    private TGBrowserElementImpl element;
    private TGBrowserSettingsModel data;

    public TGBrowserImpl(TGBrowserSettingsModel data) {
        this.data = data;
    }

    @Override
    public void open(TGBrowserCallBack<Object> cb) {
        try {
            this.root = new File(this.data.getPath());
            cb.onSuccess(null);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    @Override
    public void close(TGBrowserCallBack<Object> cb) {
        try {
            this.root = null;
            cb.onSuccess(null);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    @Override
    public void cdElement(TGBrowserCallBack<Object> cb, TGBrowserElement element) {
        try {
            this.element = (TGBrowserElementImpl)element;
            cb.onSuccess(this.element);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    @Override
    public void cdRoot(TGBrowserCallBack<Object> cb) {
        try {
            this.element = null;
            cb.onSuccess(this.element);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    @Override
    public void cdUp(TGBrowserCallBack<Object> cb) {
        try {
            if (this.element != null) {
                this.element = this.element.getParent();
            }
            cb.onSuccess(this.element);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    @Override
    public void listElements(TGBrowserCallBack<List<TGBrowserElement>> cb) {
        try {
            File file;
            ArrayList<TGBrowserElementImpl> elements = new ArrayList<TGBrowserElementImpl>();
            File file2 = file = this.element != null ? this.element.getFile() : this.root;
            if (file.exists() && file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    elements.add(new TGBrowserElementImpl(this.element, files[i]));
                }
            }
            if (!elements.isEmpty()) {
                Collections.sort(elements, new TGBrowserElementComparator());
            }
            cb.onSuccess(elements);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    @Override
    public void getInputStream(TGBrowserCallBack<InputStream> cb, TGBrowserElement element) {
        try {
            cb.onSuccess(((TGBrowserElementImpl)element).getInputStream());
        }
        catch (Throwable e) {
            cb.handleError(e);
        }
    }
}

