/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.document;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.document.TGDocument;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.editor.undo.TGUndoableBuffer;
import org.herac.tuxguitar.editor.undo.TGUndoableManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGDocumentListManager {
    private TGContext context;
    private List<TGDocument> documents;

    public TGDocumentListManager(TGContext context) {
        this.context = context;
        this.documents = new ArrayList<TGDocument>();
    }

    public List<TGDocument> getDocuments() {
        return this.documents;
    }

    public List<TGDocument> findUnwantedDocumentsToRemove() {
        ArrayList<TGDocument> documents = new ArrayList<TGDocument>();
        for (TGDocument document : this.documents) {
            if (!document.isUnwanted() || document.isUnsaved()) continue;
            documents.add(document);
        }
        return documents;
    }

    public void removeUnwantedDocument() {
        List<TGDocument> documentsToRemove = this.findUnwantedDocumentsToRemove();
        for (TGDocument documentToRemove : documentsToRemove) {
            if (this.documents.size() <= 1) continue;
            this.documents.remove(documentToRemove);
        }
    }

    public void updateLoadedDocument() {
        TGSong song = this.getLoadedSong();
        TGDocument document = this.findDocument(song);
        this.removeUnwantedDocument();
        TGUndoableManager.getInstance((TGContext)this.context).setBuffer(document.getUndoableBuffer());
    }

    public TGDocument findDocument(TGSong song) {
        for (TGDocument document : this.documents) {
            if (!document.getSong().equals(song)) continue;
            return document;
        }
        TGDocument document = new TGDocument();
        document.setSong(song);
        document.setUndoableBuffer(new TGUndoableBuffer());
        document.setUnsaved(false);
        document.setUnwanted(false);
        this.documents.add(document);
        return this.findDocument(song);
    }

    public TGDocument findCurrentDocument() {
        return this.findDocument(this.getLoadedSong());
    }

    public int findDocumentIndex(TGDocument document) {
        return this.documents.indexOf(document);
    }

    public int findCurrentDocumentIndex() {
        TGDocument current = this.findCurrentDocument();
        return current != null ? this.findDocumentIndex(current) : -1;
    }

    public TGSong getLoadedSong() {
        return TGDocumentManager.getInstance((TGContext)this.context).getSong();
    }

    public String getDocumentName(TGDocument document) {
        String decodedFileName;
        if (document.getUri() != null && (decodedFileName = TGFileUtils.getDecodedFileName(document.getUri())) != null) {
            return decodedFileName;
        }
        return "Untitled.tg";
    }

    public void removeDocument(TGDocument document) {
        this.documents.remove(document);
    }

    public void removeDocuments(List<TGDocument> documents) {
        this.documents.removeAll(documents);
    }

    public int countDocuments() {
        return this.documents.size();
    }

    public boolean containsDocument(TGDocument document) {
        return this.documents.contains(document);
    }

    public static TGDocumentListManager getInstance(TGContext context) {
        return (TGDocumentListManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGDocumentListManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGDocumentListManager>(){

            public TGDocumentListManager createInstance(TGContext context) {
                return new TGDocumentListManager(context);
            }
        });
    }
}

