/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableClef
extends TGUndoableEditBase {
    private int doAction;
    private long position;
    private int redoableClef;
    private int undoableClef;
    private List<Object> nextClefPositions;
    private boolean toEnd;
    private TGTrack track;

    private TGUndoableClef(TGContext context) {
        super(context);
    }

    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeClef(actionContext, this.track, this.getMeasureAt(this.track, this.position), this.redoableClef, this.toEnd);
        this.doAction = 1;
    }

    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeClef(actionContext, this.track, this.getMeasureAt(this.track, this.position), this.undoableClef, this.toEnd);
        if (this.toEnd) {
            for (ClefPosition clefPosition : this.nextClefPositions) {
                this.changeClef(actionContext, this.track, this.getMeasureAt(this.track, clefPosition.getPosition()), clefPosition.getClef(), true);
            }
        }
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableClef startUndo(TGContext context, TGTrack track, TGMeasure measure) {
        TGUndoableClef undoable = new TGUndoableClef(context);
        undoable.doAction = 1;
        undoable.position = measure.getStart();
        undoable.undoableClef = measure.getClef();
        undoable.track = track;
        undoable.nextClefPositions = new ArrayList<Object>();
        int prevClef = undoable.undoableClef;
        Iterator it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure nextMeasure = (TGMeasure)it.next();
            if (nextMeasure.getStart() <= undoable.position) continue;
            int currClef = nextMeasure.getClef();
            if (prevClef != currClef) {
                ClefPosition tsp = new ClefPosition(nextMeasure.getStart(), currClef);
                undoable.nextClefPositions.add(tsp);
            }
            prevClef = currClef;
        }
        return undoable;
    }

    public TGUndoableClef endUndo(int clef, boolean toEnd) {
        this.redoableClef = clef;
        this.toEnd = toEnd;
        return this;
    }

    public TGMeasure getMeasureAt(TGTrack track, Long start) {
        return this.getSongManager().getTrackManager().getMeasureAt(track, start.longValue());
    }

    public void changeClef(TGActionContext context, TGTrack track, TGMeasure measure, Integer clef, Boolean applyToEnd) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.composition.change-clef");
        tgActionProcessor.setAttribute("clef", clef);
        tgActionProcessor.setAttribute("applyToEnd", applyToEnd);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, measure);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    private static class ClefPosition {
        private long position;
        private int clef;

        public ClefPosition(long position, int clef) {
            this.position = position;
            this.clef = clef;
        }

        public long getPosition() {
            return this.position;
        }

        public int getClef() {
            return this.clef;
        }
    }
}

