/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.composition;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGRepeatAlternativeAction
extends TGActionBase {
    public static final String NAME = "action.insert.close-alternative";
    public static final String ATTRIBUTE_REPEAT_ALTERNATIVE = "repeatAlternative";

    public TGRepeatAlternativeAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        TGSongManager songManager = this.getSongManager(context);
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGMeasureHeader measureHeader = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        int repeatAlternative = (Integer)context.getAttribute(ATTRIBUTE_REPEAT_ALTERNATIVE);
        if (repeatAlternative != measureHeader.getRepeatAlternative()) {
            TGMeasureHeader previousHeader;
            boolean previousRepeatClose = measureHeader.getRepeatAlternative() == 0 && (repeatAlternative & 1) == 0;
            songManager.changeAlternativeRepeat(song, measureHeader.getStart(), repeatAlternative);
            if (previousRepeatClose && (previousHeader = songManager.getMeasureHeader(song, measureHeader.getNumber() - 1)) != null && previousHeader.getRepeatClose() == 0) {
                context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)previousHeader);
                context.setAttribute("repeatCount", (Object)1);
                TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
                tgActionManager.execute("action.insert.close-repeat", context);
                context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)measureHeader);
            }
        }
    }
}

