/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.widget;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractScrollArea;
import com.trolltech.qt.gui.QContentsMargins;
import com.trolltech.qt.gui.QScrollBar;
import com.trolltech.qt.gui.QWidget;
import org.herac.tuxguitar.ui.qt.widget.QTAbstractPanel;
import org.herac.tuxguitar.ui.qt.widget.QTContainer;
import org.herac.tuxguitar.ui.qt.widget.QTScrollBar;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UIScrollBar;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTScrollBarPanel
extends QTAbstractPanel<QAbstractScrollArea>
implements UIScrollBarPanel {
    private QTScrollBar vScrollBar;
    private QTScrollBar hScrollBar;

    public QTScrollBarPanel(QTContainer parent, boolean vScroll, boolean hScroll, boolean bordered) {
        super(new QAbstractScrollArea(parent.getContainerControl()), parent, bordered);
        ((QAbstractScrollArea)this.getControl()).setViewport(new QWidget());
        if (vScroll) {
            ((QAbstractScrollArea)this.getControl()).setVerticalScrollBarPolicy(Qt.ScrollBarPolicy.ScrollBarAlwaysOn);
            this.vScrollBar = new QTScrollBar(((QAbstractScrollArea)this.getControl()).verticalScrollBar(), null);
        }
        if (hScroll) {
            ((QAbstractScrollArea)this.getControl()).setHorizontalScrollBarPolicy(Qt.ScrollBarPolicy.ScrollBarAlwaysOn);
            this.hScrollBar = new QTScrollBar(((QAbstractScrollArea)this.getControl()).horizontalScrollBar(), null);
        }
    }

    @Override
    public QWidget getContainerControl() {
        return ((QAbstractScrollArea)this.getControl()).viewport();
    }

    public UIScrollBar getHScroll() {
        return this.hScrollBar;
    }

    public UIScrollBar getVScroll() {
        return this.vScrollBar;
    }

    @Override
    public void computeMargins() {
        super.computeMargins();
        QContentsMargins margins = ((QAbstractScrollArea)this.getControl()).getContentsMargins();
        QContentsMargins containerMargins = new QContentsMargins(margins.left, margins.top, margins.right, margins.bottom);
        if (this.vScrollBar != null) {
            containerMargins.right += ((QScrollBar)this.vScrollBar.getControl()).sizeHint().width();
        }
        if (this.hScrollBar != null) {
            containerMargins.bottom += ((QScrollBar)this.hScrollBar.getControl()).sizeHint().height();
        }
        this.setContainerMargins(containerMargins);
    }

    @Override
    public void setBounds(UIRectangle bounds) {
        QContentsMargins margins = this.getContainerMargins();
        int viewPortWidth = Math.round(bounds.getWidth()) - (margins.left + margins.right);
        int viewPortHeight = Math.round(bounds.getHeight()) - (margins.top + margins.bottom);
        ((QAbstractScrollArea)this.getControl()).viewport().resize(viewPortWidth, viewPortHeight);
        super.setBounds(bounds);
    }
}

