/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.widget;

import com.trolltech.qt.gui.QContentsMargins;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QScrollBar;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.qt.event.QTSelectionListenerManager;
import org.herac.tuxguitar.ui.qt.widget.QTContainer;
import org.herac.tuxguitar.ui.qt.widget.QTWidget;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIListBoxSelect;
import org.herac.tuxguitar.ui.widget.UISelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTListBoxSelect<T>
extends QTWidget<QListWidget>
implements UIListBoxSelect<T> {
    private List<UISelectItem<T>> items;
    private QTSelectionListenerManager selectionListener = new QTSelectionListenerManager(this);

    public QTListBoxSelect(QTContainer parent) {
        super(new QListWidget(parent.getContainerControl()), parent);
        this.items = new ArrayList<UISelectItem<T>>();
    }

    public T getSelectedValue() {
        UISelectItem<T> selectedItem = this.getSelectedItem();
        return (T)(selectedItem != null ? selectedItem.getValue() : null);
    }

    public void setSelectedValue(T value) {
        this.setSelectedItem(new UISelectItem(null, value));
    }

    public UISelectItem<T> getSelectedItem() {
        int index = ((QListWidget)this.getControl()).currentRow();
        return index >= 0 && index < this.items.size() ? this.items.get(index) : null;
    }

    public void setSelectedItem(UISelectItem<T> item) {
        int index = item != null ? this.items.indexOf(item) : -1;
        ((QListWidget)this.getControl()).setCurrentRow(index);
    }

    public void addItem(UISelectItem<T> item) {
        this.items.add(item);
        ((QListWidget)this.getControl()).addItem(item.getText());
    }

    public void removeItem(UISelectItem<T> item) {
        int index;
        int n = index = item != null ? this.items.indexOf(item) : -1;
        if (index >= 0 && index < this.items.size()) {
            this.items.remove(item);
            QListWidgetItem widgetItem = ((QListWidget)this.getControl()).item(index);
            if (widgetItem != null) {
                widgetItem.dispose();
            }
        }
    }

    public void removeItems() {
        this.items.clear();
        ((QListWidget)this.getControl()).clear();
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public void computePackedSize() {
        QScrollBar vScroll;
        QContentsMargins margins = ((QListWidget)this.getControl()).getContentsMargins();
        float width = margins.left + margins.right;
        float height = margins.top + margins.bottom;
        if (!this.items.isEmpty()) {
            width += (float)((QListWidget)this.getControl()).sizeHintForColumn(0);
            for (int i = 0; i < this.items.size(); ++i) {
                height += (float)((QListWidget)this.getControl()).sizeHintForRow(i);
            }
        }
        if ((vScroll = ((QListWidget)this.getControl()).verticalScrollBar()) != null && vScroll.isEnabled()) {
            width += (float)vScroll.sizeHint().width();
        }
        this.setPackedSize(new UISize(width, height));
    }

    public void addSelectionListener(UISelectionListener listener) {
        if (this.selectionListener.isEmpty()) {
            ((QListWidget)this.getControl()).currentRowChanged.connect((Object)this.selectionListener, "handle()");
        }
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
        if (this.selectionListener.isEmpty()) {
            ((QListWidget)this.getControl()).currentRowChanged.disconnect();
        }
    }
}

