/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.event;

import com.trolltech.qt.core.QEvent;
import com.trolltech.qt.core.QObject;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.ui.qt.event.QTEventHandler;
import org.herac.tuxguitar.ui.qt.event.QTEventMap;

public class QTEventFilter
extends QObject {
    private boolean ignoreEvents;
    private List<QTEventMap> eventsMap = new ArrayList<QTEventMap>();

    public void setIgnoreEvents(boolean ignoreEvents) {
        this.ignoreEvents = ignoreEvents;
    }

    public void connect(QEvent.Type eventType, QTEventHandler eventHandler) {
        this.eventsMap.add(new QTEventMap(eventType, eventHandler));
    }

    public void disconnect(QEvent.Type eventType, QTEventHandler eventHandler) {
        QTEventMap eventMap = this.findEventMap(eventType, eventHandler);
        if (eventMap != null) {
            this.eventsMap.remove(eventMap);
        }
    }

    public QTEventMap findEventMap(QEvent.Type eventType, QTEventHandler eventHandler) {
        for (QTEventMap map : this.eventsMap) {
            if (!map.getEventType().equals((Object)eventType) || !map.getEventHandler().equals(eventHandler)) continue;
            return map;
        }
        return null;
    }

    public boolean eventFilter(QObject obj, QEvent event) {
        boolean success = false;
        if (!this.ignoreEvents) {
            for (QTEventMap map : this.eventsMap) {
                if (!map.getEventType().equals((Object)event.type()) || !map.getEventHandler().handle(event)) continue;
                success = true;
            }
        }
        return success || super.eventFilter(obj, event);
    }
}

