/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.vst.remote;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.midi.synth.TGAudioBuffer;
import org.herac.tuxguitar.midi.synth.TGAudioProcessor;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.VSTEffect;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.VSTParamsEvent;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.VSTServer;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSTAudioProcessor
implements TGAudioProcessor {
    public static final int BUFFER_SIZE = 512;
    public static final float SAMPLE_RATE = 44100.0f;
    public static final String PARAM_FILE_NAME = "vst.filename";
    public static final String PARAM_PREFIX = "vst.param.";
    private Object lock = new Object();
    private TGContext context;
    private VSTEffect effect;
    private File file;
    private List<byte[]> messages;
    private float[][] inputs;
    private float[][] outputs;

    public VSTAudioProcessor(TGContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                try {
                    this.file = file;
                    this.effect = new VSTEffect(VSTServer.getInstance(this.context).createSession(this.file.getAbsolutePath()));
                    this.effect.setBlockSize(512);
                    this.effect.setSampleRate(44100.0f);
                    this.effect.setActive(true);
                    this.messages = new ArrayList<byte[]>();
                    this.inputs = new float[this.effect.getNumInputs()][512];
                    this.outputs = new float[this.effect.getNumOutputs()][512];
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.effect.setActive(false);
                this.effect.closeNativeEditor();
                this.effect.close();
                this.effect = null;
                this.file = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMidiMessage(byte[] midiMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.messages.add(midiMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBuffer(TGAudioBuffer buffer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.processMessages();
                this.processReplacing(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessages() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen() && !this.messages.isEmpty()) {
                this.effect.sendMessages(this.messages);
                this.messages.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReplacing(TGAudioBuffer buffer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.inputs.length > 0) {
                    buffer.read(this.inputs);
                }
                this.effect.sendProcessReplacing(this.inputs, this.outputs, 512);
                if (this.outputs.length > 0) {
                    buffer.write(this.outputs);
                }
            }
        }
    }

    public void restoreParameters(Map<String, String> parameters) {
        if (!this.isOpen() && parameters.containsKey(PARAM_FILE_NAME)) {
            this.open(new File(parameters.get(PARAM_FILE_NAME)));
        }
        if (this.isOpen()) {
            int paramCount = this.getEffect().getNumParams();
            for (int i = 0; i < paramCount; ++i) {
                String key = PARAM_PREFIX + i;
                if (!parameters.containsKey(key)) continue;
                this.getEffect().setParameter(i, Float.parseFloat(parameters.get(key)));
            }
            this.fireParamsEvent(VSTParamsEvent.ACTION_RESTORE, parameters);
        }
    }

    public void storeParameters(Map<String, String> parameters) {
        if (this.isOpen()) {
            parameters.put(PARAM_FILE_NAME, this.file.getAbsolutePath());
            int paramCount = this.getEffect().getNumParams();
            for (int i = 0; i < paramCount; ++i) {
                parameters.put(PARAM_PREFIX + i, Float.toString(this.getEffect().getParameter(i)));
            }
            this.fireParamsEvent(VSTParamsEvent.ACTION_STORE, parameters);
        }
    }

    public void fireParamsEvent(Integer action, Map<String, String> parameters) {
        if (this.isOpen()) {
            TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new VSTParamsEvent(this.getEffect().getSession(), action, parameters));
        }
    }

    public VSTEffect getEffect() {
        return this.effect;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isOpen() {
        return this.effect != null && !this.effect.isClosed();
    }

    public boolean isBusy() {
        return false;
    }
}

