/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 32768);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, shell == null ? n : FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean bl;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l = OS.gtk_font_selection_dialog_new(byArray);
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(l, 2);
            OS.gtk_container_forall(l, display.setDirectionProc, 2L);
        }
        if (this.parent != null) {
            long l2 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(l, l2);
            long l3 = OS.gtk_window_get_icon_list(l2);
            if (l3 != 0L) {
                OS.gtk_window_set_icon_list(l, l3);
                OS.g_list_free(l3);
            }
        }
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            long l4 = OS.pango_font_description_to_string(font.handle);
            int n = OS.strlen(l4);
            byte[] byArray2 = new byte[n + 1];
            OS.memmove(byArray2, l4, (long)n);
            font.dispose();
            OS.g_free(l4);
            OS.gtk_font_selection_dialog_set_font_name(l, byArray2);
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(l)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = OS.gtk_dialog_run(l);
        if (OS.gtk_window_get_modal(l)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n == -5;
        if (bl) {
            long l5 = OS.gtk_font_selection_dialog_get_font_name(l);
            int n2 = OS.strlen(l5);
            byte[] byArray3 = new byte[n2 + 1];
            OS.memmove(byArray3, l5, (long)n2);
            OS.g_free(l5);
            long l6 = OS.pango_font_description_from_string(byArray3);
            Font font = Font.gtk_new(display, l6);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(l6);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l);
        if (!bl) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

