/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkCombo;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    long buttonHandle;
    long entryHandle;
    long listHandle;
    long textRenderer;
    long cellHandle;
    long popupHandle;
    int lastEventTime;
    int visibleCount = 5;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    boolean ignoreSelect;
    boolean lockText;
    static final int INNER_BORDER = 2;
    public static final int LIMIT = 65535;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n < 0 || n > this.items.length) {
            this.error(6);
        }
        String[] stringArray = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, stringArray, 0, n);
        stringArray[n] = string;
        System.arraycopy(this.items, n, stringArray, n + 1, this.items.length - n);
        this.items = stringArray;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_combo_box_insert_text(this.handle, n, byArray);
            if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
            }
        } else {
            this.lockText = true;
            this.ignoreSelect = true;
            long l = OS.gtk_list_item_new_with_label(byArray);
            long l2 = OS.gtk_bin_get_child(l);
            this.setForegroundColor(l2, this.getForegroundColor());
            OS.gtk_widget_modify_font(l2, this.getFontDescription());
            OS.gtk_widget_set_direction(l2, OS.gtk_widget_get_direction(this.handle));
            OS.gtk_widget_show(l);
            long l3 = OS.g_list_append(0L, l);
            OS.gtk_list_insert_items(this.listHandle, l3, n);
            this.lockText = false;
            this.ignoreSelect = false;
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            int n = OS.gtk_editable_get_position(this.entryHandle);
            OS.gtk_editable_select_region(this.entryHandle, n, n);
        }
    }

    void clearText() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            if ((this.style & 8) != 0) {
                int n = OS.gtk_combo_box_get_active(this.handle);
                if (n != -1) {
                    long l = OS.gtk_combo_box_get_model(this.handle);
                    long[] lArray = new long[1];
                    long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    OS.gtk_tree_model_iter_nth_child(l, l2, 0L, n);
                    OS.gtk_tree_model_get(l, l2, 0, lArray, -1L);
                    OS.g_free(l2);
                    if (lArray[0] != 0L && OS.strlen(lArray[0]) > 0) {
                        this.postEvent(24);
                    }
                    OS.g_free(lArray[0]);
                }
            } else {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            OS.gtk_combo_box_set_active(this.handle, -1);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return this.computeNativeSize(this.handle, n, n2, bl);
        }
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.entryHandle);
        long l = OS.gtk_entry_get_layout(this.entryHandle);
        OS.pango_layout_get_size(l, nArray, nArray2);
        int n3 = 2;
        int n4 = 2;
        long l2 = OS.gtk_widget_get_style(this.entryHandle);
        n3 += OS.gtk_style_get_xthickness(l2);
        n4 += OS.gtk_style_get_ythickness(l2);
        int[] nArray3 = new int[1];
        OS.gtk_widget_style_get(this.entryHandle, OS.interior_focus, nArray3, 0L);
        if (nArray3[0] == 0) {
            OS.gtk_widget_style_get(this.entryHandle, OS.focus_line_width, nArray3, 0L);
            n3 += nArray3[0];
            n4 += nArray3[0];
        }
        int n5 = OS.PANGO_PIXELS(nArray[0]) + n3 * 2;
        int n6 = OS.PANGO_PIXELS(nArray2[0]) + n4 * 2;
        GtkRequisition gtkRequisition = new GtkRequisition();
        OS.gtk_widget_size_request(this.buttonHandle, gtkRequisition);
        GtkRequisition gtkRequisition2 = new GtkRequisition();
        long l3 = OS.gtk_widget_get_parent(this.listHandle);
        OS.gtk_widget_size_request(l3 != 0L ? l3 : this.listHandle, gtkRequisition2);
        n5 = Math.max(gtkRequisition2.width, n5) + gtkRequisition.width + 4;
        n5 = n == -1 ? n5 : n;
        n6 = n2 == -1 ? n6 : n2;
        return new Point(n5, n6);
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_copy_clipboard(this.entryHandle);
        }
    }

    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            long l = OS.gtk_window_list_toplevels();
            if ((this.style & 8) != 0) {
                this.handle = OS.gtk_combo_box_new_text();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.cellHandle = OS.gtk_bin_get_child(this.handle);
                if (this.cellHandle == 0L) {
                    this.error(2);
                }
            } else {
                this.handle = OS.gtk_combo_box_entry_new_text();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.entryHandle = OS.gtk_bin_get_child(this.handle);
                if (this.entryHandle == 0L) {
                    this.error(2);
                }
            }
            this.popupHandle = this.findPopupHandle(l);
            OS.gtk_container_add(this.fixedHandle, this.handle);
            this.textRenderer = OS.gtk_cell_renderer_text_new();
            if (this.textRenderer == 0L) {
                this.error(2);
            }
            int n2 = 0;
            if (OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
                n2 = 1;
            }
            OS.g_object_set(this.textRenderer, OS.ypad, n2, 0L);
            boolean bl = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.gtk_cell_layout_clear(this.handle);
            this.display.setWarnings(bl);
            OS.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
            OS.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0L);
            OS.gtk_container_forall(this.handle, this.display.allChildrenProc, 0L);
            if (this.display.allChildren != 0L) {
                long l2 = this.display.allChildren;
                while (l2 != 0L) {
                    long l3 = OS.g_list_data(l2);
                    if (OS.GTK_IS_BUTTON(l3)) {
                        this.buttonHandle = l3;
                        break;
                    }
                    l2 = OS.g_list_next(l2);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
            if ((this.style & 8) != 0 && this.buttonHandle != 0L) {
                OS.GTK_WIDGET_UNSET_FLAGS(this.buttonHandle, 0x100000);
            }
        } else {
            long l;
            long l4;
            this.handle = OS.gtk_combo_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            GtkCombo gtkCombo = new GtkCombo();
            OS.memmove(gtkCombo, this.handle);
            this.entryHandle = gtkCombo.entry;
            this.listHandle = gtkCombo.list;
            if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
                l4 = 0L;
                long l5 = this.listHandle;
                while ((l5 = OS.gtk_widget_get_parent(l5)) != 0L) {
                    l4 = l5;
                }
                this.popupHandle = l4;
                if (this.popupHandle != 0L && (l = this.getShell().modalGroup) != 0L) {
                    OS.gtk_window_group_add_window(l, this.popupHandle);
                }
            }
            if ((l4 = OS.gtk_container_get_children(this.handle)) != 0L) {
                int n3 = 0;
                int n4 = OS.g_list_length(l4);
                while (n3 < n4) {
                    l = OS.g_list_nth_data(l4, n3);
                    if (l != this.entryHandle && l != this.listHandle) {
                        this.buttonHandle = l;
                        break;
                    }
                    ++n3;
                }
                OS.g_list_free(l4);
            }
            boolean bl = (this.style & 8) == 0;
            OS.gtk_editable_set_editable(this.entryHandle, bl);
            OS.gtk_combo_disable_activate(this.handle);
            OS.gtk_combo_set_case_sensitive(this.handle, true);
        }
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_cut_clipboard(this.entryHandle);
        }
    }

    void deregister() {
        long l;
        super.deregister();
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0L) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.listHandle != 0L) {
            this.display.removeWidget(this.listHandle);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.removeWidget(l);
        }
    }

    boolean filterKey(int n, long l) {
        int n2 = OS.gdk_event_get_time(l);
        if (n2 != this.lastEventTime) {
            this.lastEventTime = n2;
            long l2 = this.imContext();
            if (l2 != 0L) {
                return OS.gtk_im_context_filter_keypress(l2, l);
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    long findPopupHandle(long l) {
        long l2 = 0L;
        long l3 = OS.gtk_window_list_toplevels();
        long l4 = l;
        long l5 = l3;
        while (l5 != 0L) {
            long l6 = OS.g_list_data(l5);
            boolean bl = false;
            l4 = l;
            while (l4 != 0L) {
                long l7 = OS.g_list_data(l4);
                if (l6 == l7) {
                    bl = true;
                    break;
                }
                l4 = OS.g_list_next(l4);
            }
            if (!bl) {
                l2 = l6;
                break;
            }
            l5 = OS.g_list_next(l5);
        }
        OS.g_list_free(l);
        OS.g_list_free(l3);
        return l2;
    }

    void fixModal(long l, long l2) {
        if (this.popupHandle != 0L) {
            if (l != 0L) {
                OS.gtk_window_group_add_window(l, this.popupHandle);
            } else if (l2 != 0L) {
                OS.gtk_window_group_remove_window(l2, this.popupHandle);
            }
        }
    }

    void fixIM() {
        long l;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (l = this.imContext()) != 0L) {
            OS.gtk_im_context_filter_keypress(l, this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    long fontHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    long focusHandle() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (this.style & 8) != 0 && this.buttonHandle != 0L) {
            return this.buttonHandle;
        }
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        if (this.entryHandle != 0L && OS.GTK_WIDGET_HAS_FOCUS(this.entryHandle)) {
            return true;
        }
        return this.listHandle != 0L && OS.GTK_WIDGET_HAS_FOCUS(this.listHandle);
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
        }
        if (this.entryHandle != 0L) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.closures[6], true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.closures[26], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.closures[13], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.closures[1], false);
        }
        int n = 772;
        long[] lArray = new long[]{this.buttonHandle, this.entryHandle, this.listHandle};
        int n2 = 0;
        while (n2 < lArray.length) {
            long l = lArray[n2];
            if (l != 0L) {
                OS.gtk_widget_add_events(l, n);
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.closures[2], false);
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.closures[4], false);
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.closures[33], false);
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.closures[3], true);
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.closures[5], true);
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.closures[34], true);
                if (l != this.focusHandle()) {
                    OS.g_signal_connect_closure_by_id(l, this.display.signalIds[16], 0, this.display.closures[16], false);
                }
            }
            ++n2;
        }
        long l = this.imContext();
        if (l != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.closures[9], false);
            int n3 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n4 = 17;
            OS.g_signal_handlers_block_matched(l, n4, n3, 0, 0L, 0L, this.entryHandle);
        }
    }

    long imContext() {
        return this.entryHandle != 0L ? OS.GTK_ENTRY_IM_CONTEXT(this.entryHandle) : 0L;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (OS.gtk_combo_box_get_active(this.handle) == n) {
                this.clearText();
            }
        } else {
            boolean bl;
            this.ignoreSelect = true;
            long l = OS.gtk_container_get_children(this.listHandle);
            long l2 = OS.g_list_nth_data(l, n);
            boolean bl2 = bl = OS.GTK_WIDGET_STATE(l2) == 3;
            if (bl) {
                OS.gtk_list_unselect_all(this.listHandle);
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            OS.g_list_free(l);
            this.ignoreSelect = false;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_unselect_all(this.listHandle);
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            this.ignoreSelect = false;
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        if (bl && this.entryHandle != 0L) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long l = OS.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(l, n * 1024, n2 * 1024, nArray, nArray2);
            long l2 = OS.pango_layout_get_text(l);
            int n3 = (int)OS.g_utf8_pointer_to_offset(l2, l2 + (long)nArray[0]) + nArray2[0];
            Point point = this.getSelection();
            if (point.x <= n3 && n3 < point.y && super.dragDetect(n, n2, bl, blArray)) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, blArray);
    }

    long enterExitHandle() {
        return this.fixedHandle;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.listHandle != 0L ? this.listHandle : this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.items.length];
        System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return this.popupHandle != 0L && OS.GTK_WIDGET_VISIBLE(this.popupHandle);
        }
        return false;
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int n = 0;
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                int n2 = OS.gtk_combo_box_get_active(this.handle);
                if (n2 != -1) {
                    n = this.getItem(n2).length();
                }
            } else {
                long l = OS.gtk_entry_get_text(this.entryHandle);
                if (l != 0L) {
                    n = (int)OS.g_utf8_strlen(l, -1L);
                }
            }
            return new Point(0, n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.entryHandle != 0L) {
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray, nArray2);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        long l;
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return OS.gtk_combo_box_get_active(this.handle);
        }
        int n = 0;
        int n2 = -1;
        long l2 = l = OS.gtk_container_get_children(this.listHandle);
        while (l2 != 0L) {
            long l3 = OS.g_list_data(l2);
            if (OS.GTK_WIDGET_STATE(l3) == 3) {
                n2 = n;
                break;
            }
            ++n;
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l);
        return n2;
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            long l = OS.gtk_entry_get_text(this.entryHandle);
            if (l == 0L) {
                return "";
            }
            int n = OS.strlen(l);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l, (long)n);
            return new String(Converter.mbcsToWcs(null, byArray));
        }
        int n = OS.gtk_combo_box_get_active(this.handle);
        return n != -1 ? this.getItem(n) : "";
    }

    String getText(int n, int n2) {
        return this.getText().substring(n, n2 - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_size_request(this.handle, gtkRequisition);
        return OS.GTK_WIDGET_REQUISITION_HEIGHT(this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = this.entryHandle != 0L ? OS.gtk_entry_get_max_length(this.entryHandle) : 0;
        return n == 0 ? LIMIT : n;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    long gtk_activate(long l) {
        this.postEvent(14);
        return 0L;
    }

    long gtk_button_press_event(long l, long l2) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
            if (gdkEventButton.type == 4) {
                return 0L;
            }
        }
        return super.gtk_button_press_event(l, l2);
    }

    long gtk_changed(long l) {
        Object object;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (l == this.handle) {
                int n;
                if (this.entryHandle == 0L) {
                    this.sendEvent(24);
                    if (this.isDisposed()) {
                        return 0L;
                    }
                }
                if ((n = OS.gtk_combo_box_get_active(this.handle)) != -1) {
                    this.postEvent(13);
                }
                return 0L;
            }
        } else if (!this.ignoreSelect) {
            long l2 = OS.gtk_entry_get_text(this.entryHandle);
            int n = OS.strlen(l2);
            object = new byte[n];
            OS.memmove(object, l2, (long)n);
            String string = new String(Converter.mbcsToWcs(null, object));
            int n2 = 0;
            while (n2 < this.items.length) {
                if (this.items[n2].equals(string)) {
                    this.postEvent(13);
                    break;
                }
                ++n2;
            }
        }
        boolean bl = false;
        long l3 = OS.gtk_get_current_event();
        if (l3 != 0L) {
            object = new GdkEventKey();
            OS.memmove((GdkEventKey)object, l3, (long)GdkEventKey.sizeof);
            switch (object.type) {
                case 8: {
                    bl = true;
                }
            }
            OS.gdk_event_free(l3);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        if (!OS.gtk_editable_get_editable(this.entryHandle)) {
            return 0L;
        }
        int n = OS.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.entryHandle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.entryHandle, this.fixStart);
            OS.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    long gtk_delete_text(long l, long l2, long l3) {
        if (this.lockText) {
            OS.gtk_list_unselect_item(this.listHandle, 0);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
            return 0L;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        String string = this.verifyText("", (int)l2, (int)l3);
        if (string == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.gtk_editable_insert_text(this.entryHandle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_editable_set_position(this.entryHandle, nArray[0]);
        }
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 4: {
                    GdkEventButton gdkEventButton = new GdkEventButton();
                    OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                    if (gdkEventButton.button != 1) break;
                    if (!this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                        return 1L;
                    }
                    if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) || (this.style & 8) != 0 || l != this.buttonHandle) break;
                    OS.gtk_widget_grab_focus(this.entryHandle);
                    break;
                }
                case 12: {
                    if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) || (this.style & 8) != 0) break;
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    OS.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                    if (gdkEventFocus.in != 0) {
                        OS.gtk_combo_box_set_focus_on_click(this.handle, false);
                        break;
                    }
                    OS.gtk_combo_box_set_focus_on_click(this.handle, true);
                }
            }
        }
        return super.gtk_event_after(l, l2);
    }

    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    long gtk_insert_text(long l, long l2, long l3, long l4) {
        String string;
        if (this.lockText) {
            OS.gtk_list_unselect_item(this.listHandle, 0);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
            return 0L;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        OS.memmove(byArray, l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, l4, 4L);
        if (nArray[0] == -1) {
            long l5 = OS.gtk_entry_get_text(this.entryHandle);
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        if ((string = this.verifyText(string2, nArray[0], nArray[0])) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                    OS.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                OS.gtk_editable_insert_text(this.entryHandle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(l4, nArray, 4L);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (this.style & 8) == 0) {
            int n;
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            int n2 = n = OS.gtk_combo_box_get_active(this.handle);
            int n3 = gdkEventKey.keyval;
            switch (n3) {
                case 65364: 
                case 65433: {
                    if (n == this.items.length - 1) break;
                    n2 = n + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (n == -1 || n == 0) break;
                    n2 = n - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    n2 = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    n2 = this.items.length - 1;
                }
            }
            if (n2 != n) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                OS.gtk_combo_box_set_active(this.handle, n2);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                return 1L;
            }
        }
        return l3;
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n < 0 || n >= this.items.length) {
            return -1;
        }
        int n2 = n;
        while (n2 < this.items.length) {
            if (string.equals(this.items[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    boolean isFocusHandle(int n) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.buttonHandle != 0L && (long)n == this.buttonHandle) {
                return true;
            }
            if (this.entryHandle != 0L && (long)n == this.entryHandle) {
                return true;
            }
        }
        return super.isFocusHandle(n);
    }

    long paintWindow() {
        long l = this.entryHandle != 0L ? this.entryHandle : this.handle;
        OS.gtk_widget_realize(l);
        long l2 = OS.GTK_WIDGET_WINDOW(l);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (this.style & 8) != 0) {
            return l2;
        }
        long l3 = OS.gdk_window_get_children(l2);
        if (l3 != 0L) {
            l2 = OS.g_list_data(l3);
        }
        OS.g_list_free(l3);
        return l2;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    long parentingHandle() {
        return this.fixedHandle;
    }

    void register() {
        long l;
        super.register();
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0L) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.listHandle != 0L) {
            this.display.addWidget(this.listHandle, this);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.addWidget(l, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.listHandle = 0L;
        this.entryHandle = 0L;
        this.buttonHandle = 0L;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0L;
        this.fixIM();
    }

    public void remove(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
        this.items = stringArray2;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (OS.gtk_combo_box_get_active(this.handle) == n) {
                this.clearText();
            }
            OS.gtk_combo_box_remove_text(this.handle, n);
        } else {
            this.ignoreSelect = true;
            long l = OS.gtk_container_get_children(this.listHandle);
            long l2 = OS.g_list_nth_data(l, n);
            boolean bl = OS.GTK_WIDGET_STATE(l2) == 3;
            long l3 = OS.g_list_append(0L, l2);
            OS.gtk_list_remove_items(this.listHandle, l3);
            OS.g_list_free(l3);
            OS.g_list_free(l);
            if (bl) {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            this.ignoreSelect = false;
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - (n2 - n + 1)];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n2 + 1, stringArray2, n, stringArray.length - n2 - 1);
        this.items = stringArray2;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int n3 = OS.gtk_combo_box_get_active(this.handle);
            if (n <= n3 && n3 <= n2) {
                this.clearText();
            }
            int n4 = n2;
            while (n4 >= n) {
                OS.gtk_combo_box_remove_text(this.handle, n4);
                --n4;
            }
        } else {
            boolean bl = false;
            this.ignoreSelect = true;
            long l = 0L;
            long l2 = OS.gtk_container_get_children(this.listHandle);
            int n5 = n;
            while (n5 <= n2) {
                long l3 = OS.g_list_nth_data(l2, n5);
                bl |= OS.GTK_WIDGET_STATE(l3) == 3;
                l = OS.g_list_append(l, l3);
                ++n5;
            }
            OS.gtk_list_remove_items(this.listHandle, l);
            OS.g_list_free(l);
            OS.g_list_free(l2);
            if (bl) {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            this.ignoreSelect = false;
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.items.length;
        this.items = new String[0];
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
            int n2 = n - 1;
            while (n2 >= 0) {
                OS.gtk_combo_box_remove_text(this.handle, n2);
                --n2;
            }
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_clear_items(this.listHandle, 0, -1);
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            this.ignoreSelect = false;
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_combo_box_set_active(this.handle, n);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_select_item(this.listHandle, n);
            this.ignoreSelect = false;
        }
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0L) {
                OS.gtk_widget_modify_base(this.entryHandle, 0, gdkColor);
            }
            OS.g_object_set(this.textRenderer, OS.background_gdk, gdkColor, 0L);
        } else {
            OS.gtk_widget_modify_base(this.entryHandle, 0, gdkColor);
            if (this.listHandle != 0L) {
                OS.gtk_widget_modify_base(this.listHandle, 0, gdkColor);
            }
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = bl2 ? this.getTextHeight() : n4;
        return super.setBounds(n, n2, n3, n5, bl, bl2);
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0L) {
                OS.gtk_widget_modify_font(this.entryHandle, l);
            }
            OS.g_object_set(this.textRenderer, OS.font_desc, l, 0L);
            if ((this.style & 8) != 0) {
                int n = OS.gtk_combo_box_get_active(this.handle);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                OS.gtk_combo_box_set_active(this.handle, -1);
                OS.gtk_combo_box_set_active(this.handle, n);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            }
        } else {
            OS.gtk_widget_modify_font(this.entryHandle, l);
            if (this.listHandle != 0L) {
                OS.gtk_widget_modify_font(this.listHandle, l);
                long l2 = OS.gtk_container_get_children(this.listHandle);
                if (l2 != 0L) {
                    int n = OS.g_list_length(l2);
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        long l3 = OS.gtk_bin_get_child(OS.g_list_nth_data(l2, n2));
                        OS.gtk_widget_modify_font(l3, l);
                        --n2;
                    }
                    OS.g_list_free(l2);
                }
            }
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0L) {
                this.setForegroundColor(this.entryHandle, gdkColor);
            }
            OS.g_object_set(this.textRenderer, OS.foreground_gdk, gdkColor, 0L);
        } else {
            this.setForegroundColor(this.entryHandle, gdkColor);
            if (this.listHandle != 0L) {
                this.setForegroundColor(this.listHandle, gdkColor);
                long l = OS.gtk_container_get_children(this.listHandle);
                if (l != 0L) {
                    int n = OS.g_list_length(l);
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        long l2 = OS.gtk_bin_get_child(OS.g_list_nth_data(l, n2));
                        this.setForegroundColor(l2, gdkColor);
                        --n2;
                    }
                    OS.g_list_free(l);
                }
            }
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n < 0 || n >= this.items.length) {
            this.error(5);
        }
        this.items[n] = string;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_combo_box_remove_text(this.handle, n);
            OS.gtk_combo_box_insert_text(this.handle, n, byArray);
            if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
            }
        } else {
            this.ignoreSelect = true;
            long l = OS.gtk_container_get_children(this.listHandle);
            long l2 = OS.g_list_nth_data(l, n);
            long l3 = OS.gtk_bin_get_child(l2);
            OS.gtk_label_set_text(l3, byArray);
            OS.g_list_free(l);
            this.ignoreSelect = false;
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        n = this.items.length;
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
            int n2 = n - 1;
            while (n2 >= 0) {
                OS.gtk_combo_box_remove_text(this.handle, n2);
                --n2;
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                byte[] byArray = Converter.wcsToMbcs(null, string, true);
                OS.gtk_combo_box_insert_text(this.handle, n2, byArray);
                if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
                    OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
                }
                ++n2;
            }
        } else {
            this.ignoreSelect = true;
            this.lockText = true;
            OS.gtk_list_clear_items(this.listHandle, 0, -1);
            long l = this.getFontDescription();
            GdkColor gdkColor = this.getForegroundColor();
            int n3 = OS.gtk_widget_get_direction(this.handle);
            int n4 = 0;
            while (n4 < stringArray.length) {
                String string = stringArray[n4];
                byte[] byArray = Converter.wcsToMbcs(null, string, true);
                long l2 = OS.gtk_list_item_new_with_label(byArray);
                long l3 = OS.gtk_bin_get_child(l2);
                this.setForegroundColor(l3, gdkColor);
                OS.gtk_widget_modify_font(l3, l);
                OS.gtk_widget_set_direction(l3, n3);
                OS.gtk_container_add(this.listHandle, l2);
                OS.gtk_widget_show(l2);
                ++n4;
            }
            this.ignoreSelect = false;
            this.lockText = false;
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (bl) {
                OS.gtk_combo_box_popup(this.handle);
            } else {
                OS.gtk_combo_box_popdown(this.handle);
            }
        }
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0) {
            if (this.listHandle != 0L) {
                OS.gtk_widget_set_direction(this.listHandle, 2);
            }
            if (this.entryHandle != 0L) {
                OS.gtk_widget_set_direction(this.entryHandle, 2);
            }
            if (this.cellHandle != 0L) {
                OS.gtk_widget_set_direction(this.cellHandle, 2);
            }
        }
    }

    public void setOrientation(int n) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.checkWidget();
            int n2 = 0x6000000;
            if ((n & n2) == 0 || (n & n2) == n2) {
                return;
            }
            this.style &= ~n2;
            this.style |= n & n2;
            int n3 = (n & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.fixedHandle, n3);
            OS.gtk_widget_set_direction(this.handle, n3);
            if (this.entryHandle != 0L) {
                OS.gtk_widget_set_direction(this.entryHandle, n3);
            }
            if (this.listHandle != 0L) {
                OS.gtk_widget_set_direction(this.listHandle, n3);
                long l = OS.gtk_container_get_children(this.listHandle);
                if (l != 0L) {
                    int n4 = OS.g_list_length(l);
                    int n5 = n4 - 1;
                    while (n5 >= 0) {
                        long l2 = OS.gtk_bin_get_child(OS.g_list_nth_data(l, n5));
                        OS.gtk_widget_set_direction(l2, n3);
                        --n5;
                    }
                    OS.g_list_free(l);
                }
            }
            if (this.cellHandle != 0L) {
                OS.gtk_widget_set_direction(this.cellHandle, n3);
            }
            if (this.popupHandle != 0L) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, n3);
            }
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0L) {
            OS.gtk_editable_set_position(this.entryHandle, point.x);
            OS.gtk_editable_select_region(this.entryHandle, point.x, point.y);
        }
    }

    public void setText(String string) {
        long l;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n == -1) {
                return;
            }
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                OS.gtk_combo_box_set_active(this.handle, n);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                return;
            }
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, (int)OS.g_utf8_strlen(l = OS.gtk_entry_get_text(this.entryHandle), -1L))) == null) {
            return;
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        OS.gtk_entry_set_text(this.entryHandle, byArray);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        this.sendEvent(24);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0L) {
            OS.gtk_entry_set_max_length(this.entryHandle, n);
        }
    }

    void setToolTipText(Shell shell, String string) {
        if (this.entryHandle != 0L) {
            shell.setToolTipText(this.entryHandle, string);
        }
        if (this.buttonHandle != 0L) {
            shell.setToolTipText(this.buttonHandle, string);
        }
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                long l = this.imContext();
                if (l == 0L) break;
                long[] lArray = new long[1];
                OS.gtk_im_context_get_preedit_string(l, lArray, null, null);
                if (lArray[0] == 0L) break;
                int n2 = OS.strlen(lArray[0]);
                OS.g_free(lArray[0]);
                if (n2 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    String verifyText(String string, int n, int n2) {
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        long l = OS.gtk_get_current_event();
        if (l != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(l);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

