/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int ascent;
    int descent;
    int[] segments;
    int[] tabs;
    StyleItem[] styles;
    long layout;
    long context = OS.gdk_pango_context_get();
    long attrList;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        super(device);
        if (this.context == 0L) {
            SWT.error(2);
        }
        OS.pango_context_set_language(this.context, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(this.context, 0);
        OS.gdk_pango_context_set_colormap(this.context, OS.gdk_colormap_get_system());
        this.layout = OS.pango_layout_new(this.context);
        if (this.layout == 0L) {
            SWT.error(2);
        }
        OS.pango_layout_set_wrap(this.layout, 2);
        OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.pango_layout_set_auto_dir(this.layout, false);
        }
        this.text = "";
        this.descent = -1;
        this.ascent = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        int n;
        int n2;
        int n3;
        if (this.attrList != 0L) {
            return;
        }
        String string = this.getSegmentsText();
        byte[] byArray = Converter.wcsToMbcs(null, string, false);
        OS.pango_layout_set_text(this.layout, byArray, byArray.length);
        if (this.styles.length == 2 && this.styles[0].style == null && this.ascent == -1 && this.descent == -1 && this.segments == null) {
            return;
        }
        long l = OS.pango_layout_get_text(this.layout);
        this.attrList = OS.pango_attr_list_new();
        PangoAttribute pangoAttribute = new PangoAttribute();
        char[] cArray = null;
        int n4 = string.length();
        if ((this.ascent != -1 || this.descent != -1) && n4 > 0) {
            long l2 = OS.pango_layout_get_iter(this.layout);
            if (l2 == 0L) {
                SWT.error(2);
            }
            PangoRectangle pangoRectangle = new PangoRectangle();
            if (this.ascent != -1) {
                pangoRectangle.y = -(this.ascent * 1024);
            }
            pangoRectangle.height = (Math.max(0, this.ascent) + Math.max(0, this.descent)) * 1024;
            int n5 = OS.pango_layout_get_line_count(this.layout);
            cArray = new char[n4 + n5 * 2];
            int n6 = 0;
            n3 = 0;
            do {
                n2 = OS.pango_layout_iter_get_index(l2);
                n = n3 * 6;
                long l3 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, l3, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2 + n;
                pangoAttribute.end_index = n2 + n + 3;
                OS.memmove(l3, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l3);
                l3 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, l3, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2 + n + 3;
                pangoAttribute.end_index = n2 + n + 6;
                OS.memmove(l3, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l3);
                int n7 = (int)OS.g_utf8_pointer_to_offset(l, l + (long)n2);
                cArray[n7 + n3 * 2] = 8203;
                cArray[n7 + n3 * 2 + 1] = 65279;
                string.getChars(n6, n7, cArray, n6 + n3 * 2);
                n6 = n7;
                ++n3;
            } while (OS.pango_layout_iter_next_line(l2));
            OS.pango_layout_iter_free(l2);
            string.getChars(n6, n4, cArray, n6 + n3 * 2);
            byArray = Converter.wcsToMbcs(null, cArray, false);
            OS.pango_layout_set_text(this.layout, byArray, byArray.length);
            l = OS.pango_layout_get_text(this.layout);
        } else {
            cArray = new char[n4];
            string.getChars(0, n4, cArray, 0);
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < cArray.length) {
            char c = cArray[n9];
            if (c == '\u200e' || c == '\u200f' || c == '\ufeff' || c == '\u200b') {
                ++n8;
            }
            ++n9;
        }
        this.invalidOffsets = new int[n8];
        n8 = 0;
        n9 = 0;
        while (n9 < cArray.length) {
            char c = cArray[n9];
            if (c == '\u200e' || c == '\u200f' || c == '\ufeff' || c == '\u200b') {
                this.invalidOffsets[n8++] = n9;
            }
            ++n9;
        }
        n9 = OS.strlen(l);
        int n10 = 0;
        while (n10 < this.styles.length - 1) {
            StyleItem styleItem = this.styles[n10];
            TextStyle textStyle = styleItem.style;
            if (textStyle != null) {
                int n11;
                long l4;
                GlyphMetrics glyphMetrics;
                Color color;
                Color color2;
                n3 = this.translateOffset(styleItem.start);
                n2 = this.translateOffset(this.styles[n10 + 1].start - 1);
                n = (int)(OS.g_utf8_offset_to_pointer(l, n3) - l);
                int n12 = (int)(OS.g_utf8_offset_to_pointer(l, n2 + 1) - l);
                n = Math.min(n, n9);
                n12 = Math.min(n12, n9);
                Font font = textStyle.font;
                if (font != null && !font.isDisposed()) {
                    long l5 = OS.pango_attr_font_desc_new(font.handle);
                    OS.memmove(pangoAttribute, l5, (long)PangoAttribute.sizeof);
                    pangoAttribute.start_index = n;
                    pangoAttribute.end_index = n12;
                    OS.memmove(l5, pangoAttribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, l5);
                }
                if (textStyle.underline) {
                    int n13 = 0;
                    switch (textStyle.underlineStyle) {
                        case 0: {
                            n13 = 1;
                            break;
                        }
                        case 1: {
                            n13 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) break;
                            n13 = 4;
                        }
                    }
                    if (n13 != 0 && textStyle.underlineColor == null) {
                        long l6 = OS.pango_attr_underline_new(n13);
                        OS.memmove(pangoAttribute, l6, (long)PangoAttribute.sizeof);
                        pangoAttribute.start_index = n;
                        pangoAttribute.end_index = n12;
                        OS.memmove(l6, pangoAttribute, (long)PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, l6);
                    }
                }
                if (textStyle.strikeout && textStyle.strikeoutColor == null) {
                    long l7 = OS.pango_attr_strikethrough_new(true);
                    OS.memmove(pangoAttribute, l7, (long)PangoAttribute.sizeof);
                    pangoAttribute.start_index = n;
                    pangoAttribute.end_index = n12;
                    OS.memmove(l7, pangoAttribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, l7);
                }
                if ((color2 = textStyle.foreground) != null && !color2.isDisposed()) {
                    GdkColor gdkColor = color2.handle;
                    long l8 = OS.pango_attr_foreground_new(gdkColor.red, gdkColor.green, gdkColor.blue);
                    OS.memmove(pangoAttribute, l8, (long)PangoAttribute.sizeof);
                    pangoAttribute.start_index = n;
                    pangoAttribute.end_index = n12;
                    OS.memmove(l8, pangoAttribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, l8);
                }
                if ((color = textStyle.background) != null && !color.isDisposed()) {
                    GdkColor gdkColor = color.handle;
                    long l9 = OS.pango_attr_background_new(gdkColor.red, gdkColor.green, gdkColor.blue);
                    OS.memmove(pangoAttribute, l9, (long)PangoAttribute.sizeof);
                    pangoAttribute.start_index = n;
                    pangoAttribute.end_index = n12;
                    OS.memmove(l9, pangoAttribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, l9);
                }
                if ((glyphMetrics = textStyle.metrics) != null) {
                    PangoRectangle pangoRectangle = new PangoRectangle();
                    pangoRectangle.y = -(glyphMetrics.ascent * 1024);
                    pangoRectangle.height = (glyphMetrics.ascent + glyphMetrics.descent) * 1024;
                    pangoRectangle.width = glyphMetrics.width * 1024;
                    l4 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                    OS.memmove(pangoAttribute, l4, (long)PangoAttribute.sizeof);
                    pangoAttribute.start_index = n;
                    pangoAttribute.end_index = n12;
                    OS.memmove(l4, pangoAttribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, l4);
                }
                if ((n11 = textStyle.rise) != 0) {
                    l4 = OS.pango_attr_rise_new(n11 * 1024);
                    OS.memmove(pangoAttribute, l4, (long)PangoAttribute.sizeof);
                    pangoAttribute.start_index = n;
                    pangoAttribute.end_index = n12;
                    OS.memmove(l4, pangoAttribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, l4);
                }
            }
            ++n10;
        }
        OS.pango_layout_set_attributes(this.layout, this.attrList);
    }

    int[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new int[0];
        }
        int[] nArray = new int[n5];
        int n9 = 0;
        while (n9 < n8) {
            int n10 = 4 * n9;
            nArray[n10] = n + n7 * n9;
            nArray[n10 + 1] = n4;
            nArray[n10 + 2] = nArray[n10] + n7 / 2;
            nArray[n10 + 3] = n2;
            ++n9;
        }
        nArray[n5 - 2] = n + n7 * n8;
        nArray[n5 - 1] = n4;
        return nArray;
    }

    void destroy() {
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        if (this.layout != 0L) {
            OS.g_object_unref(this.layout);
        }
        this.layout = 0L;
        if (this.context != 0L) {
            OS.g_object_unref(this.context);
        }
        this.context = 0L;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        this.checkLayout();
        this.computeRuns();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        gC.checkGC(1);
        int n7 = this.text.length();
        boolean bl = n3 <= n4 && n3 != -1 && n4 != -1;
        GCData gCData = gC.data;
        long l = gCData.cairo;
        if (n5 != 0 && (bl || (n5 & 0x100000) != 0)) {
            long[] lArray = new long[1];
            int[] nArray = new int[1];
            PangoLogAttr pangoLogAttr = new PangoLogAttr();
            PangoRectangle pangoRectangle = new PangoRectangle();
            n6 = OS.pango_layout_get_line_count(this.layout);
            long l2 = OS.pango_layout_get_text(this.layout);
            long l3 = OS.pango_layout_get_iter(this.layout);
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_save(l);
                GdkColor gdkColor = color2.handle;
                Cairo.cairo_set_source_rgba(l, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
            } else {
                OS.gdk_gc_set_foreground(gC.handle, color2.handle);
            }
            int n8 = 0;
            do {
                int n9;
                int n10;
                int n11;
                OS.pango_layout_iter_get_line_extents(l3, null, pangoRectangle);
                if (OS.pango_layout_iter_next_line(l3)) {
                    n11 = OS.pango_layout_iter_get_index(l3);
                    n10 = (int)OS.g_utf8_pointer_to_offset(l2, l2 + (long)n11);
                } else {
                    n10 = (int)OS.g_utf8_strlen(l2, -1L);
                }
                n11 = 0;
                if (n8 == n6 - 1 && (n5 & 0x100000) != 0) {
                    n11 = 1;
                } else {
                    if (lArray[0] == 0L) {
                        OS.pango_layout_get_log_attrs(this.layout, lArray, nArray);
                    }
                    OS.memmove(pangoLogAttr, lArray[0] + (long)(n10 * PangoLogAttr.sizeof), (long)PangoLogAttr.sizeof);
                    if (!pangoLogAttr.is_line_break) {
                        if (n3 <= n10 && n10 <= n4) {
                            n11 = 1;
                        }
                    } else if (n3 <= n10 && n10 < n4 && (n5 & 0x10000) != 0) {
                        n11 = 1;
                    }
                }
                if (n11 == 0) continue;
                int n12 = n + OS.PANGO_PIXELS(pangoRectangle.x) + OS.PANGO_PIXELS(pangoRectangle.width);
                int n13 = n2 + OS.PANGO_PIXELS(pangoRectangle.y);
                int n14 = OS.PANGO_PIXELS(pangoRectangle.height);
                if (this.ascent != -1 && this.descent != -1) {
                    n14 = Math.max(n14, this.ascent + this.descent);
                }
                int n15 = n9 = (n5 & 0x10000) != 0 ? Integer.MAX_VALUE : n14 / 3;
                if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    Cairo.cairo_rectangle(l, n12, n13, n9, n14);
                    Cairo.cairo_fill(l);
                    continue;
                }
                OS.gdk_draw_rectangle(gCData.drawable, gC.handle, 1, n12, n13, n9, n14);
            } while (++n8 < n6);
            OS.pango_layout_iter_free(l3);
            if (lArray[0] != 0L) {
                OS.g_free(lArray[0]);
            }
            if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_restore(l);
            } else {
                OS.gdk_gc_set_foreground(gC.handle, gCData.foreground);
            }
        }
        if (n7 == 0) {
            return;
        }
        if (!bl) {
            if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_save(l);
                    Cairo.cairo_scale(l, -1.0, 1.0);
                    Cairo.cairo_translate(l, -2 * n - this.width(), 0.0);
                }
                Cairo.cairo_move_to(l, n, n2);
                OS.pango_cairo_show_layout(l, this.layout);
                this.drawBorder(gC, n, n2, null);
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_restore(l);
                }
            } else {
                OS.gdk_draw_layout(gCData.drawable, gC.handle, n, n2, this.layout);
                this.drawBorder(gC, n, n2, null);
            }
        } else {
            boolean bl2;
            n3 = Math.min(Math.max(0, n3), n7 - 1);
            n4 = Math.min(Math.max(0, n4), n7 - 1);
            n7 = (int)OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1L);
            n3 = this.translateOffset(n3);
            n4 = this.translateOffset(n4);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            boolean bl3 = bl2 = n3 == 0 && n4 == n7 - 1;
            if (bl2) {
                if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    long l4 = OS.pango_layout_get_text(this.layout);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_save(l);
                        Cairo.cairo_scale(l, -1.0, 1.0);
                        Cairo.cairo_translate(l, -2 * n - this.width(), 0.0);
                    }
                    this.drawWithCairo(gC, n, n2, 0, OS.strlen(l4), bl2, color.handle, color2.handle);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_restore(l);
                    }
                } else {
                    OS.gdk_draw_layout_with_colors(gCData.drawable, gC.handle, n, n2, this.layout, color.handle, color2.handle);
                    this.drawBorder(gC, n, n2, color.handle);
                }
            } else {
                long l5 = OS.pango_layout_get_text(this.layout);
                int n16 = (int)(OS.g_utf8_offset_to_pointer(l5, n3) - l5);
                n6 = (int)(OS.g_utf8_offset_to_pointer(l5, n4 + 1) - l5);
                int n17 = OS.strlen(l5);
                n16 = Math.min(n16, n17);
                n6 = Math.min(n6, n17);
                if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_save(l);
                        Cairo.cairo_scale(l, -1.0, 1.0);
                        Cairo.cairo_translate(l, -2 * n - this.width(), 0.0);
                    }
                    this.drawWithCairo(gC, n, n2, n16, n6, bl2, color.handle, color2.handle);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_restore(l);
                    }
                } else {
                    Region region = new Region();
                    gC.getClipping(region);
                    OS.gdk_draw_layout(gCData.drawable, gC.handle, n, n2, this.layout);
                    this.drawBorder(gC, n, n2, null);
                    int[] nArray = new int[]{n16, n6};
                    long l6 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
                    if (l6 != 0L) {
                        OS.gdk_gc_set_clip_region(gC.handle, l6);
                        OS.gdk_region_destroy(l6);
                    }
                    OS.gdk_draw_layout_with_colors(gCData.drawable, gC.handle, n, n2, this.layout, color.handle, color2.handle);
                    this.drawBorder(gC, n, n2, color.handle);
                    gC.setClipping(region);
                    region.dispose();
                }
            }
        }
    }

    void drawWithCairo(GC gC, int n, int n2, int n3, int n4, boolean bl, GdkColor gdkColor, GdkColor gdkColor2) {
        int[] nArray;
        long l;
        GCData gCData = gC.data;
        long l2 = gCData.cairo;
        Cairo.cairo_save(l2);
        if (!bl) {
            Cairo.cairo_move_to(l2, n, n2);
            OS.pango_cairo_show_layout(l2, this.layout);
            this.drawBorder(gC, n, n2, null);
        }
        if ((l = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray = new int[]{n3, n4}, nArray.length / 2)) != 0L) {
            OS.gdk_cairo_region(l2, l);
            Cairo.cairo_clip(l2);
            Cairo.cairo_set_source_rgba(l2, (float)(gdkColor2.red & 0xFFFF) / 65535.0f, (float)(gdkColor2.green & 0xFFFF) / 65535.0f, (float)(gdkColor2.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
            Cairo.cairo_paint(l2);
            OS.gdk_region_destroy(l);
        }
        Cairo.cairo_set_source_rgba(l2, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
        Cairo.cairo_move_to(l2, n, n2);
        OS.pango_cairo_show_layout(l2, this.layout);
        this.drawBorder(gC, n, n2, gdkColor);
        Cairo.cairo_restore(l2);
    }

    void drawBorder(GC gC, int n, int n2, GdkColor gdkColor) {
        GCData gCData = gC.data;
        long l = gCData.cairo;
        long l2 = gC.handle;
        long l3 = OS.pango_layout_get_text(this.layout);
        GdkGCValues gdkGCValues = null;
        if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            Cairo.cairo_save(l);
        }
        int n3 = 0;
        while (n3 < this.styles.length - 1) {
            TextStyle textStyle = this.styles[n3].style;
            if (textStyle != null) {
                int n4;
                int n5;
                int n6;
                Object object;
                Object object2;
                Object[] objectArray;
                int n7;
                int n8;
                int n9;
                int n10;
                boolean bl;
                boolean bl2 = bl = textStyle.borderStyle != 0;
                if (bl && !textStyle.isAdherentBorder(this.styles[n3 + 1].style)) {
                    n10 = this.styles[n3].start;
                    n9 = n3;
                    while (n9 > 0 && textStyle.isAdherentBorder(this.styles[n9 - 1].style)) {
                        n10 = this.styles[n9 - 1].start;
                        --n9;
                    }
                    n10 = this.translateOffset(n10);
                    n9 = this.translateOffset(this.styles[n3 + 1].start - 1);
                    n8 = (int)(OS.g_utf8_offset_to_pointer(l3, n10) - l3);
                    int[] nArray = new int[]{n8, n7 = (int)(OS.g_utf8_offset_to_pointer(l3, n9 + 1) - l3)};
                    long l4 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
                    if (l4 != 0L) {
                        int[] nArray2 = new int[1];
                        objectArray = new long[1];
                        OS.gdk_region_get_rectangles(l4, objectArray, nArray2);
                        object2 = new GdkRectangle();
                        object = null;
                        if (object == null && textStyle.borderColor != null) {
                            object = textStyle.borderColor.handle;
                        }
                        if (object == null && gdkColor != null) {
                            object = gdkColor;
                        }
                        if (object == null && textStyle.foreground != null) {
                            object = textStyle.foreground.handle;
                        }
                        if (object == null) {
                            object = gCData.foreground;
                        }
                        int n11 = 1;
                        float[] fArray = null;
                        switch (textStyle.borderStyle) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                fArray = n11 != 0 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                break;
                            }
                            case 4: {
                                float[] fArray2 = fArray = n11 != 0 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                            }
                        }
                        if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(l, (float)(object.red & 0xFFFF) / 65535.0f, (float)(object.green & 0xFFFF) / 65535.0f, (float)(object.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                            Cairo.cairo_set_line_width(l, n11);
                            if (fArray != null) {
                                double[] dArray = new double[fArray.length];
                                n6 = 0;
                                while (n6 < dArray.length) {
                                    dArray[n6] = n11 == 0 || gCData.lineStyle == 6 ? fArray[n6] : fArray[n6] * (float)n11;
                                    ++n6;
                                }
                                Cairo.cairo_set_dash(l, dArray, dArray.length, 0.0);
                            } else {
                                Cairo.cairo_set_dash(l, null, 0, 0.0);
                            }
                            n5 = 0;
                            while (n5 < nArray2[0]) {
                                OS.memmove((GdkRectangle)object2, objectArray[0] + (long)(n5 * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                                Cairo.cairo_rectangle(l, (double)((GdkRectangle)object2).x + 0.5, (double)((GdkRectangle)object2).y + 0.5, ((GdkRectangle)object2).width - 1, ((GdkRectangle)object2).height - 1);
                                ++n5;
                            }
                            Cairo.cairo_stroke(l);
                        } else {
                            if (gdkGCValues == null) {
                                gdkGCValues = new GdkGCValues();
                                OS.gdk_gc_get_values(l2, gdkGCValues);
                            }
                            OS.gdk_gc_set_foreground(l2, (GdkColor)object);
                            n5 = 1;
                            n6 = 0;
                            int n12 = 0;
                            if (fArray != null) {
                                byte[] byArray = new byte[fArray.length];
                                int n13 = 0;
                                while (n13 < byArray.length) {
                                    byArray[n13] = (byte)(n11 == 0 || gCData.lineStyle == 6 ? fArray[n13] : fArray[n13] * (float)n11);
                                    ++n13;
                                }
                                OS.gdk_gc_set_dashes(l2, 0, byArray, byArray.length);
                                n12 = 1;
                            } else {
                                n12 = 0;
                            }
                            OS.gdk_gc_set_line_attributes(l2, n11, n12, n5, n6);
                            int n14 = 0;
                            while (n14 < nArray2[0]) {
                                OS.memmove((GdkRectangle)object2, objectArray[0] + (long)(n14 * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                                OS.gdk_draw_rectangle(gCData.drawable, l2, 0, ((GdkRectangle)object2).x, ((GdkRectangle)object2).y, ((GdkRectangle)object2).width - 1, ((GdkRectangle)object2).height - 1);
                                ++n14;
                            }
                        }
                        if (objectArray[0] != 0L) {
                            OS.g_free(objectArray[0]);
                        }
                        OS.gdk_region_destroy(l4);
                    }
                }
                n10 = 0;
                if (textStyle.underline && textStyle.underlineColor != null) {
                    n10 = 1;
                }
                if (textStyle.underline && (textStyle.underlineStyle == 2 || textStyle.underlineStyle == 3) && OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
                    n10 = 1;
                }
                if (n10 != 0 && !textStyle.isAdherentUnderline(this.styles[n3 + 1].style)) {
                    int n15;
                    n9 = this.styles[n3].start;
                    n8 = n3;
                    while (n8 > 0 && textStyle.isAdherentUnderline(this.styles[n8 - 1].style)) {
                        n9 = this.styles[n8 - 1].start;
                        --n8;
                    }
                    n9 = this.translateOffset(n9);
                    n8 = this.translateOffset(this.styles[n3 + 1].start - 1);
                    n7 = (int)(OS.g_utf8_offset_to_pointer(l3, n9) - l3);
                    int[] nArray = new int[]{n7, n15 = (int)(OS.g_utf8_offset_to_pointer(l3, n8 + 1) - l3)};
                    long l5 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
                    if (l5 != 0L) {
                        objectArray = new int[1];
                        object2 = new long[1];
                        OS.gdk_region_get_rectangles(l5, (long[])object2, (int[])objectArray);
                        object = new GdkRectangle();
                        GdkColor gdkColor2 = null;
                        if (gdkColor2 == null && textStyle.underlineColor != null) {
                            gdkColor2 = textStyle.underlineColor.handle;
                        }
                        if (gdkColor2 == null && gdkColor != null) {
                            gdkColor2 = gdkColor;
                        }
                        if (gdkColor2 == null && textStyle.foreground != null) {
                            gdkColor2 = textStyle.foreground.handle;
                        }
                        if (gdkColor2 == null) {
                            gdkColor2 = gCData.foreground;
                        }
                        if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(l, (float)(gdkColor2.red & 0xFFFF) / 65535.0f, (float)(gdkColor2.green & 0xFFFF) / 65535.0f, (float)(gdkColor2.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                        } else {
                            if (gdkGCValues == null) {
                                gdkGCValues = new GdkGCValues();
                                OS.gdk_gc_get_values(l2, gdkGCValues);
                            }
                            OS.gdk_gc_set_foreground(l2, gdkColor2);
                        }
                        int n16 = -1;
                        n5 = 1;
                        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                            Font font = textStyle.font;
                            if (font == null) {
                                font = this.font;
                            }
                            if (font == null) {
                                font = this.device.systemFont;
                            }
                            long l6 = OS.pango_context_get_language(this.context);
                            long l7 = OS.pango_context_get_metrics(this.context, font.handle, l6);
                            n16 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_underline_position(l7));
                            n5 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_underline_thickness(l7));
                            OS.pango_font_metrics_unref(l7);
                        }
                        n6 = 0;
                        while (n6 < objectArray[0]) {
                            OS.memmove((GdkRectangle)object, (long)(object2[0] + (long)(n6 * GdkRectangle.sizeof)), (long)GdkRectangle.sizeof);
                            int n17 = this.getOffset(object.x - n, object.y - n2, null);
                            int n18 = this.getLineIndex(n17);
                            FontMetrics fontMetrics = this.getLineMetrics(n18);
                            n4 = object.y + fontMetrics.ascent - n16 - textStyle.rise;
                            switch (textStyle.underlineStyle) {
                                case 2: 
                                case 3: {
                                    int n19 = n5;
                                    int n20 = 2 * n19;
                                    int n21 = Math.min(n4, object.y + object.height - n20 - 1);
                                    int[] nArray3 = this.computePolyline(object.x, n21, object.x + object.width, n21 + n20);
                                    if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_set_line_width(l, n19);
                                        Cairo.cairo_set_line_cap(l, 0);
                                        Cairo.cairo_set_line_join(l, 0);
                                        if (nArray3.length <= 0) break;
                                        double d = 0.5;
                                        double d2 = 0.5;
                                        Cairo.cairo_move_to(l, (double)nArray3[0] + d, (double)nArray3[1] + d2);
                                        int n22 = 2;
                                        while (n22 < nArray3.length) {
                                            Cairo.cairo_line_to(l, (double)nArray3[n22] + d, (double)nArray3[n22 + 1] + d2);
                                            n22 += 2;
                                        }
                                        Cairo.cairo_stroke(l);
                                        break;
                                    }
                                    OS.gdk_gc_set_line_attributes(l2, n19, 0, 1, 0);
                                    OS.gdk_draw_lines(gCData.drawable, l2, nArray3, nArray3.length / 2);
                                    break;
                                }
                                case 1: {
                                    if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_rectangle(l, object.x, n4 + n5 * 2, object.width, n5);
                                        Cairo.cairo_fill(l);
                                    } else {
                                        OS.gdk_draw_rectangle(gCData.drawable, l2, 1, object.x, n4 + n5 * 2, object.width, n5);
                                    }
                                }
                                case 0: {
                                    if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_rectangle(l, object.x, n4, object.width, n5);
                                        Cairo.cairo_fill(l);
                                        break;
                                    }
                                    OS.gdk_draw_rectangle(gCData.drawable, l2, 1, object.x, n4, object.width, n5);
                                }
                            }
                            ++n6;
                        }
                        if (object2[0] != 0L) {
                            OS.g_free((long)object2[0]);
                        }
                        OS.gdk_region_destroy(l5);
                    }
                }
                n9 = 0;
                if (textStyle.strikeout && textStyle.strikeoutColor != null) {
                    n9 = 1;
                }
                if (n9 != 0 && !textStyle.isAdherentStrikeout(this.styles[n3 + 1].style)) {
                    int n23;
                    n8 = this.styles[n3].start;
                    n7 = n3;
                    while (n7 > 0 && textStyle.isAdherentStrikeout(this.styles[n7 - 1].style)) {
                        n8 = this.styles[n7 - 1].start;
                        --n7;
                    }
                    n8 = this.translateOffset(n8);
                    n7 = this.translateOffset(this.styles[n3 + 1].start - 1);
                    int n24 = (int)(OS.g_utf8_offset_to_pointer(l3, n8) - l3);
                    int[] nArray = new int[]{n24, n23 = (int)(OS.g_utf8_offset_to_pointer(l3, n7 + 1) - l3)};
                    long l8 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
                    if (l8 != 0L) {
                        object2 = new int[1];
                        object = new long[1];
                        OS.gdk_region_get_rectangles(l8, object, (int[])object2);
                        GdkRectangle gdkRectangle = new GdkRectangle();
                        GdkColor gdkColor3 = null;
                        if (gdkColor3 == null && textStyle.strikeoutColor != null) {
                            gdkColor3 = textStyle.strikeoutColor.handle;
                        }
                        if (gdkColor3 == null && gdkColor != null) {
                            gdkColor3 = gdkColor;
                        }
                        if (gdkColor3 == null && textStyle.foreground != null) {
                            gdkColor3 = textStyle.foreground.handle;
                        }
                        if (gdkColor3 == null) {
                            gdkColor3 = gCData.foreground;
                        }
                        if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(l, (float)(gdkColor3.red & 0xFFFF) / 65535.0f, (float)(gdkColor3.green & 0xFFFF) / 65535.0f, (float)(gdkColor3.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                        } else {
                            if (gdkGCValues == null) {
                                gdkGCValues = new GdkGCValues();
                                OS.gdk_gc_get_values(l2, gdkGCValues);
                            }
                            OS.gdk_gc_set_foreground(l2, gdkColor3);
                        }
                        n5 = -1;
                        n6 = 1;
                        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                            Font font = textStyle.font;
                            if (font == null) {
                                font = this.font;
                            }
                            if (font == null) {
                                font = this.device.systemFont;
                            }
                            long l9 = OS.pango_context_get_language(this.context);
                            long l10 = OS.pango_context_get_metrics(this.context, font.handle, l9);
                            n5 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_strikethrough_position(l10));
                            n6 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_strikethrough_thickness(l10));
                            OS.pango_font_metrics_unref(l10);
                        }
                        int n25 = 0;
                        while (n25 < object2[0]) {
                            OS.memmove(gdkRectangle, object[0] + (long)(n25 * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                            int n26 = gdkRectangle.y + gdkRectangle.height / 2 - textStyle.rise;
                            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                                int n27 = this.getOffset(gdkRectangle.x - n, gdkRectangle.y - n2, null);
                                n4 = this.getLineIndex(n27);
                                FontMetrics fontMetrics = this.getLineMetrics(n4);
                                n26 = gdkRectangle.y + fontMetrics.ascent - n5 - textStyle.rise;
                            }
                            if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                Cairo.cairo_rectangle(l, gdkRectangle.x, n26, gdkRectangle.width, n6);
                                Cairo.cairo_fill(l);
                            } else {
                                OS.gdk_draw_rectangle(gCData.drawable, l2, 1, gdkRectangle.x, n26, gdkRectangle.width, n6);
                            }
                            ++n25;
                        }
                        if (object[0] != 0L) {
                            OS.g_free(object[0]);
                        }
                        OS.gdk_region_destroy(l8);
                    }
                }
            }
            ++n3;
        }
        if (gdkGCValues != null) {
            n3 = 245761;
            OS.gdk_gc_set_values(l2, gdkGCValues, n3);
            gCData.state &= 0xFFFFFFF7;
        }
        if (l != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            Cairo.cairo_restore(l);
        }
    }

    void freeRuns() {
        if (this.attrList == 0L) {
            return;
        }
        OS.pango_layout_set_attributes(this.layout, 0L);
        OS.pango_attr_list_unref(this.attrList);
        this.attrList = 0L;
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int n = OS.pango_layout_get_alignment(this.layout);
        boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
        switch (n) {
            case 0: {
                return bl ? 131072 : 16384;
            }
            case 2: {
                return bl ? 16384 : 131072;
            }
        }
        return 0x1000000;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(this.layout, nArray, nArray2);
        int n = OS.pango_layout_get_width(this.layout);
        nArray[0] = n != -1 ? n : nArray[0] + OS.pango_layout_get_indent(this.layout);
        int n2 = OS.PANGO_PIXELS(nArray[0]);
        int n3 = OS.PANGO_PIXELS(nArray2[0]);
        if (this.ascent != -1 && this.descent != -1) {
            n3 = Math.max(n3, this.ascent + this.descent);
        }
        return new Rectangle(0, 0, n2, n3);
    }

    public Rectangle getBounds(int n, int n2) {
        long l;
        this.checkLayout();
        this.computeRuns();
        int n3 = this.text.length();
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n3 - 1);
        n2 = Math.min(Math.max(0, n2), n3 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        long l2 = OS.pango_layout_get_text(this.layout);
        int n4 = (int)(OS.g_utf8_offset_to_pointer(l2, n) - l2);
        int n5 = (int)(OS.g_utf8_offset_to_pointer(l2, n2 + 1) - l2);
        int n6 = OS.strlen(l2);
        int[] nArray = new int[]{n4 = Math.min(n4, n6), n5 = Math.min(n5, n6)};
        long l3 = OS.gdk_pango_layout_get_clip_region(this.layout, 0, 0, nArray, 1);
        if (l3 == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        PangoRectangle pangoRectangle = new PangoRectangle();
        long l4 = OS.pango_layout_get_iter(this.layout);
        if (l4 == 0L) {
            SWT.error(2);
        }
        if ((l = OS.gdk_region_new()) == 0L) {
            SWT.error(2);
        }
        int n7 = 0;
        do {
            OS.pango_layout_iter_get_line_extents(l4, null, pangoRectangle);
            n7 = OS.pango_layout_iter_next_line(l4) ? OS.pango_layout_iter_get_index(l4) - 1 : n6;
            if (n4 > n7) continue;
            gdkRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            gdkRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            gdkRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            gdkRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            OS.gdk_region_union_with_rect(l, gdkRectangle);
        } while (n7 + 1 <= n5);
        OS.gdk_region_intersect(l3, l);
        OS.gdk_region_destroy(l);
        OS.pango_layout_iter_free(l4);
        OS.gdk_region_get_clipbox(l3, gdkRectangle);
        OS.gdk_region_destroy(l3);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            gdkRectangle.x = this.width() - gdkRectangle.x - gdkRectangle.width;
        }
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return OS.PANGO_PIXELS(OS.pango_layout_get_indent(this.layout));
    }

    public boolean getJustify() {
        this.checkLayout();
        return OS.pango_layout_get_justify(this.layout);
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        long l = OS.pango_layout_get_iter(this.layout);
        if (l == 0L) {
            SWT.error(2);
        }
        int n3 = 0;
        PangoItem pangoItem = new PangoItem();
        PangoLayoutRun pangoLayoutRun = new PangoLayoutRun();
        long l2 = OS.pango_layout_get_text(this.layout);
        long l3 = OS.g_utf8_offset_to_pointer(l2, n) - l2;
        int n4 = OS.strlen(l2);
        l3 = Math.min(l3, (long)n4);
        do {
            long l4;
            if ((l4 = OS.pango_layout_iter_get_run(l)) == 0L) continue;
            OS.memmove(pangoLayoutRun, l4, (long)PangoLayoutRun.sizeof);
            OS.memmove(pangoItem, pangoLayoutRun.item, (long)PangoItem.sizeof);
            if ((long)pangoItem.offset > l3 || l3 >= (long)(pangoItem.offset + pangoItem.length)) continue;
            n3 = pangoItem.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run(l));
        OS.pango_layout_iter_free(l);
        return n3;
    }

    public Rectangle getLineBounds(int n) {
        long l;
        this.checkLayout();
        this.computeRuns();
        int n2 = OS.pango_layout_get_line_count(this.layout);
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        if ((l = OS.pango_layout_get_iter(this.layout)) == 0L) {
            SWT.error(2);
        }
        int n3 = 0;
        while (n3 < n) {
            OS.pango_layout_iter_next_line(l);
            ++n3;
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_iter_get_line_extents(l, null, pangoRectangle);
        OS.pango_layout_iter_free(l);
        int n4 = OS.PANGO_PIXELS(pangoRectangle.x);
        int n5 = OS.PANGO_PIXELS(pangoRectangle.y);
        int n6 = OS.PANGO_PIXELS(pangoRectangle.width);
        int n7 = OS.PANGO_PIXELS(pangoRectangle.height);
        if (this.ascent != -1 && this.descent != -1) {
            n7 = Math.max(n7, this.ascent + this.descent);
        }
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n4 = this.width() - n4 - n6;
        }
        return new Rectangle(n4, n5, n6, n7);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count(this.layout);
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(5);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        long l = OS.pango_layout_get_text(this.layout);
        long l2 = OS.g_utf8_offset_to_pointer(l, n) - l;
        int n4 = OS.strlen(l);
        l2 = Math.min(l2, (long)n4);
        long l3 = OS.pango_layout_get_iter(this.layout);
        if (l3 == 0L) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line(l3)) {
            if ((long)OS.pango_layout_iter_get_index(l3) > l2) break;
            ++n3;
        }
        OS.pango_layout_iter_free(l3);
        return n3;
    }

    public FontMetrics getLineMetrics(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = OS.pango_layout_get_line_count(this.layout);
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 0;
        int n4 = 0;
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        OS.memmove(pangoLayoutLine, OS.pango_layout_get_line(this.layout, n), (long)PangoLayoutLine.sizeof);
        if (pangoLayoutLine.runs == 0L) {
            long l = this.font != null ? this.font.handle : this.device.systemFont.handle;
            long l2 = OS.pango_context_get_language(this.context);
            long l3 = OS.pango_context_get_metrics(this.context, l, l2);
            n3 = OS.pango_font_metrics_get_ascent(l3);
            n4 = OS.pango_font_metrics_get_descent(l3);
            OS.pango_font_metrics_unref(l3);
        } else {
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_line_get_extents(OS.pango_layout_get_line(this.layout, n), null, pangoRectangle);
            n3 = -pangoRectangle.y;
            n4 = pangoRectangle.height - n3;
        }
        n3 = Math.max(this.ascent, OS.PANGO_PIXELS(n3));
        n4 = Math.max(this.descent, OS.PANGO_PIXELS(n4));
        return FontMetrics.gtk_new(n3, n4, 0, 0, n3 + n4);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int n = OS.pango_layout_get_line_count(this.layout);
        int[] nArray = new int[n + 1];
        long l = OS.pango_layout_get_text(this.layout);
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        int n2 = 0;
        while (n2 < n) {
            long l2 = OS.pango_layout_get_line(this.layout, n2);
            OS.memmove(pangoLayoutLine, l2, (long)PangoLayoutLine.sizeof);
            int n3 = (int)OS.g_utf8_pointer_to_offset(l, l + (long)pangoLayoutLine.start_index);
            nArray[n2] = this.untranslateOffset(n3);
            ++n2;
        }
        nArray[n] = this.text.length();
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        long l = OS.pango_layout_get_text(this.layout);
        int n3 = (int)(OS.g_utf8_offset_to_pointer(l, n) - l);
        int n4 = OS.strlen(l);
        n3 = Math.min(n3, n4);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(this.layout, n3, pangoRectangle);
        int n5 = bl ? pangoRectangle.x + pangoRectangle.width : pangoRectangle.x;
        int n6 = pangoRectangle.y;
        n5 = OS.PANGO_PIXELS(n5);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n5 = this.width() - n5;
        }
        return new Point(n5, OS.PANGO_PIXELS(n6));
    }

    public int getNextOffset(int n, int n2) {
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl) {
            if (n == n4) {
                return n4;
            }
        } else if (n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        long[] lArray = new long[1];
        int[] nArray = new int[1];
        OS.pango_layout_get_log_attrs(this.layout, lArray, nArray);
        if (lArray[0] == 0L) {
            return n + n3;
        }
        n4 = (int)OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1L);
        n = this.translateOffset(n);
        PangoLogAttr pangoLogAttr = new PangoLogAttr();
        n = this.validateOffset(n, n3);
        while (n > 0 && n < n4) {
            OS.memmove(pangoLogAttr, lArray[0] + (long)(n * PangoLogAttr.sizeof), (long)PangoLogAttr.sizeof);
            if ((n2 & 2) != 0 && pangoLogAttr.is_cursor_position || (n2 & 4) != 0 && (!bl ? pangoLogAttr.is_word_start : pangoLogAttr.is_word_end)) break;
            if ((n2 & 0x10) != 0 && pangoLogAttr.is_word_start || (n2 & 8) != 0 && pangoLogAttr.is_word_end) break;
            n = this.validateOffset(n, n3);
        }
        OS.g_free(lArray[0]);
        return Math.min(Math.max(0, this.untranslateOffset(n)), this.text.length());
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        long l;
        this.checkLayout();
        this.computeRuns();
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n = this.width() - n;
        }
        if ((l = OS.pango_layout_get_iter(this.layout)) == 0L) {
            SWT.error(2);
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        do {
            OS.pango_layout_iter_get_line_extents(l, null, pangoRectangle);
            pangoRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            pangoRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            if (pangoRectangle.y > n2 || n2 >= pangoRectangle.y + pangoRectangle.height) continue;
            pangoRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            pangoRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            if (n >= pangoRectangle.x + pangoRectangle.width) {
                n = pangoRectangle.x + pangoRectangle.width - 1;
            }
            if (n >= pangoRectangle.x) break;
            n = pangoRectangle.x;
            break;
        } while (OS.pango_layout_iter_next_line(l));
        OS.pango_layout_iter_free(l);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.pango_layout_xy_to_index(this.layout, n * 1024, n2 * 1024, nArray2, nArray3);
        long l2 = OS.pango_layout_get_text(this.layout);
        int n3 = (int)OS.g_utf8_pointer_to_offset(l2, l2 + (long)nArray2[0]);
        if (nArray != null) {
            nArray[0] = nArray3[0];
        }
        return this.untranslateOffset(n3);
    }

    public int getOrientation() {
        this.checkLayout();
        int n = OS.pango_context_get_base_dir(this.context);
        return n == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int n, int n2) {
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.styles.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int n = this.segments.length;
        if (n <= 1) {
            return this.text;
        }
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (n == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
            return this.text;
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n3 < n2) {
            if (n4 < n && n3 == this.segments[n4]) {
                cArray2[n3 + n4++] = n5;
                continue;
            }
            cArray2[n3 + n4] = cArray[n3++];
        }
        if (n4 < n) {
            this.segments[n4] = n3;
            cArray2[n3 + n4++] = n5;
        }
        return new String(cArray2, 0, Math.min(n3 + n4, cArray2.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.styles.length) {
            StyleItem styleItem = this.styles[n3];
            if (styleItem.start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        int n = OS.pango_layout_get_width(this.layout);
        return n != -1 ? OS.PANGO_PIXELS(n) : -1;
    }

    public boolean isDisposed() {
        return this.layout == 0L;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
        int n3 = 1;
        switch (n) {
            case 16384: {
                n3 = bl ? 2 : 0;
                break;
            }
            case 131072: {
                n3 = bl ? 0 : 2;
            }
        }
        OS.pango_layout_set_alignment(this.layout, n3);
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        OS.pango_layout_set_font_description(this.layout, font != null ? font.handle : 0L);
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        OS.pango_layout_set_indent(this.layout, n * 1024);
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        OS.pango_layout_set_justify(this.layout, bl);
    }

    public void setOrientation(int n) {
        int n2;
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n &= n3) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        int n4 = n2 = n == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir(this.context) == n2) {
            return;
        }
        OS.pango_context_set_base_dir(this.context, n2);
        OS.pango_layout_context_changed(this.layout);
        int n5 = OS.pango_layout_get_alignment(this.layout);
        if (n5 != 1) {
            n5 = n5 == 0 ? 2 : 0;
            OS.pango_layout_set_alignment(this.layout, n5);
        }
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        OS.pango_layout_set_spacing(this.layout, n * 1024);
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        this.checkLayout();
        int n5 = this.text.length();
        if (n5 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n5 - 1);
        n2 = Math.min(Math.max(0, n2), n5 - 1);
        if (n > 0 && TextLayout.isAlef(this.text.charAt(n)) && TextLayout.isLam(this.text.charAt(n - 1))) {
            --n;
        }
        if (n2 < n5 - 1 && TextLayout.isLam(this.text.charAt(n2)) && TextLayout.isAlef(this.text.charAt(n2 + 1))) {
            ++n2;
        }
        int n6 = -1;
        int n7 = this.styles.length;
        while (n7 - n6 > 1) {
            n4 = (n7 + n6) / 2;
            if (this.styles[n4 + 1].start > n) {
                n7 = n4;
                continue;
            }
            n6 = n4;
        }
        if (n7 >= 0 && n7 < this.styles.length) {
            StyleItem styleItem = this.styles[n7];
            if (styleItem.start == n && this.styles[n7 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n8 = n4 = n7;
        while (n8 < this.styles.length) {
            if (this.styles[n8 + 1].start > n2) break;
            ++n8;
        }
        if (n4 == n8) {
            n3 = this.styles[n4].start;
            int n9 = this.styles[n8 + 1].start - 1;
            if (n3 == n && n9 == n2) {
                this.styles[n4].style = textStyle;
                return;
            }
            if (n3 != n && n9 != n2) {
                StyleItem[] styleItemArray = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                styleItemArray[n4 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n4].style;
                styleItemArray[n4 + 2] = styleItem;
                System.arraycopy(this.styles, n8 + 1, styleItemArray, n8 + 3, this.styles.length - n8 - 1);
                this.styles = styleItemArray;
                return;
            }
        }
        if (n == this.styles[n4].start) {
            --n4;
        }
        if (n2 == this.styles[n8 + 1].start - 1) {
            ++n8;
        }
        n3 = this.styles.length + 1 - (n8 - n4 - 1);
        StyleItem[] styleItemArray = new StyleItem[n3];
        System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        styleItemArray[n4 + 1] = styleItem;
        this.styles[n8].start = n2 + 1;
        System.arraycopy(this.styles, n8, styleItemArray, n4 + 2, this.styles.length - n8);
        this.styles = styleItemArray;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.tabs = nArray;
        if (nArray == null) {
            OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        } else {
            long l = OS.pango_tab_array_new(nArray.length, true);
            if (l != 0L) {
                int n = 0;
                while (n < nArray.length) {
                    OS.pango_tab_array_set_tab(l, n, 0L, nArray[n]);
                    ++n;
                }
                OS.pango_layout_set_tabs(this.layout, l);
                OS.pango_tab_array_free(l);
            }
        }
        OS.pango_layout_context_changed(this.layout);
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[this.styles.length - 1].start = string.length();
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        this.freeRuns();
        if (n == -1) {
            OS.pango_layout_set_width(this.layout, -1);
            boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
            OS.pango_layout_set_alignment(this.layout, bl ? 2 : 0);
        } else {
            OS.pango_layout_set_width(this.layout, n * 1024);
        }
    }

    static final boolean isLam(int n) {
        return n == 1604;
    }

    static final boolean isAlef(int n) {
        switch (n) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.invalidOffsets.length) {
            if (n < this.invalidOffsets[n3]) break;
            ++n;
            ++n3;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.invalidOffsets.length) {
            if (n == this.invalidOffsets[n3]) {
                ++n;
            } else if (n < this.invalidOffsets[n3]) {
                return n - n3;
            }
            ++n3;
        }
        return n - this.invalidOffsets.length;
    }

    int validateOffset(int n, int n2) {
        if (this.invalidOffsets == null) {
            return n + n2;
        }
        int n3 = n2 > 0 ? 0 : this.invalidOffsets.length - 1;
        block0: do {
            n += n2;
            while (n3 >= 0 && n3 < this.invalidOffsets.length) {
                if (this.invalidOffsets[n3] == n) continue block0;
                n3 += n2;
            }
        } while (n3 >= 0 && n3 < this.invalidOffsets.length);
        return n;
    }

    int width() {
        int n = OS.pango_layout_get_width(this.layout);
        if (n != -1) {
            return OS.PANGO_PIXELS(n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(this.layout, nArray, nArray2);
        return OS.PANGO_PIXELS(nArray[0] + OS.pango_layout_get_indent(this.layout));
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

