/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Vector;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.SimpleEnumerator;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider2;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;

class AppFileLocProvider {
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath;
    String profilePath;
    String[] pluginDirs;
    static final String SEPARATOR_OS = System.getProperty("file.separator");
    static final String CHROME_DIR = "chrome";
    static final String COMPONENTS_DIR = "components";
    static final String HISTORY_FILE = "history.dat";
    static final String LOCALSTORE_FILE = "localstore.rdf";
    static final String MIMETYPES_FILE = "mimeTypes.rdf";
    static final String PLUGINS_DIR = "plugins";
    static final String USER_PLUGINS_DIR = ".mozilla" + SEPARATOR_OS + "plugins";
    static final String PREFERENCES_FILE = "prefs.js";

    AppFileLocProvider(String string) {
        this.mozillaPath = String.valueOf(string) + SEPARATOR_OS;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 3;
        this.directoryServiceProvider = new XPCOMObject(nArray2){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return AppFileLocProvider.this.getFile(lArray[0], lArray[1], lArray[2]);
            }
        };
        int[] nArray3 = new int[5];
        nArray3[0] = 2;
        nArray3[3] = 3;
        nArray3[4] = 2;
        this.directoryServiceProvider2 = new XPCOMObject(nArray3){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return AppFileLocProvider.this.getFile(lArray[0], lArray[1], lArray[2]);
            }

            public long method4(long[] lArray) {
                return AppFileLocProvider.this.getFiles(lArray[0], lArray[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    long getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(l2, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIDirectoryServiceProvider.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove(l2, new long[]{this.directoryServiceProvider.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIDirectoryServiceProvider2.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove(l2, new long[]{this.directoryServiceProvider2.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(l2, new long[1], (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void setProfilePath(String string) {
        this.profilePath = string;
        if (!Compatibility.fileExists(string, "")) {
            long[] lArray = new long[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string);
            int n = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), true, lArray);
            if (n != 0) {
                Mozilla.error(n);
            }
            if (lArray[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(lArray[0]);
            n = nsILocalFile2.Create(1, 448);
            if (n != 0) {
                Mozilla.error(n);
            }
            nsILocalFile2.Release();
        }
    }

    int getFiles(long l, long l2) {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2 = XPCOM.strlen(l);
        byte[] byArray = new byte[n2];
        XPCOM.memmove(byArray, l, (long)n2);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String[] stringArray = null;
        if (string.equals("APluginsDL")) {
            if (this.pluginDirs == null) {
                int n3 = 0;
                long l3 = C.getenv(MozillaDelegate.wcsToMbcs(null, "MOZ_PLUGIN_PATH", true));
                if (l3 != 0L) {
                    n = C.strlen(l3);
                    object3 = new byte[n];
                    C.memmove((byte[])object3, l3, (long)n);
                    String string2 = new String(MozillaDelegate.mbcsToWcs(null, (byte[])object3));
                    if (string2.length() > 0) {
                        object2 = System.getProperty("path.separator");
                        object = new Vector<String>();
                        int n4 = -1;
                        do {
                            int n5;
                            String string3;
                            if ((string3 = (n4 = string2.indexOf((String)object2, n5 = n4 + 1)) == -1 ? string2.substring(n5) : string2.substring(n5, n4)).length() <= 0) continue;
                            ((Vector)object).addElement(string3);
                        } while (n4 != -1);
                        int n6 = ((Vector)object).size();
                        this.pluginDirs = new String[n6 + 2];
                        n3 = 0;
                        while (n3 < n6) {
                            this.pluginDirs[n3] = (String)((Vector)object).elementAt(n3);
                            ++n3;
                        }
                    }
                }
                if (this.pluginDirs == null) {
                    this.pluginDirs = new String[2];
                }
                this.pluginDirs[n3++] = String.valueOf(this.mozillaPath) + PLUGINS_DIR;
                this.pluginDirs[n3++] = String.valueOf(System.getProperty("user.home")) + SEPARATOR_OS + USER_PLUGINS_DIR;
            }
            stringArray = this.pluginDirs;
        }
        XPCOM.memmove(l2, new long[1], (long)C.PTR_SIZEOF);
        if (stringArray != null) {
            long[] lArray = new long[1];
            nsISupports[] nsISupportsArray = new nsISupports[stringArray.length];
            int n7 = 0;
            n = 0;
            while (n < stringArray.length) {
                object3 = new nsEmbedString(stringArray[n]);
                int n8 = XPCOM.NS_NewLocalFile(((nsEmbedString)object3).getAddress(), true, lArray);
                if (n8 != -2142109695) {
                    if (n8 != 0) {
                        Mozilla.error(n8);
                    }
                    if (lArray[0] == 0L) {
                        Mozilla.error(-2147467261);
                    }
                    object2 = new nsILocalFile(lArray[0]);
                    lArray[0] = 0L;
                    n8 = ((nsISupports)object2).QueryInterface(nsIFile.NS_IFILE_IID, lArray);
                    if (n8 != 0) {
                        Mozilla.error(n8);
                    }
                    if (lArray[0] == 0L) {
                        Mozilla.error(-2147467261);
                    }
                    ((nsISupports)object2).Release();
                    object = new nsIFile(lArray[0]);
                    nsISupportsArray[n7++] = object;
                }
                ((nsEmbedString)object3).dispose();
                lArray[0] = 0L;
                ++n;
            }
            if (n7 < stringArray.length) {
                nsISupports[] nsISupportsArray2 = new nsISupports[n7];
                System.arraycopy(nsISupportsArray, 0, nsISupportsArray2, 0, n7);
                nsISupportsArray = nsISupportsArray2;
            }
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator(nsISupportsArray);
            simpleEnumerator.AddRef();
            XPCOM.memmove(l2, new long[]{simpleEnumerator.getAddress()}, (long)C.PTR_SIZEOF);
            return 0;
        }
        return -2147467259;
    }

    int getFile(long l, long l2, long l3) {
        int n = XPCOM.strlen(l);
        byte[] byArray = new byte[n];
        XPCOM.memmove(byArray, l, (long)n);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String string2 = null;
        if (string.equals("UHist")) {
            string2 = String.valueOf(this.profilePath) + HISTORY_FILE;
        } else if (string.equals("UMimTyp")) {
            string2 = String.valueOf(this.profilePath) + MIMETYPES_FILE;
        } else if (string.equals("PrefF")) {
            string2 = String.valueOf(this.profilePath) + PREFERENCES_FILE;
        } else if (string.equals("PrefD")) {
            string2 = this.profilePath;
        } else if (string.equals("UChrm")) {
            string2 = String.valueOf(this.profilePath) + CHROME_DIR;
        } else if (string.equals("ProfD")) {
            string2 = this.profilePath;
        } else if (string.equals("LclSt")) {
            string2 = String.valueOf(this.profilePath) + LOCALSTORE_FILE;
        } else if (string.equals("cachePDir")) {
            string2 = this.profilePath;
        } else if (string.equals("Home")) {
            string2 = System.getProperty("user.home");
        } else if (string.equals("TmpD")) {
            string2 = System.getProperty("java.io.tmpdir");
        } else if (string.equals("GreD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("GreComsD")) {
            string2 = String.valueOf(this.mozillaPath) + COMPONENTS_DIR;
        } else if (string.equals("MozBinD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("CurProcD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("ComsD")) {
            string2 = String.valueOf(this.mozillaPath) + COMPONENTS_DIR;
        } else if (string.equals("XCurProcD")) {
            string2 = this.mozillaPath;
        } else {
            string.equals("PrfDef");
        }
        XPCOM.memmove(l2, new int[]{1}, 4L);
        XPCOM.memmove(l3, new long[1], (long)C.PTR_SIZEOF);
        if (string2 != null && string2.length() > 0) {
            long[] lArray = new long[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n2 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), true, lArray);
            if (n2 != 0) {
                Mozilla.error(n2);
            }
            if (lArray[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(lArray[0]);
            lArray[0] = 0L;
            n2 = nsILocalFile2.QueryInterface(nsIFile.NS_IFILE_IID, lArray);
            if (n2 != 0) {
                Mozilla.error(n2);
            }
            if (lArray[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            XPCOM.memmove(l3, new long[]{lArray[0]}, (long)C.PTR_SIZEOF);
            nsILocalFile2.Release();
            return 0;
        }
        return -2147467259;
    }
}

