/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.List;
import org.herac.tuxguitar.player.base.MidiRepeatController;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;

public class MidiSequenceParser {
    private static final int DEFAULT_METRONOME_KEY = 37;
    private static final int DEFAULT_DEAD_NOTE_DURATION = 50;
    private static final int DEFAULT_BEND = 64;
    private static final float DEFAULT_BEND_SEMI_TONE = 2.75f;
    public static final int ADD_DEFAULT_CONTROLS = 1;
    public static final int ADD_MIXER_MESSAGES = 2;
    public static final int ADD_METRONOME = 4;
    public static final int ADD_FIRST_TICK_MOVE = 8;
    public static final int DEFAULT_PLAY_FLAGS = 4;
    public static final int DEFAULT_EXPORT_FLAGS = 11;
    private TGSongManager manager;
    private int flags;
    private int infoTrack;
    private int metronomeTrack;
    private int fisrtTickMove;
    private int tempoPercent;
    private int transpose;

    public MidiSequenceParser(TGSongManager tGSongManager, int n, int n2, int n3) {
        this.manager = tGSongManager;
        this.flags = n;
        this.transpose = n3;
        this.tempoPercent = n2;
        this.fisrtTickMove = (int)((n & 8) != 0 ? -1000L : 0L);
    }

    public MidiSequenceParser(TGSongManager tGSongManager, int n) {
        this(tGSongManager, n, 100, 0);
    }

    public void parse(MidiSequenceHandler midiSequenceHandler) {
        this.infoTrack = midiSequenceHandler.getInfoTrack();
        this.metronomeTrack = midiSequenceHandler.getMetronomeTrack();
        this.addDefaultMessages(midiSequenceHandler);
        for (int i = 0; i < this.manager.getSong().countTracks(); ++i) {
            TGTrack tGTrack = this.manager.getSong().getTrack(i);
            this.createTrack(midiSequenceHandler, tGTrack);
        }
        midiSequenceHandler.notifyFinish();
    }

    private int infoIndex() {
        return this.infoTrack;
    }

    private int metronomeIndex() {
        return this.metronomeTrack;
    }

    private long getTick(long l) {
        return l + (long)this.fisrtTickMove;
    }

    private void createTrack(MidiSequenceHandler midiSequenceHandler, TGTrack tGTrack) {
        TGMeasure tGMeasure = null;
        MidiRepeatController midiRepeatController = new MidiRepeatController(tGTrack.getSong());
        this.addBend(midiSequenceHandler, tGTrack.getNumber(), 1000L, 64, tGTrack.getChannel().getChannel());
        this.makeChannel(midiSequenceHandler, tGTrack.getChannel(), tGTrack.getNumber());
        while (!midiRepeatController.finished()) {
            TGMeasure tGMeasure2 = tGTrack.getMeasure(midiRepeatController.getIndex());
            int n = midiRepeatController.getIndex();
            long l = midiRepeatController.getRepeatMove();
            midiRepeatController.process();
            if (midiRepeatController.shouldPlay()) {
                if (tGTrack.getNumber() == 1) {
                    this.addTimeSignature(midiSequenceHandler, tGMeasure2, tGMeasure, l);
                    this.addTempo(midiSequenceHandler, tGMeasure2, tGMeasure, l);
                    this.addMetronome(midiSequenceHandler, tGMeasure2.getHeader(), l);
                }
                this.makeBeats(midiSequenceHandler, tGTrack.getNumber(), tGTrack, tGMeasure2, n, l);
            }
            tGMeasure = tGMeasure2;
        }
    }

    private void makeBeats(MidiSequenceHandler midiSequenceHandler, int n, TGTrack tGTrack, TGMeasure tGMeasure, int n2, long l) {
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            this.makeNotes(midiSequenceHandler, n, tGTrack, tGBeat, n2, i, l);
        }
    }

    private void makeNotes(MidiSequenceHandler midiSequenceHandler, int n, TGTrack tGTrack, TGBeat tGBeat, int n2, int n3, long l) {
        BeatData beatData = this.checkTripletFeel(tGBeat, n3);
        for (int i = 0; i < tGBeat.countNotes(); ++i) {
            int n4;
            int n5;
            int n6;
            TGNote tGNote = tGBeat.getNote(i);
            if (tGNote.isTiedNote()) continue;
            int n7 = this.transpose + tGTrack.getOffset() + tGNote.getValue() + ((TGString)tGTrack.getStrings().get(tGNote.getString() - 1)).getValue();
            long l2 = beatData.getStart() + l;
            long l3 = this.getRealNoteDuration(tGNote, beatData.getDuration(), tGTrack, n2, n3);
            int n8 = this.getRealVelocity(tGNote, tGTrack, n2, n3);
            short s = tGTrack.getChannel().getChannel();
            short s2 = tGTrack.getChannel().getEffectChannel();
            boolean bl = tGTrack.isPercussionTrack();
            if (tGNote.getEffect().isFadeIn()) {
                s = s2;
                this.makeFadeIn(midiSequenceHandler, n, l2, l3, tGTrack.getChannel().getVolume(), s);
            }
            if (tGNote.getEffect().isGrace() && s2 >= 0 && !bl) {
                s = s2;
                n6 = tGTrack.getOffset() + tGNote.getEffect().getGrace().getFret() + ((TGString)tGTrack.getStrings().get(tGNote.getString() - 1)).getValue();
                n5 = tGNote.getEffect().getGrace().getDurationTime();
                int n9 = tGNote.getEffect().getGrace().isDead() ? 50 : n5;
                n4 = tGNote.getEffect().getGrace().getDynamic();
                if (tGNote.getEffect().getGrace().isOnBeat() || l2 - (long)n5 < 1000L) {
                    l2 += (long)n5;
                    l3 -= (long)n5;
                }
                this.makeNote(midiSequenceHandler, n, n6, l2 - (long)n5, n9, n4, s);
            }
            if (tGNote.getEffect().isTrill() && s2 >= 0 && !bl) {
                n6 = tGTrack.getOffset() + tGNote.getEffect().getTrill().getFret() + ((TGString)tGTrack.getStrings().get(tGNote.getString() - 1)).getValue();
                long l4 = tGNote.getEffect().getTrill().getDuration().getTime();
                n4 = 1;
                long l5 = l2;
                while (l5 + 10L < l2 + l3) {
                    if (l5 + l4 >= l2 + l3) {
                        l4 = l2 + l3 - l5 - 1L;
                    }
                    this.makeNote(midiSequenceHandler, n, n4 != 0 ? n7 : n6, l5, l4, n8, s);
                    n4 = n4 == 0 ? 1 : 0;
                    l5 += l4;
                }
                continue;
            }
            if (tGNote.getEffect().isTremoloPicking() && s2 >= 0) {
                long l6 = tGNote.getEffect().getTremoloPicking().getDuration().getTime();
                long l7 = l2;
                while (l7 + 10L < l2 + l3) {
                    if (l7 + l6 >= l2 + l3) {
                        l6 = l2 + l3 - l7 - 1L;
                    }
                    this.makeNote(midiSequenceHandler, n, n7, l7, l6, n8, s);
                    l7 += l6;
                }
                continue;
            }
            if (tGNote.getEffect().isBend() && s2 >= 0 && !bl) {
                s = s2;
                this.makeBend(midiSequenceHandler, n, l2, l3, tGNote.getEffect().getBend(), s);
            } else if (tGNote.getEffect().isTremoloBar() && s2 >= 0 && !bl) {
                s = s2;
                this.makeTremoloBar(midiSequenceHandler, n, l2, l3, tGNote.getEffect().getTremoloBar(), s);
            } else if (tGNote.getEffect().isSlide() && s2 >= 0 && !bl) {
                s = s2;
                TGNote tGNote2 = this.getNextNote(tGNote, tGTrack, n2, n3);
                this.makeSlide(midiSequenceHandler, n, tGNote, tGNote2, l, s);
            } else if (tGNote.getEffect().isVibrato() && s2 >= 0 && !bl) {
                s = s2;
                this.makeVibrato(midiSequenceHandler, n, l2, l3, s);
            }
            if (tGNote.getEffect().isHarmonic() && !bl) {
                n6 = n7;
                if (tGNote.getEffect().getHarmonic().isNatural()) {
                    for (n5 = 0; n5 < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++n5) {
                        if (tGNote.getValue() % 12 != TGEffectHarmonic.NATURAL_FREQUENCIES[n5][0] % 12) continue;
                        n7 = n6 + TGEffectHarmonic.NATURAL_FREQUENCIES[n5][1] - tGNote.getValue();
                        break;
                    }
                } else {
                    if (tGNote.getEffect().getHarmonic().isSemi() && !bl) {
                        this.makeNote(midiSequenceHandler, n, Math.min(127, n6), l2, l3, Math.max(15, n8 - 48), s);
                    }
                    n7 = n6 + TGEffectHarmonic.NATURAL_FREQUENCIES[tGNote.getEffect().getHarmonic().getData()][1];
                }
                if (n7 - 12 > 0) {
                    n5 = Math.max(15, n8 - 64);
                    this.makeNote(midiSequenceHandler, n, n7 - 12, l2, l3, n5, s);
                }
            }
            this.makeNote(midiSequenceHandler, n, Math.min(127, n7), l2, l3, n8, s);
        }
    }

    private void makeNote(MidiSequenceHandler midiSequenceHandler, int n, int n2, long l, long l2, int n3, int n4) {
        midiSequenceHandler.addNoteOn(this.getTick(l), n, n4, n2, n3);
        midiSequenceHandler.addNoteOff(this.getTick(l + l2), n, n4, n2, n3);
    }

    private void makeChannel(MidiSequenceHandler midiSequenceHandler, TGChannel tGChannel, int n) {
        if ((this.flags & 2) != 0) {
            this.makeChannel(midiSequenceHandler, tGChannel, n, true);
            if (tGChannel.getChannel() != tGChannel.getEffectChannel()) {
                this.makeChannel(midiSequenceHandler, tGChannel, n, false);
            }
        }
    }

    private void makeChannel(MidiSequenceHandler midiSequenceHandler, TGChannel tGChannel, int n, boolean bl) {
        short s = bl ? tGChannel.getChannel() : tGChannel.getEffectChannel();
        midiSequenceHandler.addControlChange(this.getTick(1000L), n, s, 7, tGChannel.getVolume());
        midiSequenceHandler.addControlChange(this.getTick(1000L), n, s, 10, tGChannel.getBalance());
        midiSequenceHandler.addControlChange(this.getTick(1000L), n, s, 93, tGChannel.getChorus());
        midiSequenceHandler.addControlChange(this.getTick(1000L), n, s, 91, tGChannel.getReverb());
        midiSequenceHandler.addControlChange(this.getTick(1000L), n, s, 95, tGChannel.getPhaser());
        midiSequenceHandler.addControlChange(this.getTick(1000L), n, s, 92, tGChannel.getTremolo());
        midiSequenceHandler.addProgramChange(this.getTick(1000L), n, s, tGChannel.getInstrument());
    }

    private void addTimeSignature(MidiSequenceHandler midiSequenceHandler, TGMeasure tGMeasure, TGMeasure tGMeasure2, long l) {
        boolean bl = false;
        if (tGMeasure2 == null) {
            bl = true;
        } else {
            int n = tGMeasure.getTimeSignature().getNumerator();
            int n2 = tGMeasure.getTimeSignature().getDenominator().getValue();
            int n3 = tGMeasure2.getTimeSignature().getNumerator();
            int n4 = tGMeasure2.getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                bl = true;
            }
        }
        if (bl) {
            midiSequenceHandler.addTimeSignature(this.getTick(tGMeasure.getStart() + l), this.infoIndex(), tGMeasure.getTimeSignature());
        }
    }

    private void addTempo(MidiSequenceHandler midiSequenceHandler, TGMeasure tGMeasure, TGMeasure tGMeasure2, long l) {
        boolean bl = false;
        if (tGMeasure2 == null) {
            bl = true;
        } else if (tGMeasure.getTempo().getInUSQ() != tGMeasure2.getTempo().getInUSQ()) {
            bl = true;
        }
        if (bl) {
            int n = (int)((double)tGMeasure.getTempo().getInUSQ() * 100.0 / (double)this.tempoPercent);
            midiSequenceHandler.addTempoInUSQ(this.getTick(tGMeasure.getStart() + l), this.infoIndex(), n);
        }
    }

    private long getRealNoteDuration(TGNote tGNote, long l, TGTrack tGTrack, int n, int n2) {
        if (tGNote.getEffect().isDeadNote()) {
            return 50L;
        }
        long l2 = l;
        int n3 = n2 + 1;
        int n4 = tGTrack.countMeasures();
        for (int i = n; i < n4; ++i) {
            TGMeasure tGMeasure = tGTrack.getMeasure(i);
            int n5 = tGMeasure.countBeats();
            for (int j = n3; j < n5; ++j) {
                TGBeat tGBeat = tGMeasure.getBeat(j);
                int n6 = tGBeat.countNotes();
                for (int k = 0; k < n6; ++k) {
                    TGNote tGNote2 = tGBeat.getNote(k);
                    if (tGNote2.equals(tGNote) || tGNote2.getString() != tGNote.getString()) continue;
                    if (tGNote2.isTiedNote()) {
                        l2 += tGNote2.getBeat().getDuration().getTime();
                        continue;
                    }
                    return this.applyDurationEffects(tGNote, l2);
                }
            }
            n3 = 0;
        }
        return this.applyDurationEffects(tGNote, l2);
    }

    private long applyDurationEffects(TGNote tGNote, long l) {
        if (tGNote.getEffect().isPalmMute()) {
            return (long)((double)l * 75.0 / 100.0);
        }
        if (tGNote.getEffect().isStaccato()) {
            return (long)((double)l * 50.0 / 100.0);
        }
        return l;
    }

    private int getRealVelocity(TGNote tGNote, TGTrack tGTrack, int n, int n2) {
        TGNote tGNote2;
        int n3 = tGNote.getVelocity();
        if (!tGTrack.isPercussionTrack() && (tGNote2 = this.getPreviousNote(tGNote, tGTrack, n, n2)) != null && tGNote2.getEffect().isHammer()) {
            n3 = Math.max(15, n3 - 25);
        }
        if (tGNote.getEffect().isGhostNote()) {
            n3 = Math.max(15, n3 - 16);
        } else if (tGNote.getEffect().isAccentuatedNote()) {
            n3 = Math.max(15, n3 + 16);
        } else if (tGNote.getEffect().isHeavyAccentuatedNote()) {
            n3 = Math.max(15, n3 + 32);
        }
        return n3 > 127 ? 127 : n3;
    }

    public void addMetronome(MidiSequenceHandler midiSequenceHandler, TGMeasureHeader tGMeasureHeader, long l) {
        if ((this.flags & 4) != 0) {
            long l2 = l + tGMeasureHeader.getStart();
            long l3 = tGMeasureHeader.getTimeSignature().getDenominator().getTime();
            for (int i = 1; i <= tGMeasureHeader.getTimeSignature().getNumerator(); ++i) {
                this.makeNote(midiSequenceHandler, this.metronomeIndex(), 37, l2, l3, 95, 9);
                l2 += l3;
            }
        }
    }

    public void addDefaultMessages(MidiSequenceHandler midiSequenceHandler) {
        if ((this.flags & 1) != 0) {
            for (int i = 0; i < 16; ++i) {
                midiSequenceHandler.addControlChange(this.getTick(1000L), this.infoIndex(), i, 101, 0);
                midiSequenceHandler.addControlChange(this.getTick(1000L), this.infoIndex(), i, 100, 0);
                midiSequenceHandler.addControlChange(this.getTick(1000L), this.infoIndex(), i, 6, 12);
                midiSequenceHandler.addControlChange(this.getTick(1000L), this.infoIndex(), i, 38, 0);
            }
        }
    }

    private void addBend(MidiSequenceHandler midiSequenceHandler, int n, long l, int n2, int n3) {
        midiSequenceHandler.addPitchBend(this.getTick(l), n, n3, n2);
    }

    public void makeVibrato(MidiSequenceHandler midiSequenceHandler, int n, long l, long l2, int n2) {
        long l3 = l;
        long l4 = l3 + l2;
        while (l3 < l4) {
            l3 = l3 + 160L > l4 ? l4 : l3 + 160L;
            this.addBend(midiSequenceHandler, n, l3, 64, n2);
            l3 = l3 + 160L > l4 ? l4 : l3 + 160L;
            this.addBend(midiSequenceHandler, n, l3, 65, n2);
        }
        this.addBend(midiSequenceHandler, n, l3, 64, n2);
    }

    public void makeBend(MidiSequenceHandler midiSequenceHandler, int n, long l, long l2, TGEffectBend tGEffectBend, int n2) {
        List list = tGEffectBend.getPoints();
        for (int i = 0; i < list.size(); ++i) {
            TGEffectBend.BendPoint bendPoint = (TGEffectBend.BendPoint)list.get(i);
            long l3 = l + bendPoint.getTime(l2);
            int n3 = 64 + (int)((float)bendPoint.getValue() * 2.75f / 1.0f);
            n3 = n3 <= 127 ? n3 : 127;
            n3 = n3 >= 0 ? n3 : 0;
            this.addBend(midiSequenceHandler, n, l3, n3, n2);
            if (list.size() <= i + 1) continue;
            TGEffectBend.BendPoint bendPoint2 = (TGEffectBend.BendPoint)list.get(i + 1);
            int n4 = 64 + (int)((float)bendPoint2.getValue() * 2.75f / 1.0f);
            long l4 = l + bendPoint2.getTime(l2);
            if (n4 == n3) continue;
            double d = (l4 - l3) / (long)Math.abs(n4 - n3);
            if (n3 < n4) {
                while (n3 < n4) {
                    l3 = (long)((double)l3 + d);
                    this.addBend(midiSequenceHandler, n, l3, ++n3 <= 127 ? n3 : 127, n2);
                }
                continue;
            }
            if (n3 <= n4) continue;
            while (n3 > n4) {
                l3 = (long)((double)l3 + d);
                this.addBend(midiSequenceHandler, n, l3, --n3 >= 0 ? n3 : 0, n2);
            }
        }
        this.addBend(midiSequenceHandler, n, l + l2, 64, n2);
    }

    public void makeTremoloBar(MidiSequenceHandler midiSequenceHandler, int n, long l, long l2, TGEffectTremoloBar tGEffectTremoloBar, int n2) {
        List list = tGEffectTremoloBar.getPoints();
        for (int i = 0; i < list.size(); ++i) {
            TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint = (TGEffectTremoloBar.TremoloBarPoint)list.get(i);
            long l3 = l + tremoloBarPoint.getTime(l2);
            int n3 = 64 + (int)((float)tremoloBarPoint.getValue() * 5.5f);
            n3 = n3 <= 127 ? n3 : 127;
            n3 = n3 >= 0 ? n3 : 0;
            this.addBend(midiSequenceHandler, n, l3, n3, n2);
            if (list.size() <= i + 1) continue;
            TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint2 = (TGEffectTremoloBar.TremoloBarPoint)list.get(i + 1);
            int n4 = 64 + (int)((float)tremoloBarPoint2.getValue() * 5.5f);
            long l4 = l + tremoloBarPoint2.getTime(l2);
            if (n4 == n3) continue;
            double d = (l4 - l3) / (long)Math.abs(n4 - n3);
            if (n3 < n4) {
                while (n3 < n4) {
                    l3 = (long)((double)l3 + d);
                    this.addBend(midiSequenceHandler, n, l3, ++n3 <= 127 ? n3 : 127, n2);
                }
                continue;
            }
            if (n3 <= n4) continue;
            while (n3 > n4) {
                l3 = (long)((double)l3 + d);
                this.addBend(midiSequenceHandler, n, l3, --n3 >= 0 ? n3 : 0, n2);
            }
        }
        this.addBend(midiSequenceHandler, n, l + l2, 64, n2);
    }

    public void makeSlide(MidiSequenceHandler midiSequenceHandler, int n, TGNote tGNote, TGNote tGNote2, long l, int n2) {
        if (tGNote2 != null) {
            this.makeSlide(midiSequenceHandler, n, tGNote.getBeat().getStart() + l, tGNote.getValue(), tGNote2.getBeat().getStart() + l, tGNote2.getValue(), n2);
            this.addBend(midiSequenceHandler, n, tGNote2.getBeat().getStart() + l, 64, n2);
        }
    }

    public void makeSlide(MidiSequenceHandler midiSequenceHandler, int n, long l, int n2, long l2, int n3, int n4) {
        long l3 = n3 - n2;
        long l4 = l2 - l;
        int n5 = (int)(l4 / 125L);
        for (int i = 1; i <= n5; ++i) {
            float f = (float)(l4 / (long)n5) * (float)i * (float)l3 / (float)l4;
            int n6 = 64 + (int)(f * 5.5f);
            this.addBend(midiSequenceHandler, n, l + l4 / (long)n5 * (long)i, n6, n4);
        }
    }

    private void makeFadeIn(MidiSequenceHandler midiSequenceHandler, int n, long l, long l2, int n2, int n3) {
        int n4 = 40;
        if (n2 > n4) {
            int n5 = (int)(l2 / 4L);
            int n6 = (int)(l2 / (long)n5);
            int n7 = (n2 - n4) / n6;
            for (long i = l; i < l + l2; i += (long)n5) {
                midiSequenceHandler.addControlChange(this.getTick(i), n, n3, 7, n4);
                n4 += n7;
            }
            midiSequenceHandler.addControlChange(this.getTick(l + l2), n, n3, 7, n2);
        }
    }

    private BeatData checkTripletFeel(TGBeat tGBeat, int n) {
        long l = this.fixStart(tGBeat.getStart());
        long l2 = tGBeat.getDuration().getTime();
        if (tGBeat.getMeasure().getTripletFeel() == 2) {
            if (tGBeat.getDuration().isEqual(this.newDuration(8))) {
                TGBeat tGBeat2;
                if (l % 1000L == 0L) {
                    TGBeat tGBeat3 = this.getNextBeat(tGBeat, n);
                    if (tGBeat3 == null || this.fixStart(tGBeat3.getStart()) > l + tGBeat.getDuration().getTime() || tGBeat3.getDuration().isEqual(this.newDuration(8))) {
                        TGDuration tGDuration = this.newDuration(8);
                        tGDuration.getTupleto().setEnters(3);
                        tGDuration.getTupleto().setTimes(2);
                        l2 = tGDuration.getTime() * 2L;
                    }
                } else if (l % 500L == 0L && ((tGBeat2 = this.getPreviousBeat(tGBeat, n)) == null || this.fixStart(tGBeat2.getStart()) < l - tGBeat.getDuration().getTime() || tGBeat2.getDuration().isEqual(this.newDuration(8)))) {
                    TGDuration tGDuration = this.newDuration(8);
                    tGDuration.getTupleto().setEnters(3);
                    tGDuration.getTupleto().setTimes(2);
                    l = l - tGBeat.getDuration().getTime() + tGDuration.getTime() * 2L;
                    l2 = tGDuration.getTime();
                }
            }
        } else if (tGBeat.getMeasure().getTripletFeel() == 3 && tGBeat.getDuration().isEqual(this.newDuration(16))) {
            TGBeat tGBeat4;
            if (l % 500L == 0L) {
                TGBeat tGBeat5 = this.getNextBeat(tGBeat, n);
                if (tGBeat5 == null || this.fixStart(tGBeat5.getStart()) > l + tGBeat.getDuration().getTime() || tGBeat5.getDuration().isEqual(this.newDuration(16))) {
                    TGDuration tGDuration = this.newDuration(16);
                    tGDuration.getTupleto().setEnters(3);
                    tGDuration.getTupleto().setTimes(2);
                    l2 = tGDuration.getTime() * 2L;
                }
            } else if (l % 250L == 0L && ((tGBeat4 = this.getPreviousBeat(tGBeat, n)) == null || this.fixStart(tGBeat4.getStart()) < l - tGBeat.getDuration().getTime() || tGBeat4.getDuration().isEqual(this.newDuration(16)))) {
                TGDuration tGDuration = this.newDuration(16);
                tGDuration.getTupleto().setEnters(3);
                tGDuration.getTupleto().setTimes(2);
                l = l - tGBeat.getDuration().getTime() + tGDuration.getTime() * 2L;
                l2 = tGDuration.getTime();
            }
        }
        return new BeatData(l, l2);
    }

    private TGDuration newDuration(int n) {
        TGDuration tGDuration = this.manager.getFactory().newDuration();
        tGDuration.setValue(n);
        return tGDuration;
    }

    private TGBeat getPreviousBeat(TGBeat tGBeat, int n) {
        TGBeat tGBeat2 = null;
        for (int i = n - 1; i >= 0; --i) {
            TGBeat tGBeat3 = tGBeat.getMeasure().getBeat(i);
            if (tGBeat3.getStart() >= tGBeat.getStart() || tGBeat2 != null && tGBeat3.getStart() <= tGBeat2.getStart()) continue;
            tGBeat2 = tGBeat3;
        }
        return tGBeat2;
    }

    private TGBeat getNextBeat(TGBeat tGBeat, int n) {
        TGBeat tGBeat2 = null;
        for (int i = n + 1; i < tGBeat.getMeasure().countBeats(); ++i) {
            TGBeat tGBeat3 = tGBeat.getMeasure().getBeat(i);
            if (tGBeat3.getStart() <= tGBeat.getStart() || tGBeat2 != null && tGBeat3.getStart() >= tGBeat2.getStart()) continue;
            tGBeat2 = tGBeat3;
        }
        return tGBeat2;
    }

    private TGNote getNextNote(TGNote tGNote, TGTrack tGTrack, int n, int n2) {
        int n3 = n2 + 1;
        int n4 = tGTrack.countMeasures();
        for (int i = n; i < n4; ++i) {
            TGMeasure tGMeasure = tGTrack.getMeasure(i);
            int n5 = tGMeasure.countBeats();
            for (int j = n3; j < n5; ++j) {
                int n6 = 0;
                TGBeat tGBeat = tGMeasure.getBeat(j);
                int n7 = tGBeat.countNotes();
                if (n6 >= n7) continue;
                TGNote tGNote2 = tGBeat.getNote(n6);
                if (tGNote2.getString() == tGNote.getString()) {
                    return tGNote2;
                }
                return null;
            }
            n3 = 0;
        }
        return null;
    }

    private TGNote getPreviousNote(TGNote tGNote, TGTrack tGTrack, int n, int n2) {
        int n3 = n2;
        for (int i = n; i >= 0; --i) {
            TGMeasure tGMeasure = tGTrack.getMeasure(i);
            n3 = n3 < 0 ? tGMeasure.countBeats() : n3;
            for (int j = n3 - 1; j >= 0; --j) {
                TGBeat tGBeat = tGMeasure.getBeat(j);
                for (int k = 0; k < tGBeat.countNotes(); ++k) {
                    TGNote tGNote2 = tGBeat.getNote(k);
                    if (tGNote2.getString() != tGNote.getString()) continue;
                    return tGNote2;
                }
            }
            n3 = -1;
        }
        return null;
    }

    public long fixStart(long l) {
        return l % 500L + 10L > 500L ? l + (500L - l % 500L) : l;
    }

    private class BeatData {
        private long start;
        private long duration;

        public BeatData(long l, long l2) {
            this.start = l;
            this.duration = l2;
        }

        public long getDuration() {
            return this.duration;
        }

        public long getStart() {
            return this.start;
        }
    }
}

